<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class YesnoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/YesnoList[/{keys:.*}]", [PermissionMiddleware::class], "list.yesno")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "YesnoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/YesnoAdd[/{keys:.*}]", [PermissionMiddleware::class], "add.yesno")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "YesnoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/YesnoView[/{keys:.*}]", [PermissionMiddleware::class], "view.yesno")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "YesnoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/YesnoEdit[/{keys:.*}]", [PermissionMiddleware::class], "edit.yesno")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "YesnoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/YesnoDelete[/{keys:.*}]", [PermissionMiddleware::class], "delete.yesno")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "YesnoDelete");
    }

    // Get keys as associative array
    protected function getKeyParams($args)
    {
        global $RouteValues;
        if (array_key_exists("keys", $args)) {
            $sep = Container("yesno")->RouteCompositeKeySeparator;
            $keys = explode($sep, $args["keys"]);
            if (count($keys) == 2) {
                $keyArgs = array_combine(["ChoiceCode","YesNo"], $keys);
                $RouteValues = array_merge(Route(), $keyArgs);
                $args = array_merge($args, $keyArgs);
            }
        }
        return $args;
    }
}
