<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class UserStatusController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/UserStatusList[/{UserStatus}]", [PermissionMiddleware::class], "list.user_status")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserStatusList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/UserStatusAdd[/{UserStatus}]", [PermissionMiddleware::class], "add.user_status")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserStatusAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/UserStatusView[/{UserStatus}]", [PermissionMiddleware::class], "view.user_status")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserStatusView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/UserStatusEdit[/{UserStatus}]", [PermissionMiddleware::class], "edit.user_status")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserStatusEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/UserStatusDelete[/{UserStatus}]", [PermissionMiddleware::class], "delete.user_status")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserStatusDelete");
    }
}
