<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class TrainingAttendeeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/TrainingAttendeeList[/{keys:.*}]", [PermissionMiddleware::class], "list.training_attendee")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "TrainingAttendeeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/TrainingAttendeeAdd[/{keys:.*}]", [PermissionMiddleware::class], "add.training_attendee")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "TrainingAttendeeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/TrainingAttendeeView[/{keys:.*}]", [PermissionMiddleware::class], "view.training_attendee")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "TrainingAttendeeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/TrainingAttendeeEdit[/{keys:.*}]", [PermissionMiddleware::class], "edit.training_attendee")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "TrainingAttendeeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/TrainingAttendeeDelete[/{keys:.*}]", [PermissionMiddleware::class], "delete.training_attendee")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "TrainingAttendeeDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/TrainingAttendeeSearch", [PermissionMiddleware::class], "search.training_attendee")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "TrainingAttendeeSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/TrainingAttendeePreview", [PermissionMiddleware::class], "preview.training_attendee")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "TrainingAttendeePreview", null, false);
    }

    // Get keys as associative array
    protected function getKeyParams($args)
    {
        global $RouteValues;
        if (array_key_exists("keys", $args)) {
            $sep = Container("training_attendee")->RouteCompositeKeySeparator;
            $keys = explode($sep, $args["keys"]);
            if (count($keys) == 2) {
                $keyArgs = array_combine(["TrainingRef","NRC"], $keys);
                $RouteValues = array_merge(Route(), $keyArgs);
                $args = array_merge($args, $keyArgs);
            }
        }
        return $args;
    }
}
