<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class SeedAllocateSrcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/SeedAllocateSrcList[/{ID}]", [PermissionMiddleware::class], "list.seed_allocate_src")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedAllocateSrcList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/SeedAllocateSrcAdd[/{ID}]", [PermissionMiddleware::class], "add.seed_allocate_src")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedAllocateSrcAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/SeedAllocateSrcView[/{ID}]", [PermissionMiddleware::class], "view.seed_allocate_src")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedAllocateSrcView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/SeedAllocateSrcEdit[/{ID}]", [PermissionMiddleware::class], "edit.seed_allocate_src")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedAllocateSrcEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/SeedAllocateSrcDelete[/{ID}]", [PermissionMiddleware::class], "delete.seed_allocate_src")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedAllocateSrcDelete");
    }
}
