<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class Season2021Controller extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/Season2021List", [PermissionMiddleware::class], "list.season20_21")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Season2021List");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/Season2021Search", [PermissionMiddleware::class], "search.season20_21")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Season2021Search");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/Season2021Query", [PermissionMiddleware::class], "query.season20_21")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Season2021Search", "Season2021Query");
    }
}
