<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class QuarterRefController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/QuarterRefList[/{QuarterCode}]", [PermissionMiddleware::class], "list.quarter_ref")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QuarterRefList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/QuarterRefAdd[/{QuarterCode}]", [PermissionMiddleware::class], "add.quarter_ref")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QuarterRefAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/QuarterRefView[/{QuarterCode}]", [PermissionMiddleware::class], "view.quarter_ref")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QuarterRefView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/QuarterRefEdit[/{QuarterCode}]", [PermissionMiddleware::class], "edit.quarter_ref")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QuarterRefEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/QuarterRefDelete[/{QuarterCode}]", [PermissionMiddleware::class], "delete.quarter_ref")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QuarterRefDelete");
    }
}
