<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class NurseryTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/NurseryTypeList[/{NurseryTpeCode}]", [PermissionMiddleware::class], "list.nursery_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/NurseryTypeAdd[/{NurseryTpeCode}]", [PermissionMiddleware::class], "add.nursery_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/NurseryTypeView[/{NurseryTpeCode}]", [PermissionMiddleware::class], "view.nursery_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/NurseryTypeEdit[/{NurseryTpeCode}]", [PermissionMiddleware::class], "edit.nursery_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/NurseryTypeDelete[/{NurseryTpeCode}]", [PermissionMiddleware::class], "delete.nursery_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryTypeDelete");
    }
}
