<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FarmerOrganisationController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FarmerOrganisationList[/{ID}]", [PermissionMiddleware::class], "list.farmer_organisation")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerOrganisationList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FarmerOrganisationAdd[/{ID}]", [PermissionMiddleware::class], "add.farmer_organisation")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerOrganisationAdd");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/FarmerOrganisationPreview", [PermissionMiddleware::class], "preview.farmer_organisation")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerOrganisationPreview", null, false);
    }
}
