<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FarmSeedDeliveredController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedDeliveredList[/{TransDeliveryNo}]", [PermissionMiddleware::class], "list.farm_seed_delivered")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedDeliveredList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedDeliveredAdd[/{TransDeliveryNo}]", [PermissionMiddleware::class], "add.farm_seed_delivered")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedDeliveredAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedDeliveredView[/{TransDeliveryNo}]", [PermissionMiddleware::class], "view.farm_seed_delivered")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedDeliveredView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedDeliveredEdit[/{TransDeliveryNo}]", [PermissionMiddleware::class], "edit.farm_seed_delivered")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedDeliveredEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedDeliveredDelete[/{TransDeliveryNo}]", [PermissionMiddleware::class], "delete.farm_seed_delivered")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedDeliveredDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedDeliveredSearch", [PermissionMiddleware::class], "search.farm_seed_delivered")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedDeliveredSearch");
    }
}
