<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FarmController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FarmList[/{FarmNo}]", [PermissionMiddleware::class], "list.farm")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FarmAdd[/{FarmNo}]", [PermissionMiddleware::class], "add.farm")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/FarmView[/{FarmNo}]", [PermissionMiddleware::class], "view.farm")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/FarmEdit[/{FarmNo}]", [PermissionMiddleware::class], "edit.farm")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/FarmDelete[/{FarmNo}]", [PermissionMiddleware::class], "delete.farm")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/FarmSearch", [PermissionMiddleware::class], "search.farm")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/FarmPreview", [PermissionMiddleware::class], "preview.farm")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmPreview", null, false);
    }
}
