<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FacilitatorController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FacilitatorList[/{FacilitatorNo}]", [PermissionMiddleware::class], "list.facilitator")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FacilitatorList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FacilitatorAdd[/{FacilitatorNo}]", [PermissionMiddleware::class], "add.facilitator")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FacilitatorAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/FacilitatorView[/{FacilitatorNo}]", [PermissionMiddleware::class], "view.facilitator")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FacilitatorView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/FacilitatorEdit[/{FacilitatorNo}]", [PermissionMiddleware::class], "edit.facilitator")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FacilitatorEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/FacilitatorDelete[/{FacilitatorNo}]", [PermissionMiddleware::class], "delete.facilitator")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FacilitatorDelete");
    }
}
