<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class CurrentRefController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/CurrentRefList[/{ID}]", [PermissionMiddleware::class], "list.current_ref")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrentRefList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/CurrentRefAdd[/{ID}]", [PermissionMiddleware::class], "add.current_ref")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrentRefAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/CurrentRefView[/{ID}]", [PermissionMiddleware::class], "view.current_ref")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrentRefView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/CurrentRefEdit[/{ID}]", [PermissionMiddleware::class], "edit.current_ref")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrentRefEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/CurrentRefDelete[/{ID}]", [PermissionMiddleware::class], "delete.current_ref")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrentRefDelete");
    }
}
