<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class AwpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/AwpList[/{LineNo}]", [PermissionMiddleware::class], "list.awp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AwpList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/AwpAdd[/{LineNo}]", [PermissionMiddleware::class], "add.awp")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AwpAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/AwpView[/{LineNo}]", [PermissionMiddleware::class], "view.awp")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AwpView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/AwpEdit[/{LineNo}]", [PermissionMiddleware::class], "edit.awp")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AwpEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/AwpDelete[/{LineNo}]", [PermissionMiddleware::class], "delete.awp")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AwpDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/AwpSearch", [PermissionMiddleware::class], "search.awp")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AwpSearch");
    }
}
