<?php

namespace PHPMaker2024\cidp24;

// Page object
$UserRoleEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fuser_roleedit" id="fuser_roleedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { user_role: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fuser_roleedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fuser_roleedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["Role", [fields.Role.visible && fields.Role.required ? ew.Validators.required(fields.Role.caption) : null], fields.Role.isInvalid],
            ["RoleDescription", [fields.RoleDescription.visible && fields.RoleDescription.required ? ew.Validators.required(fields.RoleDescription.caption) : null], fields.RoleDescription.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="user_role">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->Role->Visible) { // Role ?>
    <div id="r_Role"<?= $Page->Role->rowAttributes() ?>>
        <label id="elh_user_role_Role" for="x_Role" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Role->caption() ?><?= $Page->Role->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Role->cellAttributes() ?>>
<span id="el_user_role_Role">
<input type="<?= $Page->Role->getInputTextType() ?>" name="x_Role" id="x_Role" data-table="user_role" data-field="x_Role" value="<?= $Page->Role->EditValue ?>" size="30" maxlength="15" placeholder="<?= HtmlEncode($Page->Role->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Role->formatPattern()) ?>"<?= $Page->Role->editAttributes() ?> aria-describedby="x_Role_help">
<?= $Page->Role->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Role->getErrorMessage() ?></div>
<input type="hidden" data-table="user_role" data-field="x_Role" data-hidden="1" data-old name="o_Role" id="o_Role" value="<?= HtmlEncode($Page->Role->OldValue ?? $Page->Role->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->RoleDescription->Visible) { // RoleDescription ?>
    <div id="r_RoleDescription"<?= $Page->RoleDescription->rowAttributes() ?>>
        <label id="elh_user_role_RoleDescription" for="x_RoleDescription" class="<?= $Page->LeftColumnClass ?>"><?= $Page->RoleDescription->caption() ?><?= $Page->RoleDescription->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->RoleDescription->cellAttributes() ?>>
<span id="el_user_role_RoleDescription">
<input type="<?= $Page->RoleDescription->getInputTextType() ?>" name="x_RoleDescription" id="x_RoleDescription" data-table="user_role" data-field="x_RoleDescription" value="<?= $Page->RoleDescription->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->RoleDescription->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->RoleDescription->formatPattern()) ?>"<?= $Page->RoleDescription->editAttributes() ?> aria-describedby="x_RoleDescription_help">
<?= $Page->RoleDescription->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->RoleDescription->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fuser_roleedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fuser_roleedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("user_role");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
