<?php

namespace PHPMaker2024\cidp24;

// Page object
$UnitOfMeasureAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { unit_of_measure: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var funit_of_measureadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("funit_of_measureadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["Unit_of_measure", [fields.Unit_of_measure.visible && fields.Unit_of_measure.required ? ew.Validators.required(fields.Unit_of_measure.caption) : null], fields.Unit_of_measure.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="funit_of_measureadd" id="funit_of_measureadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="unit_of_measure">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->Unit_of_measure->Visible) { // Unit_of_measure ?>
    <div id="r_Unit_of_measure"<?= $Page->Unit_of_measure->rowAttributes() ?>>
        <label id="elh_unit_of_measure_Unit_of_measure" for="x_Unit_of_measure" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Unit_of_measure->caption() ?><?= $Page->Unit_of_measure->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Unit_of_measure->cellAttributes() ?>>
<span id="el_unit_of_measure_Unit_of_measure">
<input type="<?= $Page->Unit_of_measure->getInputTextType() ?>" name="x_Unit_of_measure" id="x_Unit_of_measure" data-table="unit_of_measure" data-field="x_Unit_of_measure" value="<?= $Page->Unit_of_measure->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->Unit_of_measure->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Unit_of_measure->formatPattern()) ?>"<?= $Page->Unit_of_measure->editAttributes() ?> aria-describedby="x_Unit_of_measure_help">
<?= $Page->Unit_of_measure->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Unit_of_measure->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="funit_of_measureadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="funit_of_measureadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("unit_of_measure");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
