<?php

namespace PHPMaker2024\cidp24;

// Page object
$TrainingCourseView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
<form name="ftraining_courseview" id="ftraining_courseview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { training_course: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var ftraining_courseview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ftraining_courseview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="training_course">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->TrainingRef->Visible) { // TrainingRef ?>
    <tr id="r_TrainingRef"<?= $Page->TrainingRef->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_training_course_TrainingRef"><?= $Page->TrainingRef->caption() ?></span></td>
        <td data-name="TrainingRef"<?= $Page->TrainingRef->cellAttributes() ?>>
<span id="el_training_course_TrainingRef">
<span<?= $Page->TrainingRef->viewAttributes() ?>>
<?= $Page->TrainingRef->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->TrainingType->Visible) { // TrainingType ?>
    <tr id="r_TrainingType"<?= $Page->TrainingType->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_training_course_TrainingType"><?= $Page->TrainingType->caption() ?></span></td>
        <td data-name="TrainingType"<?= $Page->TrainingType->cellAttributes() ?>>
<span id="el_training_course_TrainingType">
<span<?= $Page->TrainingType->viewAttributes() ?>>
<?= $Page->TrainingType->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->StartDate->Visible) { // StartDate ?>
    <tr id="r_StartDate"<?= $Page->StartDate->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_training_course_StartDate"><?= $Page->StartDate->caption() ?></span></td>
        <td data-name="StartDate"<?= $Page->StartDate->cellAttributes() ?>>
<span id="el_training_course_StartDate">
<span<?= $Page->StartDate->viewAttributes() ?>>
<?= $Page->StartDate->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->EndDate->Visible) { // EndDate ?>
    <tr id="r_EndDate"<?= $Page->EndDate->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_training_course_EndDate"><?= $Page->EndDate->caption() ?></span></td>
        <td data-name="EndDate"<?= $Page->EndDate->cellAttributes() ?>>
<span id="el_training_course_EndDate">
<span<?= $Page->EndDate->viewAttributes() ?>>
<?= $Page->EndDate->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->Institution->Visible) { // Institution ?>
    <tr id="r_Institution"<?= $Page->Institution->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_training_course_Institution"><?= $Page->Institution->caption() ?></span></td>
        <td data-name="Institution"<?= $Page->Institution->cellAttributes() ?>>
<span id="el_training_course_Institution">
<span<?= $Page->Institution->viewAttributes() ?>>
<?= $Page->Institution->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->Subject->Visible) { // Subject ?>
    <tr id="r_Subject"<?= $Page->Subject->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_training_course_Subject"><?= $Page->Subject->caption() ?></span></td>
        <td data-name="Subject"<?= $Page->Subject->cellAttributes() ?>>
<span id="el_training_course_Subject">
<span<?= $Page->Subject->viewAttributes() ?>>
<?= $Page->Subject->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->Facilitators->Visible) { // Facilitators ?>
    <tr id="r_Facilitators"<?= $Page->Facilitators->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_training_course_Facilitators"><?= $Page->Facilitators->caption() ?></span></td>
        <td data-name="Facilitators"<?= $Page->Facilitators->cellAttributes() ?>>
<span id="el_training_course_Facilitators">
<span<?= $Page->Facilitators->viewAttributes() ?>>
<?= $Page->Facilitators->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->TrainingContent->Visible) { // TrainingContent ?>
    <tr id="r_TrainingContent"<?= $Page->TrainingContent->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_training_course_TrainingContent"><?= $Page->TrainingContent->caption() ?></span></td>
        <td data-name="TrainingContent"<?= $Page->TrainingContent->cellAttributes() ?>>
<span id="el_training_course_TrainingContent">
<span<?= $Page->TrainingContent->viewAttributes() ?>>
<?= $Page->TrainingContent->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php
    if (in_array("training_attendee", explode(",", $Page->getCurrentDetailTable())) && $training_attendee->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("training_attendee", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "TrainingAttendeeGrid.php" ?>
<?php } ?>
</form>
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
