<?php

namespace PHPMaker2024\cidp24;

// Page object
$TrainingCourseEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="ftraining_courseedit" id="ftraining_courseedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { training_course: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var ftraining_courseedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ftraining_courseedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["TrainingRef", [fields.TrainingRef.visible && fields.TrainingRef.required ? ew.Validators.required(fields.TrainingRef.caption) : null], fields.TrainingRef.isInvalid],
            ["TrainingType", [fields.TrainingType.visible && fields.TrainingType.required ? ew.Validators.required(fields.TrainingType.caption) : null], fields.TrainingType.isInvalid],
            ["StartDate", [fields.StartDate.visible && fields.StartDate.required ? ew.Validators.required(fields.StartDate.caption) : null, ew.Validators.datetime(fields.StartDate.clientFormatPattern)], fields.StartDate.isInvalid],
            ["EndDate", [fields.EndDate.visible && fields.EndDate.required ? ew.Validators.required(fields.EndDate.caption) : null, ew.Validators.datetime(fields.EndDate.clientFormatPattern)], fields.EndDate.isInvalid],
            ["Institution", [fields.Institution.visible && fields.Institution.required ? ew.Validators.required(fields.Institution.caption) : null], fields.Institution.isInvalid],
            ["Subject", [fields.Subject.visible && fields.Subject.required ? ew.Validators.required(fields.Subject.caption) : null], fields.Subject.isInvalid],
            ["Facilitators", [fields.Facilitators.visible && fields.Facilitators.required ? ew.Validators.required(fields.Facilitators.caption) : null], fields.Facilitators.isInvalid],
            ["TrainingContent", [fields.TrainingContent.visible && fields.TrainingContent.required ? ew.Validators.required(fields.TrainingContent.caption) : null], fields.TrainingContent.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "TrainingType": <?= $Page->TrainingType->toClientList($Page) ?>,
            "Facilitators": <?= $Page->Facilitators->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="training_course">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->TrainingRef->Visible) { // TrainingRef ?>
    <div id="r_TrainingRef"<?= $Page->TrainingRef->rowAttributes() ?>>
        <label id="elh_training_course_TrainingRef" class="<?= $Page->LeftColumnClass ?>"><?= $Page->TrainingRef->caption() ?><?= $Page->TrainingRef->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->TrainingRef->cellAttributes() ?>>
<span id="el_training_course_TrainingRef">
<span<?= $Page->TrainingRef->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->TrainingRef->getDisplayValue($Page->TrainingRef->EditValue))) ?>"></span>
<input type="hidden" data-table="training_course" data-field="x_TrainingRef" data-hidden="1" name="x_TrainingRef" id="x_TrainingRef" value="<?= HtmlEncode($Page->TrainingRef->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->TrainingType->Visible) { // TrainingType ?>
    <div id="r_TrainingType"<?= $Page->TrainingType->rowAttributes() ?>>
        <label id="elh_training_course_TrainingType" for="x_TrainingType" class="<?= $Page->LeftColumnClass ?>"><?= $Page->TrainingType->caption() ?><?= $Page->TrainingType->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->TrainingType->cellAttributes() ?>>
<span id="el_training_course_TrainingType">
    <select
        id="x_TrainingType"
        name="x_TrainingType"
        class="form-select ew-select<?= $Page->TrainingType->isInvalidClass() ?>"
        <?php if (!$Page->TrainingType->IsNativeSelect) { ?>
        data-select2-id="ftraining_courseedit_x_TrainingType"
        <?php } ?>
        data-table="training_course"
        data-field="x_TrainingType"
        data-value-separator="<?= $Page->TrainingType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->TrainingType->getPlaceHolder()) ?>"
        <?= $Page->TrainingType->editAttributes() ?>>
        <?= $Page->TrainingType->selectOptionListHtml("x_TrainingType") ?>
    </select>
    <?= $Page->TrainingType->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->TrainingType->getErrorMessage() ?></div>
<?= $Page->TrainingType->Lookup->getParamTag($Page, "p_x_TrainingType") ?>
<?php if (!$Page->TrainingType->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraining_courseedit", function() {
    var options = { name: "x_TrainingType", selectId: "ftraining_courseedit_x_TrainingType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraining_courseedit.lists.TrainingType?.lookupOptions.length) {
        options.data = { id: "x_TrainingType", form: "ftraining_courseedit" };
    } else {
        options.ajax = { id: "x_TrainingType", form: "ftraining_courseedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.training_course.fields.TrainingType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->StartDate->Visible) { // StartDate ?>
    <div id="r_StartDate"<?= $Page->StartDate->rowAttributes() ?>>
        <label id="elh_training_course_StartDate" for="x_StartDate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->StartDate->caption() ?><?= $Page->StartDate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->StartDate->cellAttributes() ?>>
<span id="el_training_course_StartDate">
<input type="<?= $Page->StartDate->getInputTextType() ?>" name="x_StartDate" id="x_StartDate" data-table="training_course" data-field="x_StartDate" value="<?= $Page->StartDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->StartDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->StartDate->formatPattern()) ?>"<?= $Page->StartDate->editAttributes() ?> aria-describedby="x_StartDate_help">
<?= $Page->StartDate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->StartDate->getErrorMessage() ?></div>
<?php if (!$Page->StartDate->ReadOnly && !$Page->StartDate->Disabled && !isset($Page->StartDate->EditAttrs["readonly"]) && !isset($Page->StartDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftraining_courseedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ftraining_courseedit", "x_StartDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->EndDate->Visible) { // EndDate ?>
    <div id="r_EndDate"<?= $Page->EndDate->rowAttributes() ?>>
        <label id="elh_training_course_EndDate" for="x_EndDate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->EndDate->caption() ?><?= $Page->EndDate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->EndDate->cellAttributes() ?>>
<span id="el_training_course_EndDate">
<input type="<?= $Page->EndDate->getInputTextType() ?>" name="x_EndDate" id="x_EndDate" data-table="training_course" data-field="x_EndDate" value="<?= $Page->EndDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EndDate->formatPattern()) ?>"<?= $Page->EndDate->editAttributes() ?> aria-describedby="x_EndDate_help">
<?= $Page->EndDate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage() ?></div>
<?php if (!$Page->EndDate->ReadOnly && !$Page->EndDate->Disabled && !isset($Page->EndDate->EditAttrs["readonly"]) && !isset($Page->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftraining_courseedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ftraining_courseedit", "x_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Institution->Visible) { // Institution ?>
    <div id="r_Institution"<?= $Page->Institution->rowAttributes() ?>>
        <label id="elh_training_course_Institution" for="x_Institution" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Institution->caption() ?><?= $Page->Institution->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Institution->cellAttributes() ?>>
<span id="el_training_course_Institution">
<input type="<?= $Page->Institution->getInputTextType() ?>" name="x_Institution" id="x_Institution" data-table="training_course" data-field="x_Institution" value="<?= $Page->Institution->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Institution->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Institution->formatPattern()) ?>"<?= $Page->Institution->editAttributes() ?> aria-describedby="x_Institution_help">
<?= $Page->Institution->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Institution->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Subject->Visible) { // Subject ?>
    <div id="r_Subject"<?= $Page->Subject->rowAttributes() ?>>
        <label id="elh_training_course_Subject" for="x_Subject" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Subject->caption() ?><?= $Page->Subject->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Subject->cellAttributes() ?>>
<span id="el_training_course_Subject">
<textarea data-table="training_course" data-field="x_Subject" name="x_Subject" id="x_Subject" cols="35" rows="2" placeholder="<?= HtmlEncode($Page->Subject->getPlaceHolder()) ?>"<?= $Page->Subject->editAttributes() ?> aria-describedby="x_Subject_help"><?= $Page->Subject->EditValue ?></textarea>
<?= $Page->Subject->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Subject->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Facilitators->Visible) { // Facilitators ?>
    <div id="r_Facilitators"<?= $Page->Facilitators->rowAttributes() ?>>
        <label id="elh_training_course_Facilitators" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Facilitators->caption() ?><?= $Page->Facilitators->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Facilitators->cellAttributes() ?>>
<span id="el_training_course_Facilitators">
<template id="tp_x_Facilitators">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="training_course" data-field="x_Facilitators" name="x_Facilitators" id="x_Facilitators"<?= $Page->Facilitators->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_Facilitators" class="ew-item-list"></div>
<selection-list hidden
    id="x_Facilitators[]"
    name="x_Facilitators[]"
    value="<?= HtmlEncode($Page->Facilitators->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_Facilitators"
    data-target="dsl_x_Facilitators"
    data-repeatcolumn="5"
    class="form-control<?= $Page->Facilitators->isInvalidClass() ?>"
    data-table="training_course"
    data-field="x_Facilitators"
    data-value-separator="<?= $Page->Facilitators->displayValueSeparatorAttribute() ?>"
    <?= $Page->Facilitators->editAttributes() ?>></selection-list>
<?= $Page->Facilitators->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Facilitators->getErrorMessage() ?></div>
<?= $Page->Facilitators->Lookup->getParamTag($Page, "p_x_Facilitators") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->TrainingContent->Visible) { // TrainingContent ?>
    <div id="r_TrainingContent"<?= $Page->TrainingContent->rowAttributes() ?>>
        <label id="elh_training_course_TrainingContent" for="x_TrainingContent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->TrainingContent->caption() ?><?= $Page->TrainingContent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->TrainingContent->cellAttributes() ?>>
<span id="el_training_course_TrainingContent">
<textarea data-table="training_course" data-field="x_TrainingContent" name="x_TrainingContent" id="x_TrainingContent" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->TrainingContent->getPlaceHolder()) ?>"<?= $Page->TrainingContent->editAttributes() ?> aria-describedby="x_TrainingContent_help"><?= $Page->TrainingContent->EditValue ?></textarea>
<?= $Page->TrainingContent->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->TrainingContent->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?php
    if (in_array("training_attendee", explode(",", $Page->getCurrentDetailTable())) && $training_attendee->DetailEdit) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("training_attendee", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "TrainingAttendeeGrid.php" ?>
<?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ftraining_courseedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ftraining_courseedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("training_course");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
