<?php

namespace PHPMaker2024\cidp24;

// Page object
$TrainingAttendeeSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { training_attendee: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ftraining_attendeesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ftraining_attendeesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["TrainingRef", [ew.Validators.integer], fields.TrainingRef.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["Evaluation", [], fields.Evaluation.isInvalid],
            ["Rating", [ew.Validators.float], fields.Rating.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ftraining_attendeesearch" id="ftraining_attendeesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="training_attendee">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->TrainingRef->Visible) { // TrainingRef ?>
    <div id="r_TrainingRef" class="row"<?= $Page->TrainingRef->rowAttributes() ?>>
        <label for="x_TrainingRef" class="<?= $Page->LeftColumnClass ?>"><span id="elh_training_attendee_TrainingRef"><?= $Page->TrainingRef->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_TrainingRef" id="z_TrainingRef" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->TrainingRef->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_training_attendee_TrainingRef" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TrainingRef->getInputTextType() ?>" name="x_TrainingRef" id="x_TrainingRef" data-table="training_attendee" data-field="x_TrainingRef" value="<?= $Page->TrainingRef->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TrainingRef->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TrainingRef->formatPattern()) ?>"<?= $Page->TrainingRef->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TrainingRef->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC" class="row"<?= $Page->NRC->rowAttributes() ?>>
        <label for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><span id="elh_training_attendee_NRC"><?= $Page->NRC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NRC" id="z_NRC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NRC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_training_attendee_NRC" class="ew-search-field ew-search-field-single">
    <select
        id="x_NRC"
        name="x_NRC"
        class="form-select ew-select<?= $Page->NRC->isInvalidClass() ?>"
        <?php if (!$Page->NRC->IsNativeSelect) { ?>
        data-select2-id="ftraining_attendeesearch_x_NRC"
        <?php } ?>
        data-table="training_attendee"
        data-field="x_NRC"
        data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
        <?= $Page->NRC->editAttributes() ?>>
        <?= $Page->NRC->selectOptionListHtml("x_NRC") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
<?php if (!$Page->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraining_attendeesearch", function() {
    var options = { name: "x_NRC", selectId: "ftraining_attendeesearch_x_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraining_attendeesearch.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x_NRC", form: "ftraining_attendeesearch" };
    } else {
        options.ajax = { id: "x_NRC", form: "ftraining_attendeesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.training_attendee.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Evaluation->Visible) { // Evaluation ?>
    <div id="r_Evaluation" class="row"<?= $Page->Evaluation->rowAttributes() ?>>
        <label for="x_Evaluation" class="<?= $Page->LeftColumnClass ?>"><span id="elh_training_attendee_Evaluation"><?= $Page->Evaluation->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Evaluation" id="z_Evaluation" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Evaluation->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_training_attendee_Evaluation" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Evaluation->getInputTextType() ?>" name="x_Evaluation" id="x_Evaluation" data-table="training_attendee" data-field="x_Evaluation" value="<?= $Page->Evaluation->EditValue ?>" size="35" maxlength="255" placeholder="<?= HtmlEncode($Page->Evaluation->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Evaluation->formatPattern()) ?>"<?= $Page->Evaluation->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Evaluation->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Rating->Visible) { // Rating ?>
    <div id="r_Rating" class="row"<?= $Page->Rating->rowAttributes() ?>>
        <label for="x_Rating" class="<?= $Page->LeftColumnClass ?>"><span id="elh_training_attendee_Rating"><?= $Page->Rating->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Rating" id="z_Rating" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Rating->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_training_attendee_Rating" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Rating->getInputTextType() ?>" name="x_Rating" id="x_Rating" data-table="training_attendee" data-field="x_Rating" value="<?= $Page->Rating->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Rating->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Rating->formatPattern()) ?>"<?= $Page->Rating->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Rating->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ftraining_attendeesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ftraining_attendeesearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ftraining_attendeesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("training_attendee");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
