<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("TrainingAttendeeGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var ftraining_attendeegrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { training_attendee: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ftraining_attendeegrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["TrainingRef", [fields.TrainingRef.visible && fields.TrainingRef.required ? ew.Validators.required(fields.TrainingRef.caption) : null, ew.Validators.integer], fields.TrainingRef.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["Evaluation", [fields.Evaluation.visible && fields.Evaluation.required ? ew.Validators.required(fields.Evaluation.caption) : null], fields.Evaluation.isInvalid],
            ["Rating", [fields.Rating.visible && fields.Rating.required ? ew.Validators.required(fields.Rating.caption) : null, ew.Validators.float], fields.Rating.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["TrainingRef",false],["NRC",false],["Evaluation",false],["Rating",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "NRC": <?= $Grid->NRC->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="ftraining_attendeegrid" class="ew-form ew-list-form">
<div id="gmp_training_attendee" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_training_attendeegrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->TrainingRef->Visible) { // TrainingRef ?>
        <th data-name="TrainingRef" class="<?= $Grid->TrainingRef->headerCellClass() ?>"><div id="elh_training_attendee_TrainingRef" class="training_attendee_TrainingRef"><?= $Grid->renderFieldHeader($Grid->TrainingRef) ?></div></th>
<?php } ?>
<?php if ($Grid->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Grid->NRC->headerCellClass() ?>"><div id="elh_training_attendee_NRC" class="training_attendee_NRC"><?= $Grid->renderFieldHeader($Grid->NRC) ?></div></th>
<?php } ?>
<?php if ($Grid->Evaluation->Visible) { // Evaluation ?>
        <th data-name="Evaluation" class="<?= $Grid->Evaluation->headerCellClass() ?>"><div id="elh_training_attendee_Evaluation" class="training_attendee_Evaluation"><?= $Grid->renderFieldHeader($Grid->Evaluation) ?></div></th>
<?php } ?>
<?php if ($Grid->Rating->Visible) { // Rating ?>
        <th data-name="Rating" class="<?= $Grid->Rating->headerCellClass() ?>"><div id="elh_training_attendee_Rating" class="training_attendee_Rating"><?= $Grid->renderFieldHeader($Grid->Rating) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->TrainingRef->Visible) { // TrainingRef ?>
        <td data-name="TrainingRef"<?= $Grid->TrainingRef->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->TrainingRef->getSessionValue() != "") { ?>
<span<?= $Grid->TrainingRef->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->TrainingRef->getDisplayValue($Grid->TrainingRef->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_TrainingRef" name="x<?= $Grid->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Grid->TrainingRef->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_TrainingRef" class="el_training_attendee_TrainingRef">
<input type="<?= $Grid->TrainingRef->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TrainingRef" id="x<?= $Grid->RowIndex ?>_TrainingRef" data-table="training_attendee" data-field="x_TrainingRef" value="<?= $Grid->TrainingRef->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->TrainingRef->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TrainingRef->formatPattern()) ?>"<?= $Grid->TrainingRef->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TrainingRef->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="training_attendee" data-field="x_TrainingRef" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_TrainingRef" id="o<?= $Grid->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Grid->TrainingRef->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_TrainingRef" class="el_training_attendee_TrainingRef">
<?php if ($Grid->TrainingRef->getSessionValue() != "") { ?>
<span<?= $Grid->TrainingRef->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->TrainingRef->getDisplayValue($Grid->TrainingRef->EditValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_TrainingRef" name="x<?= $Grid->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Grid->TrainingRef->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<input type="<?= $Grid->TrainingRef->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TrainingRef" id="x<?= $Grid->RowIndex ?>_TrainingRef" data-table="training_attendee" data-field="x_TrainingRef" value="<?= $Grid->TrainingRef->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->TrainingRef->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TrainingRef->formatPattern()) ?>"<?= $Grid->TrainingRef->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TrainingRef->getErrorMessage() ?></div>
<?php } ?>
<input type="hidden" data-table="training_attendee" data-field="x_TrainingRef" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_TrainingRef" id="o<?= $Grid->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Grid->TrainingRef->OldValue ?? $Grid->TrainingRef->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_TrainingRef" class="el_training_attendee_TrainingRef">
<span<?= $Grid->TrainingRef->viewAttributes() ?>>
<?= $Grid->TrainingRef->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="training_attendee" data-field="x_TrainingRef" data-hidden="1" name="ftraining_attendeegrid$x<?= $Grid->RowIndex ?>_TrainingRef" id="ftraining_attendeegrid$x<?= $Grid->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Grid->TrainingRef->FormValue) ?>">
<input type="hidden" data-table="training_attendee" data-field="x_TrainingRef" data-hidden="1" data-old name="ftraining_attendeegrid$o<?= $Grid->RowIndex ?>_TrainingRef" id="ftraining_attendeegrid$o<?= $Grid->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Grid->TrainingRef->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="training_attendee" data-field="x_TrainingRef" data-hidden="1" name="x<?= $Grid->RowIndex ?>_TrainingRef" id="x<?= $Grid->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Grid->TrainingRef->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Grid->NRC->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_NRC" class="el_training_attendee_NRC">
    <select
        id="x<?= $Grid->RowIndex ?>_NRC"
        name="x<?= $Grid->RowIndex ?>_NRC"
        class="form-select ew-select<?= $Grid->NRC->isInvalidClass() ?>"
        <?php if (!$Grid->NRC->IsNativeSelect) { ?>
        data-select2-id="ftraining_attendeegrid_x<?= $Grid->RowIndex ?>_NRC"
        <?php } ?>
        data-table="training_attendee"
        data-field="x_NRC"
        data-value-separator="<?= $Grid->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>"
        <?= $Grid->NRC->editAttributes() ?>>
        <?= $Grid->NRC->selectOptionListHtml("x{$Grid->RowIndex}_NRC") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<?= $Grid->NRC->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NRC") ?>
<?php if (!$Grid->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraining_attendeegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_NRC", selectId: "ftraining_attendeegrid_x<?= $Grid->RowIndex ?>_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraining_attendeegrid.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_NRC", form: "ftraining_attendeegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_NRC", form: "ftraining_attendeegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.training_attendee.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="training_attendee" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NRC" id="o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_NRC" class="el_training_attendee_NRC">
    <select
        id="x<?= $Grid->RowIndex ?>_NRC"
        name="x<?= $Grid->RowIndex ?>_NRC"
        class="form-select ew-select<?= $Grid->NRC->isInvalidClass() ?>"
        <?php if (!$Grid->NRC->IsNativeSelect) { ?>
        data-select2-id="ftraining_attendeegrid_x<?= $Grid->RowIndex ?>_NRC"
        <?php } ?>
        data-table="training_attendee"
        data-field="x_NRC"
        data-value-separator="<?= $Grid->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>"
        <?= $Grid->NRC->editAttributes() ?>>
        <?= $Grid->NRC->selectOptionListHtml("x{$Grid->RowIndex}_NRC") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<?= $Grid->NRC->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NRC") ?>
<?php if (!$Grid->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraining_attendeegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_NRC", selectId: "ftraining_attendeegrid_x<?= $Grid->RowIndex ?>_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraining_attendeegrid.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_NRC", form: "ftraining_attendeegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_NRC", form: "ftraining_attendeegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.training_attendee.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
<input type="hidden" data-table="training_attendee" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NRC" id="o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue ?? $Grid->NRC->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_NRC" class="el_training_attendee_NRC">
<span<?= $Grid->NRC->viewAttributes() ?>>
<?= $Grid->NRC->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="training_attendee" data-field="x_NRC" data-hidden="1" name="ftraining_attendeegrid$x<?= $Grid->RowIndex ?>_NRC" id="ftraining_attendeegrid$x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->FormValue) ?>">
<input type="hidden" data-table="training_attendee" data-field="x_NRC" data-hidden="1" data-old name="ftraining_attendeegrid$o<?= $Grid->RowIndex ?>_NRC" id="ftraining_attendeegrid$o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="training_attendee" data-field="x_NRC" data-hidden="1" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->Evaluation->Visible) { // Evaluation ?>
        <td data-name="Evaluation"<?= $Grid->Evaluation->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_Evaluation" class="el_training_attendee_Evaluation">
<textarea data-table="training_attendee" data-field="x_Evaluation" name="x<?= $Grid->RowIndex ?>_Evaluation" id="x<?= $Grid->RowIndex ?>_Evaluation" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->Evaluation->getPlaceHolder()) ?>"<?= $Grid->Evaluation->editAttributes() ?>><?= $Grid->Evaluation->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->Evaluation->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="training_attendee" data-field="x_Evaluation" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Evaluation" id="o<?= $Grid->RowIndex ?>_Evaluation" value="<?= HtmlEncode($Grid->Evaluation->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_Evaluation" class="el_training_attendee_Evaluation">
<textarea data-table="training_attendee" data-field="x_Evaluation" name="x<?= $Grid->RowIndex ?>_Evaluation" id="x<?= $Grid->RowIndex ?>_Evaluation" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->Evaluation->getPlaceHolder()) ?>"<?= $Grid->Evaluation->editAttributes() ?>><?= $Grid->Evaluation->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->Evaluation->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_Evaluation" class="el_training_attendee_Evaluation">
<span<?= $Grid->Evaluation->viewAttributes() ?>>
<?= $Grid->Evaluation->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="training_attendee" data-field="x_Evaluation" data-hidden="1" name="ftraining_attendeegrid$x<?= $Grid->RowIndex ?>_Evaluation" id="ftraining_attendeegrid$x<?= $Grid->RowIndex ?>_Evaluation" value="<?= HtmlEncode($Grid->Evaluation->FormValue) ?>">
<input type="hidden" data-table="training_attendee" data-field="x_Evaluation" data-hidden="1" data-old name="ftraining_attendeegrid$o<?= $Grid->RowIndex ?>_Evaluation" id="ftraining_attendeegrid$o<?= $Grid->RowIndex ?>_Evaluation" value="<?= HtmlEncode($Grid->Evaluation->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Rating->Visible) { // Rating ?>
        <td data-name="Rating"<?= $Grid->Rating->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_Rating" class="el_training_attendee_Rating">
<input type="<?= $Grid->Rating->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Rating" id="x<?= $Grid->RowIndex ?>_Rating" data-table="training_attendee" data-field="x_Rating" value="<?= $Grid->Rating->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Rating->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Rating->formatPattern()) ?>"<?= $Grid->Rating->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Rating->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="training_attendee" data-field="x_Rating" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Rating" id="o<?= $Grid->RowIndex ?>_Rating" value="<?= HtmlEncode($Grid->Rating->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_Rating" class="el_training_attendee_Rating">
<input type="<?= $Grid->Rating->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Rating" id="x<?= $Grid->RowIndex ?>_Rating" data-table="training_attendee" data-field="x_Rating" value="<?= $Grid->Rating->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Rating->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Rating->formatPattern()) ?>"<?= $Grid->Rating->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Rating->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_training_attendee_Rating" class="el_training_attendee_Rating">
<span<?= $Grid->Rating->viewAttributes() ?>>
<?= $Grid->Rating->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="training_attendee" data-field="x_Rating" data-hidden="1" name="ftraining_attendeegrid$x<?= $Grid->RowIndex ?>_Rating" id="ftraining_attendeegrid$x<?= $Grid->RowIndex ?>_Rating" value="<?= HtmlEncode($Grid->Rating->FormValue) ?>">
<input type="hidden" data-table="training_attendee" data-field="x_Rating" data-hidden="1" data-old name="ftraining_attendeegrid$o<?= $Grid->RowIndex ?>_Rating" id="ftraining_attendeegrid$o<?= $Grid->RowIndex ?>_Rating" value="<?= HtmlEncode($Grid->Rating->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["ftraining_attendeegrid","load"], () => ftraining_attendeegrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ftraining_attendeegrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("training_attendee");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
