<?php

namespace PHPMaker2024\cidp24;

// Page object
$TrainingAttendeeEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="ftraining_attendeeedit" id="ftraining_attendeeedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { training_attendee: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var ftraining_attendeeedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ftraining_attendeeedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["TrainingRef", [fields.TrainingRef.visible && fields.TrainingRef.required ? ew.Validators.required(fields.TrainingRef.caption) : null, ew.Validators.integer], fields.TrainingRef.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["Evaluation", [fields.Evaluation.visible && fields.Evaluation.required ? ew.Validators.required(fields.Evaluation.caption) : null], fields.Evaluation.isInvalid],
            ["Rating", [fields.Rating.visible && fields.Rating.required ? ew.Validators.required(fields.Rating.caption) : null, ew.Validators.float], fields.Rating.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="training_attendee">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "training_course") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="training_course">
<input type="hidden" name="fk_TrainingRef" value="<?= HtmlEncode($Page->TrainingRef->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->TrainingRef->Visible) { // TrainingRef ?>
    <div id="r_TrainingRef"<?= $Page->TrainingRef->rowAttributes() ?>>
        <label id="elh_training_attendee_TrainingRef" for="x_TrainingRef" class="<?= $Page->LeftColumnClass ?>"><?= $Page->TrainingRef->caption() ?><?= $Page->TrainingRef->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->TrainingRef->cellAttributes() ?>>
<span id="el_training_attendee_TrainingRef">
<?php if ($Page->TrainingRef->getSessionValue() != "") { ?>
<span<?= $Page->TrainingRef->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->TrainingRef->getDisplayValue($Page->TrainingRef->EditValue))) ?>"></span>
<input type="hidden" id="x_TrainingRef" name="x_TrainingRef" value="<?= HtmlEncode($Page->TrainingRef->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<input type="<?= $Page->TrainingRef->getInputTextType() ?>" name="x_TrainingRef" id="x_TrainingRef" data-table="training_attendee" data-field="x_TrainingRef" value="<?= $Page->TrainingRef->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TrainingRef->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TrainingRef->formatPattern()) ?>"<?= $Page->TrainingRef->editAttributes() ?> aria-describedby="x_TrainingRef_help">
<?= $Page->TrainingRef->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->TrainingRef->getErrorMessage() ?></div>
<?php } ?>
<input type="hidden" data-table="training_attendee" data-field="x_TrainingRef" data-hidden="1" data-old name="o_TrainingRef" id="o_TrainingRef" value="<?= HtmlEncode($Page->TrainingRef->OldValue ?? $Page->TrainingRef->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC"<?= $Page->NRC->rowAttributes() ?>>
        <label id="elh_training_attendee_NRC" for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NRC->caption() ?><?= $Page->NRC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NRC->cellAttributes() ?>>
<span id="el_training_attendee_NRC">
    <select
        id="x_NRC"
        name="x_NRC"
        class="form-select ew-select<?= $Page->NRC->isInvalidClass() ?>"
        <?php if (!$Page->NRC->IsNativeSelect) { ?>
        data-select2-id="ftraining_attendeeedit_x_NRC"
        <?php } ?>
        data-table="training_attendee"
        data-field="x_NRC"
        data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
        <?= $Page->NRC->editAttributes() ?>>
        <?= $Page->NRC->selectOptionListHtml("x_NRC") ?>
    </select>
    <?= $Page->NRC->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
<?php if (!$Page->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraining_attendeeedit", function() {
    var options = { name: "x_NRC", selectId: "ftraining_attendeeedit_x_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraining_attendeeedit.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x_NRC", form: "ftraining_attendeeedit" };
    } else {
        options.ajax = { id: "x_NRC", form: "ftraining_attendeeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.training_attendee.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
<input type="hidden" data-table="training_attendee" data-field="x_NRC" data-hidden="1" data-old name="o_NRC" id="o_NRC" value="<?= HtmlEncode($Page->NRC->OldValue ?? $Page->NRC->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Evaluation->Visible) { // Evaluation ?>
    <div id="r_Evaluation"<?= $Page->Evaluation->rowAttributes() ?>>
        <label id="elh_training_attendee_Evaluation" for="x_Evaluation" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Evaluation->caption() ?><?= $Page->Evaluation->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Evaluation->cellAttributes() ?>>
<span id="el_training_attendee_Evaluation">
<textarea data-table="training_attendee" data-field="x_Evaluation" name="x_Evaluation" id="x_Evaluation" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->Evaluation->getPlaceHolder()) ?>"<?= $Page->Evaluation->editAttributes() ?> aria-describedby="x_Evaluation_help"><?= $Page->Evaluation->EditValue ?></textarea>
<?= $Page->Evaluation->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Evaluation->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Rating->Visible) { // Rating ?>
    <div id="r_Rating"<?= $Page->Rating->rowAttributes() ?>>
        <label id="elh_training_attendee_Rating" for="x_Rating" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Rating->caption() ?><?= $Page->Rating->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Rating->cellAttributes() ?>>
<span id="el_training_attendee_Rating">
<input type="<?= $Page->Rating->getInputTextType() ?>" name="x_Rating" id="x_Rating" data-table="training_attendee" data-field="x_Rating" value="<?= $Page->Rating->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Rating->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Rating->formatPattern()) ?>"<?= $Page->Rating->editAttributes() ?> aria-describedby="x_Rating_help">
<?= $Page->Rating->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Rating->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ftraining_attendeeedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ftraining_attendeeedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("training_attendee");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
