<?php

namespace PHPMaker2024\cidp24;

// Page object
$TraineeSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { trainee: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ftraineesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ftraineesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ProvinceCode", [], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [], fields.DistrictCode.isInvalid],
            ["CampCode", [], fields.CampCode.isInvalid],
            ["VillageCode", [], fields.VillageCode.isInvalid],
            ["TraineeNo", [ew.Validators.integer], fields.TraineeNo.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["TraineeName", [], fields.TraineeName.isInvalid],
            ["DOB", [ew.Validators.datetime(fields.DOB.clientFormatPattern)], fields.DOB.isInvalid],
            ["Gender", [], fields.Gender.isInvalid],
            ["MaritalStatus", [], fields.MaritalStatus.isInvalid],
            ["PhoneNo", [], fields.PhoneNo.isInvalid],
            ["_Email", [], fields._Email.isInvalid],
            ["Comments", [], fields.Comments.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "MaritalStatus": <?= $Page->MaritalStatus->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ftraineesearch" id="ftraineesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="trainee">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode" class="row"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_ProvinceCode"><?= $Page->ProvinceCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ProvinceCode" id="z_ProvinceCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProvinceCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_ProvinceCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ftraineesearch_x_ProvinceCode"
        <?php } ?>
        data-table="trainee"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage(false) ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraineesearch", function() {
    var options = { name: "x_ProvinceCode", selectId: "ftraineesearch_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraineesearch.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ftraineesearch" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ftraineesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.trainee.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode" class="row"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_DistrictCode"><?= $Page->DistrictCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_DistrictCode" id="z_DistrictCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_DistrictCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ftraineesearch_x_DistrictCode"
        <?php } ?>
        data-table="trainee"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraineesearch", function() {
    var options = { name: "x_DistrictCode", selectId: "ftraineesearch_x_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraineesearch.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ftraineesearch" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ftraineesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.trainee.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode" class="row"<?= $Page->CampCode->rowAttributes() ?>>
        <label for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_CampCode"><?= $Page->CampCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_CampCode" id="z_CampCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->CampCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_CampCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="ftraineesearch_x_CampCode"
        data-table="trainee"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage(false) ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<script>
loadjs.ready("ftraineesearch", function() {
    var options = { name: "x_CampCode", selectId: "ftraineesearch_x_CampCode" };
    if (ftraineesearch.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ftraineesearch" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ftraineesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.trainee.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode" class="row"<?= $Page->VillageCode->rowAttributes() ?>>
        <label for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_VillageCode"><?= $Page->VillageCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_VillageCode" id="z_VillageCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->VillageCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_VillageCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="ftraineesearch_x_VillageCode"
        data-table="trainee"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage(false) ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<script>
loadjs.ready("ftraineesearch", function() {
    var options = { name: "x_VillageCode", selectId: "ftraineesearch_x_VillageCode" };
    if (ftraineesearch.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ftraineesearch" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ftraineesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.trainee.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->TraineeNo->Visible) { // TraineeNo ?>
    <div id="r_TraineeNo" class="row"<?= $Page->TraineeNo->rowAttributes() ?>>
        <label for="x_TraineeNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_TraineeNo"><?= $Page->TraineeNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_TraineeNo" id="z_TraineeNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->TraineeNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_TraineeNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TraineeNo->getInputTextType() ?>" name="x_TraineeNo" id="x_TraineeNo" data-table="trainee" data-field="x_TraineeNo" value="<?= $Page->TraineeNo->EditValue ?>" placeholder="<?= HtmlEncode($Page->TraineeNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TraineeNo->formatPattern()) ?>"<?= $Page->TraineeNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TraineeNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC" class="row"<?= $Page->NRC->rowAttributes() ?>>
        <label for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_NRC"><?= $Page->NRC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NRC" id="z_NRC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NRC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_NRC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x_NRC" id="x_NRC" data-table="trainee" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->TraineeName->Visible) { // TraineeName ?>
    <div id="r_TraineeName" class="row"<?= $Page->TraineeName->rowAttributes() ?>>
        <label for="x_TraineeName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_TraineeName"><?= $Page->TraineeName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TraineeName" id="z_TraineeName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->TraineeName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_TraineeName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TraineeName->getInputTextType() ?>" name="x_TraineeName" id="x_TraineeName" data-table="trainee" data-field="x_TraineeName" value="<?= $Page->TraineeName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->TraineeName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TraineeName->formatPattern()) ?>"<?= $Page->TraineeName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TraineeName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
    <div id="r_DOB" class="row"<?= $Page->DOB->rowAttributes() ?>>
        <label for="x_DOB" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_DOB"><?= $Page->DOB->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_DOB" id="z_DOB" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DOB->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_DOB" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DOB->getInputTextType() ?>" name="x_DOB" id="x_DOB" data-table="trainee" data-field="x_DOB" value="<?= $Page->DOB->EditValue ?>" placeholder="<?= HtmlEncode($Page->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DOB->formatPattern()) ?>"<?= $Page->DOB->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DOB->getErrorMessage(false) ?></div>
<?php if (!$Page->DOB->ReadOnly && !$Page->DOB->Disabled && !isset($Page->DOB->EditAttrs["readonly"]) && !isset($Page->DOB->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftraineesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ftraineesearch", "x_DOB", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender" class="row"<?= $Page->Gender->rowAttributes() ?>>
        <label for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_Gender"><?= $Page->Gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Gender" id="z_Gender" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_Gender" class="ew-search-field ew-search-field-single">
    <select
        id="x_Gender"
        name="x_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="ftraineesearch_x_Gender"
        <?php } ?>
        data-table="trainee"
        data-field="x_Gender"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x_Gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
<?= $Page->Gender->Lookup->getParamTag($Page, "p_x_Gender") ?>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraineesearch", function() {
    var options = { name: "x_Gender", selectId: "ftraineesearch_x_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraineesearch.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x_Gender", form: "ftraineesearch" };
    } else {
        options.ajax = { id: "x_Gender", form: "ftraineesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.trainee.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
    <div id="r_MaritalStatus" class="row"<?= $Page->MaritalStatus->rowAttributes() ?>>
        <label for="x_MaritalStatus" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_MaritalStatus"><?= $Page->MaritalStatus->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_MaritalStatus" id="z_MaritalStatus" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->MaritalStatus->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_MaritalStatus" class="ew-search-field ew-search-field-single">
    <select
        id="x_MaritalStatus"
        name="x_MaritalStatus"
        class="form-select ew-select<?= $Page->MaritalStatus->isInvalidClass() ?>"
        <?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
        data-select2-id="ftraineesearch_x_MaritalStatus"
        <?php } ?>
        data-table="trainee"
        data-field="x_MaritalStatus"
        data-value-separator="<?= $Page->MaritalStatus->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MaritalStatus->getPlaceHolder()) ?>"
        <?= $Page->MaritalStatus->editAttributes() ?>>
        <?= $Page->MaritalStatus->selectOptionListHtml("x_MaritalStatus") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->MaritalStatus->getErrorMessage(false) ?></div>
<?= $Page->MaritalStatus->Lookup->getParamTag($Page, "p_x_MaritalStatus") ?>
<?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraineesearch", function() {
    var options = { name: "x_MaritalStatus", selectId: "ftraineesearch_x_MaritalStatus" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraineesearch.lists.MaritalStatus?.lookupOptions.length) {
        options.data = { id: "x_MaritalStatus", form: "ftraineesearch" };
    } else {
        options.ajax = { id: "x_MaritalStatus", form: "ftraineesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.trainee.fields.MaritalStatus.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PhoneNo->Visible) { // PhoneNo ?>
    <div id="r_PhoneNo" class="row"<?= $Page->PhoneNo->rowAttributes() ?>>
        <label for="x_PhoneNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_PhoneNo"><?= $Page->PhoneNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PhoneNo" id="z_PhoneNo" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PhoneNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_PhoneNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PhoneNo->getInputTextType() ?>" name="x_PhoneNo" id="x_PhoneNo" data-table="trainee" data-field="x_PhoneNo" value="<?= $Page->PhoneNo->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PhoneNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PhoneNo->formatPattern()) ?>"<?= $Page->PhoneNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PhoneNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email" class="row"<?= $Page->_Email->rowAttributes() ?>>
        <label for="x__Email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee__Email"><?= $Page->_Email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__Email" id="z__Email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_Email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee__Email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="trainee" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Comments->Visible) { // Comments ?>
    <div id="r_Comments" class="row"<?= $Page->Comments->rowAttributes() ?>>
        <label for="x_Comments" class="<?= $Page->LeftColumnClass ?>"><span id="elh_trainee_Comments"><?= $Page->Comments->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Comments" id="z_Comments" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Comments->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_trainee_Comments" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Comments->getInputTextType() ?>" name="x_Comments" id="x_Comments" data-table="trainee" data-field="x_Comments" value="<?= $Page->Comments->EditValue ?>" size="35" maxlength="255" placeholder="<?= HtmlEncode($Page->Comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Comments->formatPattern()) ?>"<?= $Page->Comments->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Comments->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ftraineesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ftraineesearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ftraineesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("trainee");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
