<?php

namespace PHPMaker2024\cidp24;

// Page object
$SeedVarietyEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fseed_varietyedit" id="fseed_varietyedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { seed_variety: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fseed_varietyedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fseed_varietyedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["SeedVariety", [fields.SeedVariety.visible && fields.SeedVariety.required ? ew.Validators.required(fields.SeedVariety.caption) : null], fields.SeedVariety.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="seed_variety">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->SeedVariety->Visible) { // SeedVariety ?>
    <div id="r_SeedVariety"<?= $Page->SeedVariety->rowAttributes() ?>>
        <label id="elh_seed_variety_SeedVariety" for="x_SeedVariety" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SeedVariety->caption() ?><?= $Page->SeedVariety->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SeedVariety->cellAttributes() ?>>
<span id="el_seed_variety_SeedVariety">
<input type="<?= $Page->SeedVariety->getInputTextType() ?>" name="x_SeedVariety" id="x_SeedVariety" data-table="seed_variety" data-field="x_SeedVariety" value="<?= $Page->SeedVariety->EditValue ?>" size="30" maxlength="40" placeholder="<?= HtmlEncode($Page->SeedVariety->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedVariety->formatPattern()) ?>"<?= $Page->SeedVariety->editAttributes() ?> aria-describedby="x_SeedVariety_help">
<?= $Page->SeedVariety->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->SeedVariety->getErrorMessage() ?></div>
<input type="hidden" data-table="seed_variety" data-field="x_SeedVariety" data-hidden="1" data-old name="o_SeedVariety" id="o_SeedVariety" value="<?= HtmlEncode($Page->SeedVariety->OldValue ?? $Page->SeedVariety->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fseed_varietyedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fseed_varietyedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("seed_variety");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
