<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("SecurityMatrixGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fsecurity_matrixgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { security_matrix: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fsecurity_matrixgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["UserCode", [fields.UserCode.visible && fields.UserCode.required ? ew.Validators.required(fields.UserCode.caption) : null, ew.Validators.integer], fields.UserCode.isInvalid],
            ["Security_number", [fields.Security_number.visible && fields.Security_number.required ? ew.Validators.required(fields.Security_number.caption) : null], fields.Security_number.isInvalid],
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["UserCode",false],["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Grid->ProvinceCode->toClientList($Grid) ?>,
            "DistrictCode": <?= $Grid->DistrictCode->toClientList($Grid) ?>,
            "CampCode": <?= $Grid->CampCode->toClientList($Grid) ?>,
            "VillageCode": <?= $Grid->VillageCode->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fsecurity_matrixgrid" class="ew-form ew-list-form">
<div id="gmp_security_matrix" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_security_matrixgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->UserCode->Visible) { // UserCode ?>
        <th data-name="UserCode" class="<?= $Grid->UserCode->headerCellClass() ?>"><div id="elh_security_matrix_UserCode" class="security_matrix_UserCode"><?= $Grid->renderFieldHeader($Grid->UserCode) ?></div></th>
<?php } ?>
<?php if ($Grid->Security_number->Visible) { // Security_number ?>
        <th data-name="Security_number" class="<?= $Grid->Security_number->headerCellClass() ?>"><div id="elh_security_matrix_Security_number" class="security_matrix_Security_number"><?= $Grid->renderFieldHeader($Grid->Security_number) ?></div></th>
<?php } ?>
<?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Grid->ProvinceCode->headerCellClass() ?>"><div id="elh_security_matrix_ProvinceCode" class="security_matrix_ProvinceCode"><?= $Grid->renderFieldHeader($Grid->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Grid->DistrictCode->headerCellClass() ?>"><div id="elh_security_matrix_DistrictCode" class="security_matrix_DistrictCode"><?= $Grid->renderFieldHeader($Grid->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Grid->CampCode->headerCellClass() ?>"><div id="elh_security_matrix_CampCode" class="security_matrix_CampCode"><?= $Grid->renderFieldHeader($Grid->CampCode) ?></div></th>
<?php } ?>
<?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Grid->VillageCode->headerCellClass() ?>"><div id="elh_security_matrix_VillageCode" class="security_matrix_VillageCode"><?= $Grid->renderFieldHeader($Grid->VillageCode) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->UserCode->Visible) { // UserCode ?>
        <td data-name="UserCode"<?= $Grid->UserCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->UserCode->getSessionValue() != "") { ?>
<span<?= $Grid->UserCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->UserCode->getDisplayValue($Grid->UserCode->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_UserCode" name="x<?= $Grid->RowIndex ?>_UserCode" value="<?= HtmlEncode($Grid->UserCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_UserCode" class="el_security_matrix_UserCode">
<input type="<?= $Grid->UserCode->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_UserCode" id="x<?= $Grid->RowIndex ?>_UserCode" data-table="security_matrix" data-field="x_UserCode" value="<?= $Grid->UserCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->UserCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->UserCode->formatPattern()) ?>"<?= $Grid->UserCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->UserCode->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="security_matrix" data-field="x_UserCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_UserCode" id="o<?= $Grid->RowIndex ?>_UserCode" value="<?= HtmlEncode($Grid->UserCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->UserCode->getSessionValue() != "") { ?>
<span<?= $Grid->UserCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->UserCode->getDisplayValue($Grid->UserCode->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_UserCode" name="x<?= $Grid->RowIndex ?>_UserCode" value="<?= HtmlEncode($Grid->UserCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_UserCode" class="el_security_matrix_UserCode">
<input type="<?= $Grid->UserCode->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_UserCode" id="x<?= $Grid->RowIndex ?>_UserCode" data-table="security_matrix" data-field="x_UserCode" value="<?= $Grid->UserCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->UserCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->UserCode->formatPattern()) ?>"<?= $Grid->UserCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->UserCode->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_UserCode" class="el_security_matrix_UserCode">
<span<?= $Grid->UserCode->viewAttributes() ?>>
<?= $Grid->UserCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="security_matrix" data-field="x_UserCode" data-hidden="1" name="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_UserCode" id="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_UserCode" value="<?= HtmlEncode($Grid->UserCode->FormValue) ?>">
<input type="hidden" data-table="security_matrix" data-field="x_UserCode" data-hidden="1" data-old name="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_UserCode" id="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_UserCode" value="<?= HtmlEncode($Grid->UserCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Security_number->Visible) { // Security_number ?>
        <td data-name="Security_number"<?= $Grid->Security_number->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_Security_number" class="el_security_matrix_Security_number"></span>
<input type="hidden" data-table="security_matrix" data-field="x_Security_number" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Security_number" id="o<?= $Grid->RowIndex ?>_Security_number" value="<?= HtmlEncode($Grid->Security_number->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_Security_number" class="el_security_matrix_Security_number">
<span<?= $Grid->Security_number->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->Security_number->getDisplayValue($Grid->Security_number->EditValue))) ?>"></span>
<input type="hidden" data-table="security_matrix" data-field="x_Security_number" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Security_number" id="x<?= $Grid->RowIndex ?>_Security_number" value="<?= HtmlEncode($Grid->Security_number->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_Security_number" class="el_security_matrix_Security_number">
<span<?= $Grid->Security_number->viewAttributes() ?>>
<?= $Grid->Security_number->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="security_matrix" data-field="x_Security_number" data-hidden="1" name="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_Security_number" id="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_Security_number" value="<?= HtmlEncode($Grid->Security_number->FormValue) ?>">
<input type="hidden" data-table="security_matrix" data-field="x_Security_number" data-hidden="1" data-old name="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_Security_number" id="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_Security_number" value="<?= HtmlEncode($Grid->Security_number->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="security_matrix" data-field="x_Security_number" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Security_number" id="x<?= $Grid->RowIndex ?>_Security_number" value="<?= HtmlEncode($Grid->Security_number->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Grid->ProvinceCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_ProvinceCode" class="el_security_matrix_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="security_matrix"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fsecurity_matrixgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsecurity_matrixgrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fsecurity_matrixgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fsecurity_matrixgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.security_matrix.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="security_matrix" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProvinceCode" id="o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_ProvinceCode" class="el_security_matrix_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="security_matrix"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fsecurity_matrixgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsecurity_matrixgrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fsecurity_matrixgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fsecurity_matrixgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.security_matrix.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_ProvinceCode" class="el_security_matrix_ProvinceCode">
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<?= $Grid->ProvinceCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="security_matrix" data-field="x_ProvinceCode" data-hidden="1" name="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_ProvinceCode" id="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->FormValue) ?>">
<input type="hidden" data-table="security_matrix" data-field="x_ProvinceCode" data-hidden="1" data-old name="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_ProvinceCode" id="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Grid->DistrictCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_DistrictCode" class="el_security_matrix_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        data-select2-id="fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        data-table="security_matrix"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("fsecurity_matrixgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_DistrictCode" };
    if (fsecurity_matrixgrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fsecurity_matrixgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fsecurity_matrixgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="security_matrix" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DistrictCode" id="o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_DistrictCode" class="el_security_matrix_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        data-select2-id="fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        data-table="security_matrix"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("fsecurity_matrixgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_DistrictCode" };
    if (fsecurity_matrixgrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fsecurity_matrixgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fsecurity_matrixgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_DistrictCode" class="el_security_matrix_DistrictCode">
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<?= $Grid->DistrictCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="security_matrix" data-field="x_DistrictCode" data-hidden="1" name="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_DistrictCode" id="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->FormValue) ?>">
<input type="hidden" data-table="security_matrix" data-field="x_DistrictCode" data-hidden="1" data-old name="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_DistrictCode" id="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Grid->CampCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_CampCode" class="el_security_matrix_CampCode">
    <select
        id="x<?= $Grid->RowIndex ?>_CampCode"
        name="x<?= $Grid->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Grid->CampCode->isInvalidClass() ?>"
        data-select2-id="fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_CampCode"
        data-table="security_matrix"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->CampCode->editAttributes() ?>>
        <?= $Grid->CampCode->selectOptionListHtml("x{$Grid->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->CampCode->getErrorMessage() ?></div>
<?= $Grid->CampCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("fsecurity_matrixgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_CampCode", selectId: "fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_CampCode" };
    if (fsecurity_matrixgrid.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "fsecurity_matrixgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "fsecurity_matrixgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="security_matrix" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_CampCode" id="o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_CampCode" class="el_security_matrix_CampCode">
    <select
        id="x<?= $Grid->RowIndex ?>_CampCode"
        name="x<?= $Grid->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Grid->CampCode->isInvalidClass() ?>"
        data-select2-id="fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_CampCode"
        data-table="security_matrix"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->CampCode->editAttributes() ?>>
        <?= $Grid->CampCode->selectOptionListHtml("x{$Grid->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->CampCode->getErrorMessage() ?></div>
<?= $Grid->CampCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("fsecurity_matrixgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_CampCode", selectId: "fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_CampCode" };
    if (fsecurity_matrixgrid.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "fsecurity_matrixgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "fsecurity_matrixgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_CampCode" class="el_security_matrix_CampCode">
<span<?= $Grid->CampCode->viewAttributes() ?>>
<?= $Grid->CampCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="security_matrix" data-field="x_CampCode" data-hidden="1" name="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_CampCode" id="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->FormValue) ?>">
<input type="hidden" data-table="security_matrix" data-field="x_CampCode" data-hidden="1" data-old name="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_CampCode" id="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Grid->VillageCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_VillageCode" class="el_security_matrix_VillageCode">
    <select
        id="x<?= $Grid->RowIndex ?>_VillageCode"
        name="x<?= $Grid->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Grid->VillageCode->isInvalidClass() ?>"
        data-select2-id="fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_VillageCode"
        data-table="security_matrix"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->VillageCode->getPlaceHolder()) ?>"
        <?= $Grid->VillageCode->editAttributes() ?>>
        <?= $Grid->VillageCode->selectOptionListHtml("x{$Grid->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->VillageCode->getErrorMessage() ?></div>
<?= $Grid->VillageCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("fsecurity_matrixgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_VillageCode", selectId: "fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_VillageCode" };
    if (fsecurity_matrixgrid.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "fsecurity_matrixgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "fsecurity_matrixgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="security_matrix" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_VillageCode" id="o<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_VillageCode" class="el_security_matrix_VillageCode">
    <select
        id="x<?= $Grid->RowIndex ?>_VillageCode"
        name="x<?= $Grid->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Grid->VillageCode->isInvalidClass() ?>"
        data-select2-id="fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_VillageCode"
        data-table="security_matrix"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->VillageCode->getPlaceHolder()) ?>"
        <?= $Grid->VillageCode->editAttributes() ?>>
        <?= $Grid->VillageCode->selectOptionListHtml("x{$Grid->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->VillageCode->getErrorMessage() ?></div>
<?= $Grid->VillageCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("fsecurity_matrixgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_VillageCode", selectId: "fsecurity_matrixgrid_x<?= $Grid->RowIndex ?>_VillageCode" };
    if (fsecurity_matrixgrid.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "fsecurity_matrixgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "fsecurity_matrixgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_security_matrix_VillageCode" class="el_security_matrix_VillageCode">
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<?= $Grid->VillageCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="security_matrix" data-field="x_VillageCode" data-hidden="1" name="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_VillageCode" id="fsecurity_matrixgrid$x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->FormValue) ?>">
<input type="hidden" data-table="security_matrix" data-field="x_VillageCode" data-hidden="1" data-old name="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_VillageCode" id="fsecurity_matrixgrid$o<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fsecurity_matrixgrid","load"], () => fsecurity_matrixgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fsecurity_matrixgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("security_matrix");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
