<?php

namespace PHPMaker2024\cidp24;

// Page object
$SecurityMatrixEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fsecurity_matrixedit" id="fsecurity_matrixedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { security_matrix: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fsecurity_matrixedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fsecurity_matrixedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["UserCode", [fields.UserCode.visible && fields.UserCode.required ? ew.Validators.required(fields.UserCode.caption) : null, ew.Validators.integer], fields.UserCode.isInvalid],
            ["Security_number", [fields.Security_number.visible && fields.Security_number.required ? ew.Validators.required(fields.Security_number.caption) : null], fields.Security_number.isInvalid],
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="security_matrix">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "musers") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="musers">
<input type="hidden" name="fk_UserCode" value="<?= HtmlEncode($Page->UserCode->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->UserCode->Visible) { // UserCode ?>
    <div id="r_UserCode"<?= $Page->UserCode->rowAttributes() ?>>
        <label id="elh_security_matrix_UserCode" for="x_UserCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->UserCode->caption() ?><?= $Page->UserCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->UserCode->cellAttributes() ?>>
<?php if ($Page->UserCode->getSessionValue() != "") { ?>
<span<?= $Page->UserCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->UserCode->getDisplayValue($Page->UserCode->ViewValue))) ?>"></span>
<input type="hidden" id="x_UserCode" name="x_UserCode" value="<?= HtmlEncode($Page->UserCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_security_matrix_UserCode">
<input type="<?= $Page->UserCode->getInputTextType() ?>" name="x_UserCode" id="x_UserCode" data-table="security_matrix" data-field="x_UserCode" value="<?= $Page->UserCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->UserCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->UserCode->formatPattern()) ?>"<?= $Page->UserCode->editAttributes() ?> aria-describedby="x_UserCode_help">
<?= $Page->UserCode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->UserCode->getErrorMessage() ?></div>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Security_number->Visible) { // Security_number ?>
    <div id="r_Security_number"<?= $Page->Security_number->rowAttributes() ?>>
        <label id="elh_security_matrix_Security_number" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Security_number->caption() ?><?= $Page->Security_number->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Security_number->cellAttributes() ?>>
<span id="el_security_matrix_Security_number">
<span<?= $Page->Security_number->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->Security_number->getDisplayValue($Page->Security_number->EditValue))) ?>"></span>
<input type="hidden" data-table="security_matrix" data-field="x_Security_number" data-hidden="1" name="x_Security_number" id="x_Security_number" value="<?= HtmlEncode($Page->Security_number->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label id="elh_security_matrix_ProvinceCode" for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceCode->caption() ?><?= $Page->ProvinceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceCode->cellAttributes() ?>>
<span id="el_security_matrix_ProvinceCode">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="fsecurity_matrixedit_x_ProvinceCode"
        <?php } ?>
        data-table="security_matrix"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <?= $Page->ProvinceCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fsecurity_matrixedit", function() {
    var options = { name: "x_ProvinceCode", selectId: "fsecurity_matrixedit_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsecurity_matrixedit.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "fsecurity_matrixedit" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "fsecurity_matrixedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.security_matrix.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label id="elh_security_matrix_DistrictCode" for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictCode->caption() ?><?= $Page->DistrictCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="el_security_matrix_DistrictCode">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="fsecurity_matrixedit_x_DistrictCode"
        data-table="security_matrix"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <?= $Page->DistrictCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<script>
loadjs.ready("fsecurity_matrixedit", function() {
    var options = { name: "x_DistrictCode", selectId: "fsecurity_matrixedit_x_DistrictCode" };
    if (fsecurity_matrixedit.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "fsecurity_matrixedit" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "fsecurity_matrixedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode"<?= $Page->CampCode->rowAttributes() ?>>
        <label id="elh_security_matrix_CampCode" for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CampCode->caption() ?><?= $Page->CampCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CampCode->cellAttributes() ?>>
<span id="el_security_matrix_CampCode">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="fsecurity_matrixedit_x_CampCode"
        data-table="security_matrix"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <?= $Page->CampCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<script>
loadjs.ready("fsecurity_matrixedit", function() {
    var options = { name: "x_CampCode", selectId: "fsecurity_matrixedit_x_CampCode" };
    if (fsecurity_matrixedit.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "fsecurity_matrixedit" };
    } else {
        options.ajax = { id: "x_CampCode", form: "fsecurity_matrixedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode"<?= $Page->VillageCode->rowAttributes() ?>>
        <label id="elh_security_matrix_VillageCode" for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->VillageCode->caption() ?><?= $Page->VillageCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->VillageCode->cellAttributes() ?>>
<span id="el_security_matrix_VillageCode">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="fsecurity_matrixedit_x_VillageCode"
        data-table="security_matrix"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <?= $Page->VillageCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<script>
loadjs.ready("fsecurity_matrixedit", function() {
    var options = { name: "x_VillageCode", selectId: "fsecurity_matrixedit_x_VillageCode" };
    if (fsecurity_matrixedit.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "fsecurity_matrixedit" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "fsecurity_matrixedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsecurity_matrixedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fsecurity_matrixedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("security_matrix");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
