<?php

namespace PHPMaker2024\cidp24;

// Page object
$Season2021Search = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { season20_21: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fseason20_21search, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fseason20_21search")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["SerialNo", [ew.Validators.integer], fields.SerialNo.isInvalid],
            ["IPC", [], fields.IPC.isInvalid],
            ["PageNo", [ew.Validators.integer], fields.PageNo.isInvalid],
            ["Activity", [], fields.Activity.isInvalid],
            ["District", [], fields.District.isInvalid],
            ["Block", [], fields.Block.isInvalid],
            ["Camp", [], fields.Camp.isInvalid],
            ["NurseryArea", [], fields.NurseryArea.isInvalid],
            ["Zone", [], fields.Zone.isInvalid],
            ["ChiefArea", [], fields.ChiefArea.isInvalid],
            ["Date", [], fields.Date.isInvalid],
            ["Village", [], fields.Village.isInvalid],
            ["NameOfFarmer", [], fields.NameOfFarmer.isInvalid],
            ["YearOfBirth", [ew.Validators.integer], fields.YearOfBirth.isInvalid],
            ["Gender", [], fields.Gender.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["SeedlingsReceived20_21", [ew.Validators.integer], fields.SeedlingsReceived20_21.isInvalid],
            ["FieldType", [], fields.FieldType.isInvalid],
            ["Contact", [], fields.Contact.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fseason20_21search" id="fseason20_21search" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="season20_21">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->SerialNo->Visible) { // SerialNo ?>
    <div id="r_SerialNo" class="row"<?= $Page->SerialNo->rowAttributes() ?>>
        <label for="x_SerialNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_SerialNo"><?= $Page->SerialNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SerialNo" id="z_SerialNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SerialNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_SerialNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SerialNo->getInputTextType() ?>" name="x_SerialNo" id="x_SerialNo" data-table="season20_21" data-field="x_SerialNo" value="<?= $Page->SerialNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SerialNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SerialNo->formatPattern()) ?>"<?= $Page->SerialNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SerialNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->IPC->Visible) { // IPC ?>
    <div id="r_IPC" class="row"<?= $Page->IPC->rowAttributes() ?>>
        <label for="x_IPC" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_IPC"><?= $Page->IPC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_IPC" id="z_IPC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->IPC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_IPC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->IPC->getInputTextType() ?>" name="x_IPC" id="x_IPC" data-table="season20_21" data-field="x_IPC" value="<?= $Page->IPC->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->IPC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->IPC->formatPattern()) ?>"<?= $Page->IPC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->IPC->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PageNo->Visible) { // PageNo ?>
    <div id="r_PageNo" class="row"<?= $Page->PageNo->rowAttributes() ?>>
        <label for="x_PageNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_PageNo"><?= $Page->PageNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_PageNo" id="z_PageNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PageNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_PageNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PageNo->getInputTextType() ?>" name="x_PageNo" id="x_PageNo" data-table="season20_21" data-field="x_PageNo" value="<?= $Page->PageNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PageNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PageNo->formatPattern()) ?>"<?= $Page->PageNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PageNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Activity->Visible) { // Activity ?>
    <div id="r_Activity" class="row"<?= $Page->Activity->rowAttributes() ?>>
        <label for="x_Activity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_Activity"><?= $Page->Activity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Activity" id="z_Activity" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Activity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_Activity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Activity->getInputTextType() ?>" name="x_Activity" id="x_Activity" data-table="season20_21" data-field="x_Activity" value="<?= $Page->Activity->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Activity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Activity->formatPattern()) ?>"<?= $Page->Activity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Activity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->District->Visible) { // District ?>
    <div id="r_District" class="row"<?= $Page->District->rowAttributes() ?>>
        <label for="x_District" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_District"><?= $Page->District->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_District" id="z_District" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->District->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_District" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->District->getInputTextType() ?>" name="x_District" id="x_District" data-table="season20_21" data-field="x_District" value="<?= $Page->District->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->District->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->District->formatPattern()) ?>"<?= $Page->District->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->District->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Block->Visible) { // Block ?>
    <div id="r_Block" class="row"<?= $Page->Block->rowAttributes() ?>>
        <label for="x_Block" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_Block"><?= $Page->Block->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Block" id="z_Block" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Block->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_Block" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Block->getInputTextType() ?>" name="x_Block" id="x_Block" data-table="season20_21" data-field="x_Block" value="<?= $Page->Block->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Block->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Block->formatPattern()) ?>"<?= $Page->Block->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Block->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Camp->Visible) { // Camp ?>
    <div id="r_Camp" class="row"<?= $Page->Camp->rowAttributes() ?>>
        <label for="x_Camp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_Camp"><?= $Page->Camp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Camp" id="z_Camp" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Camp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_Camp" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Camp->getInputTextType() ?>" name="x_Camp" id="x_Camp" data-table="season20_21" data-field="x_Camp" value="<?= $Page->Camp->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Camp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Camp->formatPattern()) ?>"<?= $Page->Camp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Camp->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NurseryArea->Visible) { // NurseryArea ?>
    <div id="r_NurseryArea" class="row"<?= $Page->NurseryArea->rowAttributes() ?>>
        <label for="x_NurseryArea" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_NurseryArea"><?= $Page->NurseryArea->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NurseryArea" id="z_NurseryArea" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NurseryArea->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_NurseryArea" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NurseryArea->getInputTextType() ?>" name="x_NurseryArea" id="x_NurseryArea" data-table="season20_21" data-field="x_NurseryArea" value="<?= $Page->NurseryArea->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NurseryArea->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NurseryArea->formatPattern()) ?>"<?= $Page->NurseryArea->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NurseryArea->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Zone->Visible) { // Zone ?>
    <div id="r_Zone" class="row"<?= $Page->Zone->rowAttributes() ?>>
        <label for="x_Zone" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_Zone"><?= $Page->Zone->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Zone" id="z_Zone" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Zone->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_Zone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Zone->getInputTextType() ?>" name="x_Zone" id="x_Zone" data-table="season20_21" data-field="x_Zone" value="<?= $Page->Zone->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Zone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Zone->formatPattern()) ?>"<?= $Page->Zone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Zone->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ChiefArea->Visible) { // ChiefArea ?>
    <div id="r_ChiefArea" class="row"<?= $Page->ChiefArea->rowAttributes() ?>>
        <label for="x_ChiefArea" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_ChiefArea"><?= $Page->ChiefArea->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ChiefArea" id="z_ChiefArea" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ChiefArea->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_ChiefArea" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ChiefArea->getInputTextType() ?>" name="x_ChiefArea" id="x_ChiefArea" data-table="season20_21" data-field="x_ChiefArea" value="<?= $Page->ChiefArea->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->ChiefArea->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ChiefArea->formatPattern()) ?>"<?= $Page->ChiefArea->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ChiefArea->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Date->Visible) { // Date ?>
    <div id="r_Date" class="row"<?= $Page->Date->rowAttributes() ?>>
        <label for="x_Date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_Date"><?= $Page->Date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Date" id="z_Date" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Date->getInputTextType() ?>" name="x_Date" id="x_Date" data-table="season20_21" data-field="x_Date" value="<?= $Page->Date->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Date->formatPattern()) ?>"<?= $Page->Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Date->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
    <div id="r_Village" class="row"<?= $Page->Village->rowAttributes() ?>>
        <label for="x_Village" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_Village"><?= $Page->Village->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Village" id="z_Village" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Village->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_Village" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Village->getInputTextType() ?>" name="x_Village" id="x_Village" data-table="season20_21" data-field="x_Village" value="<?= $Page->Village->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Village->formatPattern()) ?>"<?= $Page->Village->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Village->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NameOfFarmer->Visible) { // NameOfFarmer ?>
    <div id="r_NameOfFarmer" class="row"<?= $Page->NameOfFarmer->rowAttributes() ?>>
        <label for="x_NameOfFarmer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_NameOfFarmer"><?= $Page->NameOfFarmer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NameOfFarmer" id="z_NameOfFarmer" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NameOfFarmer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_NameOfFarmer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NameOfFarmer->getInputTextType() ?>" name="x_NameOfFarmer" id="x_NameOfFarmer" data-table="season20_21" data-field="x_NameOfFarmer" value="<?= $Page->NameOfFarmer->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NameOfFarmer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NameOfFarmer->formatPattern()) ?>"<?= $Page->NameOfFarmer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NameOfFarmer->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->YearOfBirth->Visible) { // YearOfBirth ?>
    <div id="r_YearOfBirth" class="row"<?= $Page->YearOfBirth->rowAttributes() ?>>
        <label for="x_YearOfBirth" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_YearOfBirth"><?= $Page->YearOfBirth->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_YearOfBirth" id="z_YearOfBirth" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->YearOfBirth->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_YearOfBirth" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->YearOfBirth->getInputTextType() ?>" name="x_YearOfBirth" id="x_YearOfBirth" data-table="season20_21" data-field="x_YearOfBirth" value="<?= $Page->YearOfBirth->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->YearOfBirth->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->YearOfBirth->formatPattern()) ?>"<?= $Page->YearOfBirth->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->YearOfBirth->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender" class="row"<?= $Page->Gender->rowAttributes() ?>>
        <label for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_Gender"><?= $Page->Gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Gender" id="z_Gender" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_Gender" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Gender->getInputTextType() ?>" name="x_Gender" id="x_Gender" data-table="season20_21" data-field="x_Gender" value="<?= $Page->Gender->EditValue ?>" size="30" maxlength="6" placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Gender->formatPattern()) ?>"<?= $Page->Gender->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC" class="row"<?= $Page->NRC->rowAttributes() ?>>
        <label for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_NRC"><?= $Page->NRC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NRC" id="z_NRC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NRC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_NRC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x_NRC" id="x_NRC" data-table="season20_21" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SeedlingsReceived20_21->Visible) { // SeedlingsReceived20_21 ?>
    <div id="r_SeedlingsReceived20_21" class="row"<?= $Page->SeedlingsReceived20_21->rowAttributes() ?>>
        <label for="x_SeedlingsReceived20_21" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_SeedlingsReceived20_21"><?= $Page->SeedlingsReceived20_21->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SeedlingsReceived20_21" id="z_SeedlingsReceived20_21" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SeedlingsReceived20_21->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_SeedlingsReceived20_21" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedlingsReceived20_21->getInputTextType() ?>" name="x_SeedlingsReceived20_21" id="x_SeedlingsReceived20_21" data-table="season20_21" data-field="x_SeedlingsReceived20_21" value="<?= $Page->SeedlingsReceived20_21->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsReceived20_21->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsReceived20_21->formatPattern()) ?>"<?= $Page->SeedlingsReceived20_21->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedlingsReceived20_21->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
    <div id="r_FieldType" class="row"<?= $Page->FieldType->rowAttributes() ?>>
        <label for="x_FieldType" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_FieldType"><?= $Page->FieldType->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_FieldType" id="z_FieldType" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FieldType->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_FieldType" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FieldType->getInputTextType() ?>" name="x_FieldType" id="x_FieldType" data-table="season20_21" data-field="x_FieldType" value="<?= $Page->FieldType->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->FieldType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FieldType->formatPattern()) ?>"<?= $Page->FieldType->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FieldType->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Contact->Visible) { // Contact ?>
    <div id="r_Contact" class="row"<?= $Page->Contact->rowAttributes() ?>>
        <label for="x_Contact" class="<?= $Page->LeftColumnClass ?>"><span id="elh_season20_21_Contact"><?= $Page->Contact->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Contact" id="z_Contact" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Contact->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_season20_21_Contact" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Contact->getInputTextType() ?>" name="x_Contact" id="x_Contact" data-table="season20_21" data-field="x_Contact" value="<?= $Page->Contact->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Contact->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Contact->formatPattern()) ?>"<?= $Page->Contact->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Contact->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fseason20_21search"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fseason20_21search"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fseason20_21search" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("season20_21");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
