<?php

namespace PHPMaker2024\cidp24;

// Page object
$ProductionSalesPreview = &$Page;
?>
<script>
ew.deepAssign(ew.vars, { tables: { production_sales: <?= JsonEncode($Page->toClientVar()) ?> } });
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php if ($Page->TotalRecords > 0) { ?>
<div class="card ew-grid <?= $Page->TableGridClass ?>"><!-- .card -->
<div class="card-header ew-grid-upper-panel ew-preview-upper-panel"><!-- .card-header -->
<?= $Page->Pager->render() ?>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card-header -->
<div class="card-body ew-preview-middle-panel ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>"><!-- .card-body -->
<table class="<?= $Page->TableClass ?>"><!-- .table -->
    <thead><!-- Table header -->
        <tr class="ew-table-header">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
    <?php if (!$Page->FarmNo->Sortable || !$Page->sortUrl($Page->FarmNo)) { ?>
        <th class="<?= $Page->FarmNo->headerCellClass() ?>"><?= $Page->FarmNo->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->FarmNo->headerCellClass() ?>"><div role="button" data-table="production_sales" data-sort="<?= HtmlEncode($Page->FarmNo->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->FarmNo->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->FarmNo->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->FarmNo->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <?php if (!$Page->NRC->Sortable || !$Page->sortUrl($Page->NRC)) { ?>
        <th class="<?= $Page->NRC->headerCellClass() ?>"><?= $Page->NRC->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->NRC->headerCellClass() ?>"><div role="button" data-table="production_sales" data-sort="<?= HtmlEncode($Page->NRC->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->NRC->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->NRC->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->NRC->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->SeasonYear->Visible) { // SeasonYear ?>
    <?php if (!$Page->SeasonYear->Sortable || !$Page->sortUrl($Page->SeasonYear)) { ?>
        <th class="<?= $Page->SeasonYear->headerCellClass() ?>"><?= $Page->SeasonYear->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->SeasonYear->headerCellClass() ?>"><div role="button" data-table="production_sales" data-sort="<?= HtmlEncode($Page->SeasonYear->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->SeasonYear->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->SeasonYear->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->SeasonYear->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->CashewProduced->Visible) { // CashewProduced ?>
    <?php if (!$Page->CashewProduced->Sortable || !$Page->sortUrl($Page->CashewProduced)) { ?>
        <th class="<?= $Page->CashewProduced->headerCellClass() ?>"><?= $Page->CashewProduced->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->CashewProduced->headerCellClass() ?>"><div role="button" data-table="production_sales" data-sort="<?= HtmlEncode($Page->CashewProduced->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->CashewProduced->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->CashewProduced->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->CashewProduced->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->AmountRealised->Visible) { // AmountRealised ?>
    <?php if (!$Page->AmountRealised->Sortable || !$Page->sortUrl($Page->AmountRealised)) { ?>
        <th class="<?= $Page->AmountRealised->headerCellClass() ?>"><?= $Page->AmountRealised->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->AmountRealised->headerCellClass() ?>"><div role="button" data-table="production_sales" data-sort="<?= HtmlEncode($Page->AmountRealised->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->AmountRealised->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->AmountRealised->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->AmountRealised->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->SoldTo->Visible) { // SoldTo ?>
    <?php if (!$Page->SoldTo->Sortable || !$Page->sortUrl($Page->SoldTo)) { ?>
        <th class="<?= $Page->SoldTo->headerCellClass() ?>"><?= $Page->SoldTo->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->SoldTo->headerCellClass() ?>"><div role="button" data-table="production_sales" data-sort="<?= HtmlEncode($Page->SoldTo->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->SoldTo->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->SoldTo->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->SoldTo->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Comments->Visible) { // Comments ?>
    <?php if (!$Page->Comments->Sortable || !$Page->sortUrl($Page->Comments)) { ?>
        <th class="<?= $Page->Comments->headerCellClass() ?>"><?= $Page->Comments->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->Comments->headerCellClass() ?>"><div role="button" data-table="production_sales" data-sort="<?= HtmlEncode($Page->Comments->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->Comments->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->Comments->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->Comments->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
        </tr>
    </thead>
    <tbody><!-- Table body -->
<?php
$Page->RecordCount = 0;
$Page->RowCount = 0;
while ($Page->fetch()) {
    // Init row class and style
    $Page->RecordCount++;
    $Page->RowCount++;
    $Page->CssStyle = "";
    $Page->loadListRowValues($Page->CurrentRow);

    // Render row
    $Page->RowType = RowType::PREVIEW; // Preview record
    $Page->resetAttributes();
    $Page->renderListRow();

    // Set up row attributes
    $Page->RowAttrs->merge([
        "data-rowindex" => $Page->RowCount,
        "class" => ($Page->RowCount % 2 != 1) ? "ew-table-alt-row" : "",

        // Add row attributes for expandable row
        "data-widget" => "expandable-table",
        "aria-expanded" => "false",
    ]);

    // Render list options
    $Page->renderListOptions();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <!-- FarmNo -->
        <td<?= $Page->FarmNo->cellAttributes() ?>>
<span<?= $Page->FarmNo->viewAttributes() ?>>
<?= $Page->FarmNo->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <!-- NRC -->
        <td<?= $Page->NRC->cellAttributes() ?>>
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->SeasonYear->Visible) { // SeasonYear ?>
        <!-- SeasonYear -->
        <td<?= $Page->SeasonYear->cellAttributes() ?>>
<span<?= $Page->SeasonYear->viewAttributes() ?>>
<?= $Page->SeasonYear->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->CashewProduced->Visible) { // CashewProduced ?>
        <!-- CashewProduced -->
        <td<?= $Page->CashewProduced->cellAttributes() ?>>
<span<?= $Page->CashewProduced->viewAttributes() ?>>
<?= $Page->CashewProduced->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->AmountRealised->Visible) { // AmountRealised ?>
        <!-- AmountRealised -->
        <td<?= $Page->AmountRealised->cellAttributes() ?>>
<span<?= $Page->AmountRealised->viewAttributes() ?>>
<?= $Page->AmountRealised->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->SoldTo->Visible) { // SoldTo ?>
        <!-- SoldTo -->
        <td<?= $Page->SoldTo->cellAttributes() ?>>
<span<?= $Page->SoldTo->viewAttributes() ?>>
<?= $Page->SoldTo->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Comments->Visible) { // Comments ?>
        <!-- Comments -->
        <td<?= $Page->Comments->cellAttributes() ?>>
<span<?= $Page->Comments->viewAttributes() ?>>
<?= $Page->Comments->getViewValue() ?></span>
</td>
<?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
} // while
?>
    </tbody>
</table><!-- /.table -->
</div><!-- /.card-body -->
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?= $Page->Pager->render() ?>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php } else { // No record ?>
<div class="card border-0"><!-- .card -->
<div class="ew-detail-count"><?= $Language->phrase("NoRecord") ?></div>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card -->
<?php } ?>
<?php
foreach ($Page->DetailCounts as $detailTblVar => $detailCount) {
?>
<div class="ew-detail-count d-none" data-table="<?= $detailTblVar ?>" data-count="<?= $detailCount ?>"><?= FormatInteger($detailCount) ?></div>
<?php
}
?>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php
$Page->Recordset?->free();
?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
