<?php

namespace PHPMaker2024\cidp24;

// Page object
$MonthRefDelete = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { month_ref: currentTable } });
var currentPageID = ew.PAGE_ID = "delete";
var currentForm;
var fmonth_refdelete;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmonth_refdelete")
        .setPageId("delete")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmonth_refdelete" id="fmonth_refdelete" class="ew-form ew-delete-form" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="month_ref">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid <?= $Page->TableGridClass ?>">
<div class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<table class="<?= $Page->TableClass ?>">
    <thead>
    <tr class="ew-table-header">
<?php if ($Page->MonthCode->Visible) { // MonthCode ?>
        <th class="<?= $Page->MonthCode->headerCellClass() ?>"><span id="elh_month_ref_MonthCode" class="month_ref_MonthCode"><?= $Page->MonthCode->caption() ?></span></th>
<?php } ?>
<?php if ($Page->MonthName->Visible) { // MonthName ?>
        <th class="<?= $Page->MonthName->headerCellClass() ?>"><span id="elh_month_ref_MonthName" class="month_ref_MonthName"><?= $Page->MonthName->caption() ?></span></th>
<?php } ?>
<?php if ($Page->MonthShort->Visible) { // MonthShort ?>
        <th class="<?= $Page->MonthShort->headerCellClass() ?>"><span id="elh_month_ref_MonthShort" class="month_ref_MonthShort"><?= $Page->MonthShort->caption() ?></span></th>
<?php } ?>
    </tr>
    </thead>
    <tbody>
<?php
$Page->RecordCount = 0;
$i = 0;
while ($Page->fetch()) {
    $Page->RecordCount++;
    $Page->RowCount++;

    // Set row properties
    $Page->resetAttributes();
    $Page->RowType = RowType::VIEW; // View

    // Get the field contents
    $Page->loadRowValues($Page->CurrentRow);

    // Render row
    $Page->renderRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php if ($Page->MonthCode->Visible) { // MonthCode ?>
        <td<?= $Page->MonthCode->cellAttributes() ?>>
<span id="">
<span<?= $Page->MonthCode->viewAttributes() ?>>
<?= $Page->MonthCode->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($Page->MonthName->Visible) { // MonthName ?>
        <td<?= $Page->MonthName->cellAttributes() ?>>
<span id="">
<span<?= $Page->MonthName->viewAttributes() ?>>
<?= $Page->MonthName->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($Page->MonthShort->Visible) { // MonthShort ?>
        <td<?= $Page->MonthShort->cellAttributes() ?>>
<span id="">
<span<?= $Page->MonthShort->viewAttributes() ?>>
<?= $Page->MonthShort->getViewValue() ?></span>
</span>
</td>
<?php } ?>
    </tr>
<?php
}
$Page->Recordset?->free();
?>
</tbody>
</table>
</div>
</div>
<div class="ew-buttons ew-desktop-buttons">
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?= $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
