<?php

namespace PHPMaker2024\cidp24;

// Page object
$GrantBeneficiaryPreview = &$Page;
?>
<script>
ew.deepAssign(ew.vars, { tables: { grant_beneficiary: <?= JsonEncode($Page->toClientVar()) ?> } });
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php if ($Page->TotalRecords > 0) { ?>
<div class="card ew-grid <?= $Page->TableGridClass ?>"><!-- .card -->
<div class="card-header ew-grid-upper-panel ew-preview-upper-panel"><!-- .card-header -->
<?= $Page->Pager->render() ?>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card-header -->
<div class="card-body ew-preview-middle-panel ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>"><!-- .card-body -->
<table class="<?= $Page->TableClass ?>"><!-- .table -->
    <thead><!-- Table header -->
        <tr class="ew-table-header">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->GrantNo->Visible) { // GrantNo ?>
    <?php if (!$Page->GrantNo->Sortable || !$Page->sortUrl($Page->GrantNo)) { ?>
        <th class="<?= $Page->GrantNo->headerCellClass() ?>"><?= $Page->GrantNo->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->GrantNo->headerCellClass() ?>"><div role="button" data-table="grant_beneficiary" data-sort="<?= HtmlEncode($Page->GrantNo->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->GrantNo->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->GrantNo->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->GrantNo->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <?php if (!$Page->NRC->Sortable || !$Page->sortUrl($Page->NRC)) { ?>
        <th class="<?= $Page->NRC->headerCellClass() ?>"><?= $Page->NRC->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->NRC->headerCellClass() ?>"><div role="button" data-table="grant_beneficiary" data-sort="<?= HtmlEncode($Page->NRC->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->NRC->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->NRC->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->NRC->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->AmountDisbursed->Visible) { // AmountDisbursed ?>
    <?php if (!$Page->AmountDisbursed->Sortable || !$Page->sortUrl($Page->AmountDisbursed)) { ?>
        <th class="<?= $Page->AmountDisbursed->headerCellClass() ?>"><?= $Page->AmountDisbursed->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->AmountDisbursed->headerCellClass() ?>"><div role="button" data-table="grant_beneficiary" data-sort="<?= HtmlEncode($Page->AmountDisbursed->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->AmountDisbursed->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->AmountDisbursed->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->AmountDisbursed->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->ApplicationDate->Visible) { // ApplicationDate ?>
    <?php if (!$Page->ApplicationDate->Sortable || !$Page->sortUrl($Page->ApplicationDate)) { ?>
        <th class="<?= $Page->ApplicationDate->headerCellClass() ?>"><?= $Page->ApplicationDate->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->ApplicationDate->headerCellClass() ?>"><div role="button" data-table="grant_beneficiary" data-sort="<?= HtmlEncode($Page->ApplicationDate->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->ApplicationDate->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->ApplicationDate->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->ApplicationDate->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->AmountAppliedFor->Visible) { // AmountAppliedFor ?>
    <?php if (!$Page->AmountAppliedFor->Sortable || !$Page->sortUrl($Page->AmountAppliedFor)) { ?>
        <th class="<?= $Page->AmountAppliedFor->headerCellClass() ?>"><?= $Page->AmountAppliedFor->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->AmountAppliedFor->headerCellClass() ?>"><div role="button" data-table="grant_beneficiary" data-sort="<?= HtmlEncode($Page->AmountAppliedFor->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->AmountAppliedFor->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->AmountAppliedFor->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->AmountAppliedFor->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->ReplyDate->Visible) { // ReplyDate ?>
    <?php if (!$Page->ReplyDate->Sortable || !$Page->sortUrl($Page->ReplyDate)) { ?>
        <th class="<?= $Page->ReplyDate->headerCellClass() ?>"><?= $Page->ReplyDate->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->ReplyDate->headerCellClass() ?>"><div role="button" data-table="grant_beneficiary" data-sort="<?= HtmlEncode($Page->ReplyDate->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->ReplyDate->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->ReplyDate->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->ReplyDate->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Approved->Visible) { // Approved ?>
    <?php if (!$Page->Approved->Sortable || !$Page->sortUrl($Page->Approved)) { ?>
        <th class="<?= $Page->Approved->headerCellClass() ?>"><?= $Page->Approved->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->Approved->headerCellClass() ?>"><div role="button" data-table="grant_beneficiary" data-sort="<?= HtmlEncode($Page->Approved->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->Approved->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->Approved->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->Approved->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->ReasonsForRejection->Visible) { // ReasonsForRejection ?>
    <?php if (!$Page->ReasonsForRejection->Sortable || !$Page->sortUrl($Page->ReasonsForRejection)) { ?>
        <th class="<?= $Page->ReasonsForRejection->headerCellClass() ?>"><?= $Page->ReasonsForRejection->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->ReasonsForRejection->headerCellClass() ?>"><div role="button" data-table="grant_beneficiary" data-sort="<?= HtmlEncode($Page->ReasonsForRejection->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->ReasonsForRejection->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->ReasonsForRejection->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->ReasonsForRejection->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Purpose->Visible) { // Purpose ?>
    <?php if (!$Page->Purpose->Sortable || !$Page->sortUrl($Page->Purpose)) { ?>
        <th class="<?= $Page->Purpose->headerCellClass() ?>"><?= $Page->Purpose->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->Purpose->headerCellClass() ?>"><div role="button" data-table="grant_beneficiary" data-sort="<?= HtmlEncode($Page->Purpose->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->Purpose->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->Purpose->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->Purpose->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
        </tr>
    </thead>
    <tbody><!-- Table body -->
<?php
$Page->RecordCount = 0;
$Page->RowCount = 0;
while ($Page->fetch()) {
    // Init row class and style
    $Page->RecordCount++;
    $Page->RowCount++;
    $Page->CssStyle = "";
    $Page->loadListRowValues($Page->CurrentRow);

    // Render row
    $Page->RowType = RowType::PREVIEW; // Preview record
    $Page->resetAttributes();
    $Page->renderListRow();

    // Set up row attributes
    $Page->RowAttrs->merge([
        "data-rowindex" => $Page->RowCount,
        "class" => ($Page->RowCount % 2 != 1) ? "ew-table-alt-row" : "",

        // Add row attributes for expandable row
        "data-widget" => "expandable-table",
        "aria-expanded" => "false",
    ]);

    // Render list options
    $Page->renderListOptions();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
<?php if ($Page->GrantNo->Visible) { // GrantNo ?>
        <!-- GrantNo -->
        <td<?= $Page->GrantNo->cellAttributes() ?>>
<span<?= $Page->GrantNo->viewAttributes() ?>>
<?= $Page->GrantNo->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <!-- NRC -->
        <td<?= $Page->NRC->cellAttributes() ?>>
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->AmountDisbursed->Visible) { // AmountDisbursed ?>
        <!-- AmountDisbursed -->
        <td<?= $Page->AmountDisbursed->cellAttributes() ?>>
<span<?= $Page->AmountDisbursed->viewAttributes() ?>>
<?= $Page->AmountDisbursed->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->ApplicationDate->Visible) { // ApplicationDate ?>
        <!-- ApplicationDate -->
        <td<?= $Page->ApplicationDate->cellAttributes() ?>>
<span<?= $Page->ApplicationDate->viewAttributes() ?>>
<?= $Page->ApplicationDate->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->AmountAppliedFor->Visible) { // AmountAppliedFor ?>
        <!-- AmountAppliedFor -->
        <td<?= $Page->AmountAppliedFor->cellAttributes() ?>>
<span<?= $Page->AmountAppliedFor->viewAttributes() ?>>
<?= $Page->AmountAppliedFor->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->ReplyDate->Visible) { // ReplyDate ?>
        <!-- ReplyDate -->
        <td<?= $Page->ReplyDate->cellAttributes() ?>>
<span<?= $Page->ReplyDate->viewAttributes() ?>>
<?= $Page->ReplyDate->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Approved->Visible) { // Approved ?>
        <!-- Approved -->
        <td<?= $Page->Approved->cellAttributes() ?>>
<span<?= $Page->Approved->viewAttributes() ?>>
<?= $Page->Approved->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->ReasonsForRejection->Visible) { // ReasonsForRejection ?>
        <!-- ReasonsForRejection -->
        <td<?= $Page->ReasonsForRejection->cellAttributes() ?>>
<span<?= $Page->ReasonsForRejection->viewAttributes() ?>>
<?= $Page->ReasonsForRejection->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Purpose->Visible) { // Purpose ?>
        <!-- Purpose -->
        <td<?= $Page->Purpose->cellAttributes() ?>>
<span<?= $Page->Purpose->viewAttributes() ?>>
<?= $Page->Purpose->getViewValue() ?></span>
</td>
<?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
} // while
?>
    </tbody>
</table><!-- /.table -->
</div><!-- /.card-body -->
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?= $Page->Pager->render() ?>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php } else { // No record ?>
<div class="card border-0"><!-- .card -->
<div class="ew-detail-count"><?= $Language->phrase("NoRecord") ?></div>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card -->
<?php } ?>
<?php
foreach ($Page->DetailCounts as $detailTblVar => $detailCount) {
?>
<div class="ew-detail-count d-none" data-table="<?= $detailTblVar ?>" data-count="<?= $detailCount ?>"><?= FormatInteger($detailCount) ?></div>
<?php
}
?>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php
$Page->Recordset?->free();
?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
