<?php

namespace PHPMaker2024\cidp24;

// Page object
$GrantBeneficiaryList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { grant_beneficiary: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["GrantNo", [fields.GrantNo.visible && fields.GrantNo.required ? ew.Validators.required(fields.GrantNo.caption) : null, ew.Validators.integer], fields.GrantNo.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["AmountDisbursed", [fields.AmountDisbursed.visible && fields.AmountDisbursed.required ? ew.Validators.required(fields.AmountDisbursed.caption) : null, ew.Validators.float], fields.AmountDisbursed.isInvalid],
            ["ApplicationDate", [fields.ApplicationDate.visible && fields.ApplicationDate.required ? ew.Validators.required(fields.ApplicationDate.caption) : null, ew.Validators.datetime(fields.ApplicationDate.clientFormatPattern)], fields.ApplicationDate.isInvalid],
            ["AmountAppliedFor", [fields.AmountAppliedFor.visible && fields.AmountAppliedFor.required ? ew.Validators.required(fields.AmountAppliedFor.caption) : null, ew.Validators.float], fields.AmountAppliedFor.isInvalid],
            ["ReplyDate", [fields.ReplyDate.visible && fields.ReplyDate.required ? ew.Validators.required(fields.ReplyDate.caption) : null, ew.Validators.datetime(fields.ReplyDate.clientFormatPattern)], fields.ReplyDate.isInvalid],
            ["Approved", [fields.Approved.visible && fields.Approved.required ? ew.Validators.required(fields.Approved.caption) : null], fields.Approved.isInvalid],
            ["ReasonsForRejection", [fields.ReasonsForRejection.visible && fields.ReasonsForRejection.required ? ew.Validators.required(fields.ReasonsForRejection.caption) : null], fields.ReasonsForRejection.isInvalid],
            ["Purpose", [fields.Purpose.visible && fields.Purpose.required ? ew.Validators.required(fields.Purpose.caption) : null], fields.Purpose.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["GrantNo",false],["NRC",false],["AmountDisbursed",false],["ApplicationDate",false],["AmountAppliedFor",false],["ReplyDate",false],["Approved",true],["ReasonsForRejection",false],["Purpose",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "Approved": <?= $Page->Approved->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "grant") {
    if ($Page->MasterRecordExists) {
        include_once "views/GrantMaster.php";
    }
}
?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fgrant_beneficiarysrch" id="fgrant_beneficiarysrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fgrant_beneficiarysrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { grant_beneficiary: currentTable } });
var currentForm;
var fgrant_beneficiarysrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fgrant_beneficiarysrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fgrant_beneficiarysrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fgrant_beneficiarysrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fgrant_beneficiarysrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fgrant_beneficiarysrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="grant_beneficiary">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "grant" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="grant">
<input type="hidden" name="fk_GrantNo" value="<?= HtmlEncode($Page->GrantNo->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_grant_beneficiary" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_grant_beneficiarylist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->GrantNo->Visible) { // GrantNo ?>
        <th data-name="GrantNo" class="<?= $Page->GrantNo->headerCellClass() ?>"><div id="elh_grant_beneficiary_GrantNo" class="grant_beneficiary_GrantNo"><?= $Page->renderFieldHeader($Page->GrantNo) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_grant_beneficiary_NRC" class="grant_beneficiary_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->AmountDisbursed->Visible) { // AmountDisbursed ?>
        <th data-name="AmountDisbursed" class="<?= $Page->AmountDisbursed->headerCellClass() ?>"><div id="elh_grant_beneficiary_AmountDisbursed" class="grant_beneficiary_AmountDisbursed"><?= $Page->renderFieldHeader($Page->AmountDisbursed) ?></div></th>
<?php } ?>
<?php if ($Page->ApplicationDate->Visible) { // ApplicationDate ?>
        <th data-name="ApplicationDate" class="<?= $Page->ApplicationDate->headerCellClass() ?>"><div id="elh_grant_beneficiary_ApplicationDate" class="grant_beneficiary_ApplicationDate"><?= $Page->renderFieldHeader($Page->ApplicationDate) ?></div></th>
<?php } ?>
<?php if ($Page->AmountAppliedFor->Visible) { // AmountAppliedFor ?>
        <th data-name="AmountAppliedFor" class="<?= $Page->AmountAppliedFor->headerCellClass() ?>"><div id="elh_grant_beneficiary_AmountAppliedFor" class="grant_beneficiary_AmountAppliedFor"><?= $Page->renderFieldHeader($Page->AmountAppliedFor) ?></div></th>
<?php } ?>
<?php if ($Page->ReplyDate->Visible) { // ReplyDate ?>
        <th data-name="ReplyDate" class="<?= $Page->ReplyDate->headerCellClass() ?>"><div id="elh_grant_beneficiary_ReplyDate" class="grant_beneficiary_ReplyDate"><?= $Page->renderFieldHeader($Page->ReplyDate) ?></div></th>
<?php } ?>
<?php if ($Page->Approved->Visible) { // Approved ?>
        <th data-name="Approved" class="<?= $Page->Approved->headerCellClass() ?>"><div id="elh_grant_beneficiary_Approved" class="grant_beneficiary_Approved"><?= $Page->renderFieldHeader($Page->Approved) ?></div></th>
<?php } ?>
<?php if ($Page->ReasonsForRejection->Visible) { // ReasonsForRejection ?>
        <th data-name="ReasonsForRejection" class="<?= $Page->ReasonsForRejection->headerCellClass() ?>"><div id="elh_grant_beneficiary_ReasonsForRejection" class="grant_beneficiary_ReasonsForRejection"><?= $Page->renderFieldHeader($Page->ReasonsForRejection) ?></div></th>
<?php } ?>
<?php if ($Page->Purpose->Visible) { // Purpose ?>
        <th data-name="Purpose" class="<?= $Page->Purpose->headerCellClass() ?>"><div id="elh_grant_beneficiary_Purpose" class="grant_beneficiary_Purpose"><?= $Page->renderFieldHeader($Page->Purpose) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->GrantNo->Visible) { // GrantNo ?>
        <td data-name="GrantNo"<?= $Page->GrantNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->GrantNo->getSessionValue() != "") { ?>
<span<?= $Page->GrantNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->GrantNo->getDisplayValue($Page->GrantNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_GrantNo" name="x<?= $Page->RowIndex ?>_GrantNo" value="<?= HtmlEncode($Page->GrantNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_GrantNo" class="el_grant_beneficiary_GrantNo">
<input type="<?= $Page->GrantNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_GrantNo" id="x<?= $Page->RowIndex ?>_GrantNo" data-table="grant_beneficiary" data-field="x_GrantNo" value="<?= $Page->GrantNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->GrantNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GrantNo->formatPattern()) ?>"<?= $Page->GrantNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GrantNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_GrantNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_GrantNo" id="o<?= $Page->RowIndex ?>_GrantNo" value="<?= HtmlEncode($Page->GrantNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_GrantNo" class="el_grant_beneficiary_GrantNo">
<span<?= $Page->GrantNo->viewAttributes() ?>>
<?= $Page->GrantNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_NRC" class="el_grant_beneficiary_NRC">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_NRC" id="sv_x<?= $Page->RowIndex ?>_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="grant_beneficiary" data-field="x_NRC" data-input="sv_x<?= $Page->RowIndex ?>_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.grant_beneficiary.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_NRC" id="o<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_NRC" class="el_grant_beneficiary_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->AmountDisbursed->Visible) { // AmountDisbursed ?>
        <td data-name="AmountDisbursed"<?= $Page->AmountDisbursed->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_AmountDisbursed" class="el_grant_beneficiary_AmountDisbursed">
<input type="<?= $Page->AmountDisbursed->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_AmountDisbursed" id="x<?= $Page->RowIndex ?>_AmountDisbursed" data-table="grant_beneficiary" data-field="x_AmountDisbursed" value="<?= $Page->AmountDisbursed->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AmountDisbursed->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AmountDisbursed->formatPattern()) ?>"<?= $Page->AmountDisbursed->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AmountDisbursed->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_AmountDisbursed" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_AmountDisbursed" id="o<?= $Page->RowIndex ?>_AmountDisbursed" value="<?= HtmlEncode($Page->AmountDisbursed->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_AmountDisbursed" class="el_grant_beneficiary_AmountDisbursed">
<span<?= $Page->AmountDisbursed->viewAttributes() ?>>
<?= $Page->AmountDisbursed->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->ApplicationDate->Visible) { // ApplicationDate ?>
        <td data-name="ApplicationDate"<?= $Page->ApplicationDate->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_ApplicationDate" class="el_grant_beneficiary_ApplicationDate">
<input type="<?= $Page->ApplicationDate->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_ApplicationDate" id="x<?= $Page->RowIndex ?>_ApplicationDate" data-table="grant_beneficiary" data-field="x_ApplicationDate" value="<?= $Page->ApplicationDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->ApplicationDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ApplicationDate->formatPattern()) ?>"<?= $Page->ApplicationDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ApplicationDate->getErrorMessage() ?></div>
<?php if (!$Page->ApplicationDate->ReadOnly && !$Page->ApplicationDate->Disabled && !isset($Page->ApplicationDate->EditAttrs["readonly"]) && !isset($Page->ApplicationDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_ApplicationDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_ApplicationDate" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ApplicationDate" id="o<?= $Page->RowIndex ?>_ApplicationDate" value="<?= HtmlEncode($Page->ApplicationDate->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_ApplicationDate" class="el_grant_beneficiary_ApplicationDate">
<span<?= $Page->ApplicationDate->viewAttributes() ?>>
<?= $Page->ApplicationDate->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->AmountAppliedFor->Visible) { // AmountAppliedFor ?>
        <td data-name="AmountAppliedFor"<?= $Page->AmountAppliedFor->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_AmountAppliedFor" class="el_grant_beneficiary_AmountAppliedFor">
<input type="<?= $Page->AmountAppliedFor->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_AmountAppliedFor" id="x<?= $Page->RowIndex ?>_AmountAppliedFor" data-table="grant_beneficiary" data-field="x_AmountAppliedFor" value="<?= $Page->AmountAppliedFor->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AmountAppliedFor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AmountAppliedFor->formatPattern()) ?>"<?= $Page->AmountAppliedFor->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AmountAppliedFor->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_AmountAppliedFor" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_AmountAppliedFor" id="o<?= $Page->RowIndex ?>_AmountAppliedFor" value="<?= HtmlEncode($Page->AmountAppliedFor->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_AmountAppliedFor" class="el_grant_beneficiary_AmountAppliedFor">
<span<?= $Page->AmountAppliedFor->viewAttributes() ?>>
<?= $Page->AmountAppliedFor->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->ReplyDate->Visible) { // ReplyDate ?>
        <td data-name="ReplyDate"<?= $Page->ReplyDate->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_ReplyDate" class="el_grant_beneficiary_ReplyDate">
<input type="<?= $Page->ReplyDate->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_ReplyDate" id="x<?= $Page->RowIndex ?>_ReplyDate" data-table="grant_beneficiary" data-field="x_ReplyDate" value="<?= $Page->ReplyDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->ReplyDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReplyDate->formatPattern()) ?>"<?= $Page->ReplyDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ReplyDate->getErrorMessage() ?></div>
<?php if (!$Page->ReplyDate->ReadOnly && !$Page->ReplyDate->Disabled && !isset($Page->ReplyDate->EditAttrs["readonly"]) && !isset($Page->ReplyDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_ReplyDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_ReplyDate" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ReplyDate" id="o<?= $Page->RowIndex ?>_ReplyDate" value="<?= HtmlEncode($Page->ReplyDate->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_ReplyDate" class="el_grant_beneficiary_ReplyDate">
<span<?= $Page->ReplyDate->viewAttributes() ?>>
<?= $Page->ReplyDate->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Approved->Visible) { // Approved ?>
        <td data-name="Approved"<?= $Page->Approved->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_Approved" class="el_grant_beneficiary_Approved">
<template id="tp_x<?= $Page->RowIndex ?>_Approved">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="grant_beneficiary" data-field="x_Approved" name="x<?= $Page->RowIndex ?>_Approved" id="x<?= $Page->RowIndex ?>_Approved"<?= $Page->Approved->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Page->RowIndex ?>_Approved" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Page->RowIndex ?>_Approved"
    name="x<?= $Page->RowIndex ?>_Approved"
    value="<?= HtmlEncode($Page->Approved->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Page->RowIndex ?>_Approved"
    data-target="dsl_x<?= $Page->RowIndex ?>_Approved"
    data-repeatcolumn="5"
    class="form-control<?= $Page->Approved->isInvalidClass() ?>"
    data-table="grant_beneficiary"
    data-field="x_Approved"
    data-value-separator="<?= $Page->Approved->displayValueSeparatorAttribute() ?>"
    <?= $Page->Approved->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->Approved->getErrorMessage() ?></div>
<?= $Page->Approved->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_Approved") ?>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_Approved" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Approved" id="o<?= $Page->RowIndex ?>_Approved" value="<?= HtmlEncode($Page->Approved->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_Approved" class="el_grant_beneficiary_Approved">
<span<?= $Page->Approved->viewAttributes() ?>>
<?= $Page->Approved->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->ReasonsForRejection->Visible) { // ReasonsForRejection ?>
        <td data-name="ReasonsForRejection"<?= $Page->ReasonsForRejection->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_ReasonsForRejection" class="el_grant_beneficiary_ReasonsForRejection">
<input type="<?= $Page->ReasonsForRejection->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_ReasonsForRejection" id="x<?= $Page->RowIndex ?>_ReasonsForRejection" data-table="grant_beneficiary" data-field="x_ReasonsForRejection" value="<?= $Page->ReasonsForRejection->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->ReasonsForRejection->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReasonsForRejection->formatPattern()) ?>"<?= $Page->ReasonsForRejection->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ReasonsForRejection->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_ReasonsForRejection" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ReasonsForRejection" id="o<?= $Page->RowIndex ?>_ReasonsForRejection" value="<?= HtmlEncode($Page->ReasonsForRejection->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_ReasonsForRejection" class="el_grant_beneficiary_ReasonsForRejection">
<span<?= $Page->ReasonsForRejection->viewAttributes() ?>>
<?= $Page->ReasonsForRejection->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Purpose->Visible) { // Purpose ?>
        <td data-name="Purpose"<?= $Page->Purpose->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_Purpose" class="el_grant_beneficiary_Purpose">
<input type="<?= $Page->Purpose->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Purpose" id="x<?= $Page->RowIndex ?>_Purpose" data-table="grant_beneficiary" data-field="x_Purpose" value="<?= $Page->Purpose->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Purpose->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Purpose->formatPattern()) ?>"<?= $Page->Purpose->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Purpose->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_Purpose" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Purpose" id="o<?= $Page->RowIndex ?>_Purpose" value="<?= HtmlEncode($Page->Purpose->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_grant_beneficiary_Purpose" class="el_grant_beneficiary_Purpose">
<span<?= $Page->Purpose->viewAttributes() ?>>
<?= $Page->Purpose->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("grant_beneficiary");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
