<?php

namespace PHPMaker2024\cidp24;

// Page object
$GrantAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { grant: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fgrantadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fgrantadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["GrantNo", [fields.GrantNo.visible && fields.GrantNo.required ? ew.Validators.required(fields.GrantNo.caption) : null, ew.Validators.integer], fields.GrantNo.isInvalid],
            ["GrantRef", [fields.GrantRef.visible && fields.GrantRef.required ? ew.Validators.required(fields.GrantRef.caption) : null], fields.GrantRef.isInvalid],
            ["SourceOfFunding", [fields.SourceOfFunding.visible && fields.SourceOfFunding.required ? ew.Validators.required(fields.SourceOfFunding.caption) : null], fields.SourceOfFunding.isInvalid],
            ["GrantAmount", [fields.GrantAmount.visible && fields.GrantAmount.required ? ew.Validators.required(fields.GrantAmount.caption) : null, ew.Validators.float], fields.GrantAmount.isInvalid],
            ["DisbursementDate", [fields.DisbursementDate.visible && fields.DisbursementDate.required ? ew.Validators.required(fields.DisbursementDate.caption) : null, ew.Validators.datetime(fields.DisbursementDate.clientFormatPattern)], fields.DisbursementDate.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgrantadd" id="fgrantadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="grant">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->GrantNo->Visible) { // GrantNo ?>
    <div id="r_GrantNo"<?= $Page->GrantNo->rowAttributes() ?>>
        <label id="elh_grant_GrantNo" for="x_GrantNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->GrantNo->caption() ?><?= $Page->GrantNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->GrantNo->cellAttributes() ?>>
<span id="el_grant_GrantNo">
<input type="<?= $Page->GrantNo->getInputTextType() ?>" name="x_GrantNo" id="x_GrantNo" data-table="grant" data-field="x_GrantNo" value="<?= $Page->GrantNo->EditValue ?>" placeholder="<?= HtmlEncode($Page->GrantNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GrantNo->formatPattern()) ?>"<?= $Page->GrantNo->editAttributes() ?> aria-describedby="x_GrantNo_help">
<?= $Page->GrantNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->GrantNo->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->GrantRef->Visible) { // GrantRef ?>
    <div id="r_GrantRef"<?= $Page->GrantRef->rowAttributes() ?>>
        <label id="elh_grant_GrantRef" for="x_GrantRef" class="<?= $Page->LeftColumnClass ?>"><?= $Page->GrantRef->caption() ?><?= $Page->GrantRef->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->GrantRef->cellAttributes() ?>>
<span id="el_grant_GrantRef">
<input type="<?= $Page->GrantRef->getInputTextType() ?>" name="x_GrantRef" id="x_GrantRef" data-table="grant" data-field="x_GrantRef" value="<?= $Page->GrantRef->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->GrantRef->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GrantRef->formatPattern()) ?>"<?= $Page->GrantRef->editAttributes() ?> aria-describedby="x_GrantRef_help">
<?= $Page->GrantRef->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->GrantRef->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SourceOfFunding->Visible) { // SourceOfFunding ?>
    <div id="r_SourceOfFunding"<?= $Page->SourceOfFunding->rowAttributes() ?>>
        <label id="elh_grant_SourceOfFunding" for="x_SourceOfFunding" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SourceOfFunding->caption() ?><?= $Page->SourceOfFunding->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SourceOfFunding->cellAttributes() ?>>
<span id="el_grant_SourceOfFunding">
<input type="<?= $Page->SourceOfFunding->getInputTextType() ?>" name="x_SourceOfFunding" id="x_SourceOfFunding" data-table="grant" data-field="x_SourceOfFunding" value="<?= $Page->SourceOfFunding->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->SourceOfFunding->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SourceOfFunding->formatPattern()) ?>"<?= $Page->SourceOfFunding->editAttributes() ?> aria-describedby="x_SourceOfFunding_help">
<?= $Page->SourceOfFunding->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->SourceOfFunding->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->GrantAmount->Visible) { // GrantAmount ?>
    <div id="r_GrantAmount"<?= $Page->GrantAmount->rowAttributes() ?>>
        <label id="elh_grant_GrantAmount" for="x_GrantAmount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->GrantAmount->caption() ?><?= $Page->GrantAmount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->GrantAmount->cellAttributes() ?>>
<span id="el_grant_GrantAmount">
<input type="<?= $Page->GrantAmount->getInputTextType() ?>" name="x_GrantAmount" id="x_GrantAmount" data-table="grant" data-field="x_GrantAmount" value="<?= $Page->GrantAmount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->GrantAmount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GrantAmount->formatPattern()) ?>"<?= $Page->GrantAmount->editAttributes() ?> aria-describedby="x_GrantAmount_help">
<?= $Page->GrantAmount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->GrantAmount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DisbursementDate->Visible) { // DisbursementDate ?>
    <div id="r_DisbursementDate"<?= $Page->DisbursementDate->rowAttributes() ?>>
        <label id="elh_grant_DisbursementDate" for="x_DisbursementDate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DisbursementDate->caption() ?><?= $Page->DisbursementDate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DisbursementDate->cellAttributes() ?>>
<span id="el_grant_DisbursementDate">
<input type="<?= $Page->DisbursementDate->getInputTextType() ?>" name="x_DisbursementDate" id="x_DisbursementDate" data-table="grant" data-field="x_DisbursementDate" value="<?= $Page->DisbursementDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->DisbursementDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DisbursementDate->formatPattern()) ?>"<?= $Page->DisbursementDate->editAttributes() ?> aria-describedby="x_DisbursementDate_help">
<?= $Page->DisbursementDate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DisbursementDate->getErrorMessage() ?></div>
<?php if (!$Page->DisbursementDate->ReadOnly && !$Page->DisbursementDate->Disabled && !isset($Page->DisbursementDate->EditAttrs["readonly"]) && !isset($Page->DisbursementDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgrantadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgrantadd", "x_DisbursementDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgrantadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgrantadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("grant");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
