<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmsExtraList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farms_extra: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ffarms_extrasrch" id="ffarms_extrasrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="ffarms_extrasrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farms_extra: currentTable } });
var currentForm;
var ffarms_extrasrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarms_extrasrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ffarms_extrasrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ffarms_extrasrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ffarms_extrasrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ffarms_extrasrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farms_extra">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_farms_extra" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_farms_extralist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Page->ProvinceCode->headerCellClass() ?>"><div id="elh_farms_extra_ProvinceCode" class="farms_extra_ProvinceCode"><?= $Page->renderFieldHeader($Page->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Page->DistrictCode->headerCellClass() ?>"><div id="elh_farms_extra_DistrictCode" class="farms_extra_DistrictCode"><?= $Page->renderFieldHeader($Page->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Page->CampCode->headerCellClass() ?>"><div id="elh_farms_extra_CampCode" class="farms_extra_CampCode"><?= $Page->renderFieldHeader($Page->CampCode) ?></div></th>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Page->VillageCode->headerCellClass() ?>"><div id="elh_farms_extra_VillageCode" class="farms_extra_VillageCode"><?= $Page->renderFieldHeader($Page->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_farms_extra_NRC" class="farms_extra_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <th data-name="FarmerNo" class="<?= $Page->FarmerNo->headerCellClass() ?>"><div id="elh_farms_extra_FarmerNo" class="farms_extra_FarmerNo"><?= $Page->renderFieldHeader($Page->FarmerNo) ?></div></th>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <th data-name="FarmNo" class="<?= $Page->FarmNo->headerCellClass() ?>"><div id="elh_farms_extra_FarmNo" class="farms_extra_FarmNo"><?= $Page->renderFieldHeader($Page->FarmNo) ?></div></th>
<?php } ?>
<?php if ($Page->Latitude->Visible) { // Latitude ?>
        <th data-name="Latitude" class="<?= $Page->Latitude->headerCellClass() ?>"><div id="elh_farms_extra_Latitude" class="farms_extra_Latitude"><?= $Page->renderFieldHeader($Page->Latitude) ?></div></th>
<?php } ?>
<?php if ($Page->Longitude->Visible) { // Longitude ?>
        <th data-name="Longitude" class="<?= $Page->Longitude->headerCellClass() ?>"><div id="elh_farms_extra_Longitude" class="farms_extra_Longitude"><?= $Page->renderFieldHeader($Page->Longitude) ?></div></th>
<?php } ?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
        <th data-name="FieldType" class="<?= $Page->FieldType->headerCellClass() ?>"><div id="elh_farms_extra_FieldType" class="farms_extra_FieldType"><?= $Page->renderFieldHeader($Page->FieldType) ?></div></th>
<?php } ?>
<?php if ($Page->Ownership->Visible) { // Ownership ?>
        <th data-name="Ownership" class="<?= $Page->Ownership->headerCellClass() ?>"><div id="elh_farms_extra_Ownership" class="farms_extra_Ownership"><?= $Page->renderFieldHeader($Page->Ownership) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { // FarmSize ?>
        <th data-name="FarmSize" class="<?= $Page->FarmSize->headerCellClass() ?>"><div id="elh_farms_extra_FarmSize" class="farms_extra_FarmSize"><?= $Page->renderFieldHeader($Page->FarmSize) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { // FarmSizeEstimated ?>
        <th data-name="FarmSizeEstimated" class="<?= $Page->FarmSizeEstimated->headerCellClass() ?>"><div id="elh_farms_extra_FarmSizeEstimated" class="farms_extra_FarmSizeEstimated"><?= $Page->renderFieldHeader($Page->FarmSizeEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
        <th data-name="TreesPlantedEstimated" class="<?= $Page->TreesPlantedEstimated->headerCellClass() ?>"><div id="elh_farms_extra_TreesPlantedEstimated" class="farms_extra_TreesPlantedEstimated"><?= $Page->renderFieldHeader($Page->TreesPlantedEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { // FarmSizeVerified ?>
        <th data-name="FarmSizeVerified" class="<?= $Page->FarmSizeVerified->headerCellClass() ?>"><div id="elh_farms_extra_FarmSizeVerified" class="farms_extra_FarmSizeVerified"><?= $Page->renderFieldHeader($Page->FarmSizeVerified) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
        <th data-name="TreesPlantedVerified" class="<?= $Page->TreesPlantedVerified->headerCellClass() ?>"><div id="elh_farms_extra_TreesPlantedVerified" class="farms_extra_TreesPlantedVerified"><?= $Page->renderFieldHeader($Page->TreesPlantedVerified) ?></div></th>
<?php } ?>
<?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <th data-name="SourcesOfSeedlings" class="<?= $Page->SourcesOfSeedlings->headerCellClass() ?>"><div id="elh_farms_extra_SourcesOfSeedlings" class="farms_extra_SourcesOfSeedlings"><?= $Page->renderFieldHeader($Page->SourcesOfSeedlings) ?></div></th>
<?php } ?>
<?php if ($Page->ClearedLand->Visible) { // ClearedLand ?>
        <th data-name="ClearedLand" class="<?= $Page->ClearedLand->headerCellClass() ?>"><div id="elh_farms_extra_ClearedLand" class="farms_extra_ClearedLand"><?= $Page->renderFieldHeader($Page->ClearedLand) ?></div></th>
<?php } ?>
<?php if ($Page->SeedlingsAllocated->Visible) { // SeedlingsAllocated ?>
        <th data-name="SeedlingsAllocated" class="<?= $Page->SeedlingsAllocated->headerCellClass() ?>"><div id="elh_farms_extra_SeedlingsAllocated" class="farms_extra_SeedlingsAllocated"><?= $Page->renderFieldHeader($Page->SeedlingsAllocated) ?></div></th>
<?php } ?>
<?php if ($Page->OldTrees->Visible) { // OldTrees ?>
        <th data-name="OldTrees" class="<?= $Page->OldTrees->headerCellClass() ?>"><div id="elh_farms_extra_OldTrees" class="farms_extra_OldTrees"><?= $Page->renderFieldHeader($Page->OldTrees) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_ProvinceCode" class="el_farms_extra_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_DistrictCode" class="el_farms_extra_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_CampCode" class="el_farms_extra_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Page->VillageCode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_VillageCode" class="el_farms_extra_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_NRC" class="el_farms_extra_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo"<?= $Page->FarmerNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_FarmerNo" class="el_farms_extra_FarmerNo">
<span<?= $Page->FarmerNo->viewAttributes() ?>>
<?= $Page->FarmerNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_FarmNo" class="el_farms_extra_FarmNo">
<span<?= $Page->FarmNo->viewAttributes() ?>>
<?= $Page->FarmNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Latitude->Visible) { // Latitude ?>
        <td data-name="Latitude"<?= $Page->Latitude->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_Latitude" class="el_farms_extra_Latitude">
<span<?= $Page->Latitude->viewAttributes() ?>>
<?= $Page->Latitude->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Longitude->Visible) { // Longitude ?>
        <td data-name="Longitude"<?= $Page->Longitude->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_Longitude" class="el_farms_extra_Longitude">
<span<?= $Page->Longitude->viewAttributes() ?>>
<?= $Page->Longitude->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FieldType->Visible) { // FieldType ?>
        <td data-name="FieldType"<?= $Page->FieldType->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_FieldType" class="el_farms_extra_FieldType">
<span<?= $Page->FieldType->viewAttributes() ?>>
<?= $Page->FieldType->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Ownership->Visible) { // Ownership ?>
        <td data-name="Ownership"<?= $Page->Ownership->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_Ownership" class="el_farms_extra_Ownership">
<span<?= $Page->Ownership->viewAttributes() ?>>
<?= $Page->Ownership->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmSize->Visible) { // FarmSize ?>
        <td data-name="FarmSize"<?= $Page->FarmSize->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_FarmSize" class="el_farms_extra_FarmSize">
<span<?= $Page->FarmSize->viewAttributes() ?>>
<?= $Page->FarmSize->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmSizeEstimated->Visible) { // FarmSizeEstimated ?>
        <td data-name="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_FarmSizeEstimated" class="el_farms_extra_FarmSizeEstimated">
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
        <td data-name="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_TreesPlantedEstimated" class="el_farms_extra_TreesPlantedEstimated">
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmSizeVerified->Visible) { // FarmSizeVerified ?>
        <td data-name="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_FarmSizeVerified" class="el_farms_extra_FarmSizeVerified">
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
        <td data-name="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_TreesPlantedVerified" class="el_farms_extra_TreesPlantedVerified">
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <td data-name="SourcesOfSeedlings"<?= $Page->SourcesOfSeedlings->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_SourcesOfSeedlings" class="el_farms_extra_SourcesOfSeedlings">
<span<?= $Page->SourcesOfSeedlings->viewAttributes() ?>>
<?= $Page->SourcesOfSeedlings->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ClearedLand->Visible) { // ClearedLand ?>
        <td data-name="ClearedLand"<?= $Page->ClearedLand->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_ClearedLand" class="el_farms_extra_ClearedLand">
<span<?= $Page->ClearedLand->viewAttributes() ?>>
<?= $Page->ClearedLand->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SeedlingsAllocated->Visible) { // SeedlingsAllocated ?>
        <td data-name="SeedlingsAllocated"<?= $Page->SeedlingsAllocated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_SeedlingsAllocated" class="el_farms_extra_SeedlingsAllocated">
<span<?= $Page->SeedlingsAllocated->viewAttributes() ?>>
<?= $Page->SeedlingsAllocated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->OldTrees->Visible) { // OldTrees ?>
        <td data-name="OldTrees"<?= $Page->OldTrees->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farms_extra_OldTrees" class="el_farms_extra_OldTrees">
<span<?= $Page->OldTrees->viewAttributes() ?>>
<?= $Page->OldTrees->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farms_extra");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
