<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmSeedAllocateList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_seed_allocate: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerNo", [fields.FarmerNo.visible && fields.FarmerNo.required ? ew.Validators.required(fields.FarmerNo.caption) : null, ew.Validators.integer], fields.FarmerNo.isInvalid],
            ["FarmNo", [fields.FarmNo.visible && fields.FarmNo.required ? ew.Validators.required(fields.FarmNo.caption) : null, ew.Validators.integer], fields.FarmNo.isInvalid],
            ["FarmingSeason", [fields.FarmingSeason.visible && fields.FarmingSeason.required ? ew.Validators.required(fields.FarmingSeason.caption) : null], fields.FarmingSeason.isInvalid],
            ["TransNo", [fields.TransNo.visible && fields.TransNo.required ? ew.Validators.required(fields.TransNo.caption) : null], fields.TransNo.isInvalid],
            ["SourcesOfSeedlings", [fields.SourcesOfSeedlings.visible && fields.SourcesOfSeedlings.required ? ew.Validators.required(fields.SourcesOfSeedlings.caption) : null], fields.SourcesOfSeedlings.isInvalid],
            ["GRN", [fields.GRN.visible && fields.GRN.required ? ew.Validators.required(fields.GRN.caption) : null], fields.GRN.isInvalid],
            ["TreesAllocated", [fields.TreesAllocated.visible && fields.TreesAllocated.required ? ew.Validators.required(fields.TreesAllocated.caption) : null], fields.TreesAllocated.isInvalid],
            ["SeedType", [fields.SeedType.visible && fields.SeedType.required ? ew.Validators.required(fields.SeedType.caption) : null], fields.SeedType.isInvalid],
            ["TransDate", [fields.TransDate.visible && fields.TransDate.required ? ew.Validators.required(fields.TransDate.caption) : null, ew.Validators.datetime(fields.TransDate.clientFormatPattern)], fields.TransDate.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false],["NRC",false],["FarmerNo",false],["FarmNo",false],["FarmingSeason",false],["SourcesOfSeedlings",false],["GRN",false],["TreesAllocated",false],["SeedType",false],["TransDate",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FarmingSeason": <?= $Page->FarmingSeason->toClientList($Page) ?>,
            "SourcesOfSeedlings": <?= $Page->SourcesOfSeedlings->toClientList($Page) ?>,
            "GRN": <?= $Page->GRN->toClientList($Page) ?>,
            "SeedType": <?= $Page->SeedType->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "farm") {
    if ($Page->MasterRecordExists) {
        include_once "views/FarmMaster.php";
    }
}
?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ffarm_seed_allocatesrch" id="ffarm_seed_allocatesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="ffarm_seed_allocatesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_seed_allocate: currentTable } });
var currentForm;
var ffarm_seed_allocatesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarm_seed_allocatesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ffarm_seed_allocatesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ffarm_seed_allocatesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ffarm_seed_allocatesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ffarm_seed_allocatesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm_seed_allocate">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "farm" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="farm">
<input type="hidden" name="fk_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->getSessionValue()) ?>">
<input type="hidden" name="fk_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->getSessionValue()) ?>">
<input type="hidden" name="fk_CampCode" value="<?= HtmlEncode($Page->CampCode->getSessionValue()) ?>">
<input type="hidden" name="fk_VillageCode" value="<?= HtmlEncode($Page->VillageCode->getSessionValue()) ?>">
<input type="hidden" name="fk_FarmNo" value="<?= HtmlEncode($Page->FarmNo->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_farm_seed_allocate" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_farm_seed_allocatelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Page->ProvinceCode->headerCellClass() ?>"><div id="elh_farm_seed_allocate_ProvinceCode" class="farm_seed_allocate_ProvinceCode"><?= $Page->renderFieldHeader($Page->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Page->DistrictCode->headerCellClass() ?>"><div id="elh_farm_seed_allocate_DistrictCode" class="farm_seed_allocate_DistrictCode"><?= $Page->renderFieldHeader($Page->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Page->CampCode->headerCellClass() ?>"><div id="elh_farm_seed_allocate_CampCode" class="farm_seed_allocate_CampCode"><?= $Page->renderFieldHeader($Page->CampCode) ?></div></th>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Page->VillageCode->headerCellClass() ?>"><div id="elh_farm_seed_allocate_VillageCode" class="farm_seed_allocate_VillageCode"><?= $Page->renderFieldHeader($Page->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_farm_seed_allocate_NRC" class="farm_seed_allocate_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <th data-name="FarmerNo" class="<?= $Page->FarmerNo->headerCellClass() ?>"><div id="elh_farm_seed_allocate_FarmerNo" class="farm_seed_allocate_FarmerNo"><?= $Page->renderFieldHeader($Page->FarmerNo) ?></div></th>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <th data-name="FarmNo" class="<?= $Page->FarmNo->headerCellClass() ?>"><div id="elh_farm_seed_allocate_FarmNo" class="farm_seed_allocate_FarmNo"><?= $Page->renderFieldHeader($Page->FarmNo) ?></div></th>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <th data-name="FarmingSeason" class="<?= $Page->FarmingSeason->headerCellClass() ?>"><div id="elh_farm_seed_allocate_FarmingSeason" class="farm_seed_allocate_FarmingSeason"><?= $Page->renderFieldHeader($Page->FarmingSeason) ?></div></th>
<?php } ?>
<?php if ($Page->TransNo->Visible) { // TransNo ?>
        <th data-name="TransNo" class="<?= $Page->TransNo->headerCellClass() ?>"><div id="elh_farm_seed_allocate_TransNo" class="farm_seed_allocate_TransNo"><?= $Page->renderFieldHeader($Page->TransNo) ?></div></th>
<?php } ?>
<?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <th data-name="SourcesOfSeedlings" class="<?= $Page->SourcesOfSeedlings->headerCellClass() ?>"><div id="elh_farm_seed_allocate_SourcesOfSeedlings" class="farm_seed_allocate_SourcesOfSeedlings"><?= $Page->renderFieldHeader($Page->SourcesOfSeedlings) ?></div></th>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
        <th data-name="GRN" class="<?= $Page->GRN->headerCellClass() ?>"><div id="elh_farm_seed_allocate_GRN" class="farm_seed_allocate_GRN"><?= $Page->renderFieldHeader($Page->GRN) ?></div></th>
<?php } ?>
<?php if ($Page->TreesAllocated->Visible) { // TreesAllocated ?>
        <th data-name="TreesAllocated" class="<?= $Page->TreesAllocated->headerCellClass() ?>"><div id="elh_farm_seed_allocate_TreesAllocated" class="farm_seed_allocate_TreesAllocated"><?= $Page->renderFieldHeader($Page->TreesAllocated) ?></div></th>
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
        <th data-name="SeedType" class="<?= $Page->SeedType->headerCellClass() ?>"><div id="elh_farm_seed_allocate_SeedType" class="farm_seed_allocate_SeedType"><?= $Page->renderFieldHeader($Page->SeedType) ?></div></th>
<?php } ?>
<?php if ($Page->TransDate->Visible) { // TransDate ?>
        <th data-name="TransDate" class="<?= $Page->TransDate->headerCellClass() ?>"><div id="elh_farm_seed_allocate_TransDate" class="farm_seed_allocate_TransDate"><?= $Page->renderFieldHeader($Page->TransDate) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_ProvinceCode" name="x<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_ProvinceCode" class="el_farm_seed_allocate_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ProvinceCode" id="o<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_ProvinceCode" name="x<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_ProvinceCode" class="el_farm_seed_allocate_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_ProvinceCode" class="el_farm_seed_allocate_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_DistrictCode" name="x<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_DistrictCode" class="el_farm_seed_allocate_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DistrictCode" id="o<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_DistrictCode" name="x<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_DistrictCode" class="el_farm_seed_allocate_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_DistrictCode" class="el_farm_seed_allocate_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_CampCode" name="x<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_CampCode" class="el_farm_seed_allocate_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_CampCode" id="o<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_CampCode" name="x<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_CampCode" class="el_farm_seed_allocate_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_CampCode" class="el_farm_seed_allocate_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_VillageCode" name="x<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_VillageCode" class="el_farm_seed_allocate_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-select ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        <?php if (!$Page->VillageCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_VillageCode"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<?php if (!$Page->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_VillageCode" id="o<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_VillageCode" name="x<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_VillageCode" class="el_farm_seed_allocate_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-select ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        <?php if (!$Page->VillageCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_VillageCode"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<?php if (!$Page->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_VillageCode" class="el_farm_seed_allocate_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_NRC" class="el_farm_seed_allocate_NRC">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_NRC" id="sv_x<?= $Page->RowIndex ?>_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm_seed_allocate" data-field="x_NRC" data-input="sv_x<?= $Page->RowIndex ?>_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm_seed_allocate.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_NRC" id="o<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_NRC" class="el_farm_seed_allocate_NRC">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_NRC" id="sv_x<?= $Page->RowIndex ?>_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm_seed_allocate" data-field="x_NRC" data-input="sv_x<?= $Page->RowIndex ?>_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm_seed_allocate.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_NRC" class="el_farm_seed_allocate_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo"<?= $Page->FarmerNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_FarmerNo" class="el_farm_seed_allocate_FarmerNo">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmerNo" id="x<?= $Page->RowIndex ?>_FarmerNo" data-table="farm_seed_allocate" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmerNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmerNo" id="o<?= $Page->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Page->FarmerNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_FarmerNo" class="el_farm_seed_allocate_FarmerNo">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmerNo" id="x<?= $Page->RowIndex ?>_FarmerNo" data-table="farm_seed_allocate" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_FarmerNo" class="el_farm_seed_allocate_FarmerNo">
<span<?= $Page->FarmerNo->viewAttributes() ?>>
<?= $Page->FarmerNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->FarmNo->getSessionValue() != "") { ?>
<span<?= $Page->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->FarmNo->getDisplayValue($Page->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_FarmNo" name="x<?= $Page->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Page->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_FarmNo" class="el_farm_seed_allocate_FarmNo">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmNo" id="x<?= $Page->RowIndex ?>_FarmNo" data-table="farm_seed_allocate" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmNo" id="o<?= $Page->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Page->FarmNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->FarmNo->getSessionValue() != "") { ?>
<span<?= $Page->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->FarmNo->getDisplayValue($Page->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_FarmNo" name="x<?= $Page->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Page->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_FarmNo" class="el_farm_seed_allocate_FarmNo">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmNo" id="x<?= $Page->RowIndex ?>_FarmNo" data-table="farm_seed_allocate" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_FarmNo" class="el_farm_seed_allocate_FarmNo">
<span<?= $Page->FarmNo->viewAttributes() ?>>
<?= $Page->FarmNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <td data-name="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_FarmingSeason" class="el_farm_seed_allocate_FarmingSeason">
    <select
        id="x<?= $Page->RowIndex ?>_FarmingSeason"
        name="x<?= $Page->RowIndex ?>_FarmingSeason"
        class="form-select ew-select<?= $Page->FarmingSeason->isInvalidClass() ?>"
        <?php if (!$Page->FarmingSeason->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmingSeason"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_FarmingSeason"
        data-value-separator="<?= $Page->FarmingSeason->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>"
        <?= $Page->FarmingSeason->editAttributes() ?>>
        <?= $Page->FarmingSeason->selectOptionListHtml("x{$Page->RowIndex}_FarmingSeason") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage() ?></div>
<?= $Page->FarmingSeason->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FarmingSeason") ?>
<?php if (!$Page->FarmingSeason->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_FarmingSeason", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmingSeason" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.FarmingSeason?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_FarmingSeason", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_FarmingSeason", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.FarmingSeason.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmingSeason" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmingSeason" id="o<?= $Page->RowIndex ?>_FarmingSeason" value="<?= HtmlEncode($Page->FarmingSeason->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_FarmingSeason" class="el_farm_seed_allocate_FarmingSeason">
    <select
        id="x<?= $Page->RowIndex ?>_FarmingSeason"
        name="x<?= $Page->RowIndex ?>_FarmingSeason"
        class="form-select ew-select<?= $Page->FarmingSeason->isInvalidClass() ?>"
        <?php if (!$Page->FarmingSeason->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmingSeason"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_FarmingSeason"
        data-value-separator="<?= $Page->FarmingSeason->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>"
        <?= $Page->FarmingSeason->editAttributes() ?>>
        <?= $Page->FarmingSeason->selectOptionListHtml("x{$Page->RowIndex}_FarmingSeason") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage() ?></div>
<?= $Page->FarmingSeason->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FarmingSeason") ?>
<?php if (!$Page->FarmingSeason->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_FarmingSeason", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmingSeason" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.FarmingSeason?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_FarmingSeason", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_FarmingSeason", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.FarmingSeason.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_FarmingSeason" class="el_farm_seed_allocate_FarmingSeason">
<span<?= $Page->FarmingSeason->viewAttributes() ?>>
<?= $Page->FarmingSeason->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->TransNo->Visible) { // TransNo ?>
        <td data-name="TransNo"<?= $Page->TransNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_TransNo" class="el_farm_seed_allocate_TransNo"></span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_TransNo" id="o<?= $Page->RowIndex ?>_TransNo" value="<?= HtmlEncode($Page->TransNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_TransNo" class="el_farm_seed_allocate_TransNo">
<span<?= $Page->TransNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->TransNo->getDisplayValue($Page->TransNo->EditValue))) ?>"></span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransNo" data-hidden="1" name="x<?= $Page->RowIndex ?>_TransNo" id="x<?= $Page->RowIndex ?>_TransNo" value="<?= HtmlEncode($Page->TransNo->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_TransNo" class="el_farm_seed_allocate_TransNo">
<span<?= $Page->TransNo->viewAttributes() ?>>
<?= $Page->TransNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="farm_seed_allocate" data-field="x_TransNo" data-hidden="1" name="x<?= $Page->RowIndex ?>_TransNo" id="x<?= $Page->RowIndex ?>_TransNo" value="<?= HtmlEncode($Page->TransNo->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <td data-name="SourcesOfSeedlings"<?= $Page->SourcesOfSeedlings->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_SourcesOfSeedlings" class="el_farm_seed_allocate_SourcesOfSeedlings">
    <select
        id="x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        name="x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        class="form-select ew-select<?= $Page->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Page->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SourcesOfSeedlings->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Page->SourcesOfSeedlings->selectOptionListHtml("x{$Page->RowIndex}_SourcesOfSeedlings") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SourcesOfSeedlings->getErrorMessage() ?></div>
<?= $Page->SourcesOfSeedlings->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SourcesOfSeedlings") ?>
<?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_SourcesOfSeedlings" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SourcesOfSeedlings" id="o<?= $Page->RowIndex ?>_SourcesOfSeedlings" value="<?= HtmlEncode($Page->SourcesOfSeedlings->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_SourcesOfSeedlings" class="el_farm_seed_allocate_SourcesOfSeedlings">
    <select
        id="x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        name="x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        class="form-select ew-select<?= $Page->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Page->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SourcesOfSeedlings->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Page->SourcesOfSeedlings->selectOptionListHtml("x{$Page->RowIndex}_SourcesOfSeedlings") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SourcesOfSeedlings->getErrorMessage() ?></div>
<?= $Page->SourcesOfSeedlings->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SourcesOfSeedlings") ?>
<?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_SourcesOfSeedlings" class="el_farm_seed_allocate_SourcesOfSeedlings">
<span<?= $Page->SourcesOfSeedlings->viewAttributes() ?>>
<?= $Page->SourcesOfSeedlings->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->GRN->Visible) { // GRN ?>
        <td data-name="GRN"<?= $Page->GRN->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_GRN" class="el_farm_seed_allocate_GRN">
    <select
        id="x<?= $Page->RowIndex ?>_GRN"
        name="x<?= $Page->RowIndex ?>_GRN"
        class="form-control ew-select<?= $Page->GRN->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_GRN"
        data-table="farm_seed_allocate"
        data-field="x_GRN"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->GRN->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->GRN->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>"
        <?= $Page->GRN->editAttributes() ?>>
        <?= $Page->GRN->selectOptionListHtml("x{$Page->RowIndex}_GRN") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->GRN->getErrorMessage() ?></div>
<?= $Page->GRN->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_GRN") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_GRN", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_GRN" };
    if (<?= $Page->FormName ?>.lists.GRN?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_GRN", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_GRN", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm_seed_allocate.fields.GRN.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_GRN" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_GRN" id="o<?= $Page->RowIndex ?>_GRN" value="<?= HtmlEncode($Page->GRN->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_GRN" class="el_farm_seed_allocate_GRN">
    <select
        id="x<?= $Page->RowIndex ?>_GRN"
        name="x<?= $Page->RowIndex ?>_GRN"
        class="form-control ew-select<?= $Page->GRN->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_GRN"
        data-table="farm_seed_allocate"
        data-field="x_GRN"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->GRN->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->GRN->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>"
        <?= $Page->GRN->editAttributes() ?>>
        <?= $Page->GRN->selectOptionListHtml("x{$Page->RowIndex}_GRN") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->GRN->getErrorMessage() ?></div>
<?= $Page->GRN->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_GRN") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_GRN", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_GRN" };
    if (<?= $Page->FormName ?>.lists.GRN?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_GRN", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_GRN", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm_seed_allocate.fields.GRN.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_GRN" class="el_farm_seed_allocate_GRN">
<span<?= $Page->GRN->viewAttributes() ?>>
<?= $Page->GRN->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->TreesAllocated->Visible) { // TreesAllocated ?>
        <td data-name="TreesAllocated"<?= $Page->TreesAllocated->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_TreesAllocated" class="el_farm_seed_allocate_TreesAllocated">
<input type="<?= $Page->TreesAllocated->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TreesAllocated" id="x<?= $Page->RowIndex ?>_TreesAllocated" data-table="farm_seed_allocate" data-field="x_TreesAllocated" value="<?= $Page->TreesAllocated->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->TreesAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesAllocated->formatPattern()) ?>"<?= $Page->TreesAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesAllocated->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TreesAllocated" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_TreesAllocated" id="o<?= $Page->RowIndex ?>_TreesAllocated" value="<?= HtmlEncode($Page->TreesAllocated->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_TreesAllocated" class="el_farm_seed_allocate_TreesAllocated">
<input type="<?= $Page->TreesAllocated->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TreesAllocated" id="x<?= $Page->RowIndex ?>_TreesAllocated" data-table="farm_seed_allocate" data-field="x_TreesAllocated" value="<?= $Page->TreesAllocated->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->TreesAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesAllocated->formatPattern()) ?>"<?= $Page->TreesAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesAllocated->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_TreesAllocated" class="el_farm_seed_allocate_TreesAllocated">
<span<?= $Page->TreesAllocated->viewAttributes() ?>>
<?= $Page->TreesAllocated->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->SeedType->Visible) { // SeedType ?>
        <td data-name="SeedType"<?= $Page->SeedType->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_SeedType" class="el_farm_seed_allocate_SeedType">
    <select
        id="x<?= $Page->RowIndex ?>_SeedType"
        name="x<?= $Page->RowIndex ?>_SeedType"
        class="form-select ew-select<?= $Page->SeedType->isInvalidClass() ?>"
        <?php if (!$Page->SeedType->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SeedType"
        data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
        <?= $Page->SeedType->editAttributes() ?>>
        <?= $Page->SeedType->selectOptionListHtml("x{$Page->RowIndex}_SeedType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage() ?></div>
<?= $Page->SeedType->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SeedType") ?>
<?php if (!$Page->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SeedType", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_SeedType" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SeedType" id="o<?= $Page->RowIndex ?>_SeedType" value="<?= HtmlEncode($Page->SeedType->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_SeedType" class="el_farm_seed_allocate_SeedType">
    <select
        id="x<?= $Page->RowIndex ?>_SeedType"
        name="x<?= $Page->RowIndex ?>_SeedType"
        class="form-select ew-select<?= $Page->SeedType->isInvalidClass() ?>"
        <?php if (!$Page->SeedType->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SeedType"
        data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
        <?= $Page->SeedType->editAttributes() ?>>
        <?= $Page->SeedType->selectOptionListHtml("x{$Page->RowIndex}_SeedType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage() ?></div>
<?= $Page->SeedType->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SeedType") ?>
<?php if (!$Page->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SeedType", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_SeedType" class="el_farm_seed_allocate_SeedType">
<span<?= $Page->SeedType->viewAttributes() ?>>
<?= $Page->SeedType->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->TransDate->Visible) { // TransDate ?>
        <td data-name="TransDate"<?= $Page->TransDate->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_TransDate" class="el_farm_seed_allocate_TransDate">
<input type="<?= $Page->TransDate->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TransDate" id="x<?= $Page->RowIndex ?>_TransDate" data-table="farm_seed_allocate" data-field="x_TransDate" value="<?= $Page->TransDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->TransDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TransDate->formatPattern()) ?>"<?= $Page->TransDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TransDate->getErrorMessage() ?></div>
<?php if (!$Page->TransDate->ReadOnly && !$Page->TransDate->Disabled && !isset($Page->TransDate->EditAttrs["readonly"]) && !isset($Page->TransDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_TransDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransDate" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_TransDate" id="o<?= $Page->RowIndex ?>_TransDate" value="<?= HtmlEncode($Page->TransDate->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_TransDate" class="el_farm_seed_allocate_TransDate">
<input type="<?= $Page->TransDate->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TransDate" id="x<?= $Page->RowIndex ?>_TransDate" data-table="farm_seed_allocate" data-field="x_TransDate" value="<?= $Page->TransDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->TransDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TransDate->formatPattern()) ?>"<?= $Page->TransDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TransDate->getErrorMessage() ?></div>
<?php if (!$Page->TransDate->ReadOnly && !$Page->TransDate->Disabled && !isset($Page->TransDate->EditAttrs["readonly"]) && !isset($Page->TransDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_TransDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_seed_allocate_TransDate" class="el_farm_seed_allocate_TransDate">
<span<?= $Page->TransDate->viewAttributes() ?>>
<?= $Page->TransDate->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode" class="<?= $Page->ProvinceCode->footerCellClass() ?>"><span id="elf_farm_seed_allocate_ProvinceCode" class="farm_seed_allocate_ProvinceCode">
        </span></td>
    <?php } ?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode" class="<?= $Page->DistrictCode->footerCellClass() ?>"><span id="elf_farm_seed_allocate_DistrictCode" class="farm_seed_allocate_DistrictCode">
        </span></td>
    <?php } ?>
    <?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode" class="<?= $Page->CampCode->footerCellClass() ?>"><span id="elf_farm_seed_allocate_CampCode" class="farm_seed_allocate_CampCode">
        </span></td>
    <?php } ?>
    <?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode" class="<?= $Page->VillageCode->footerCellClass() ?>"><span id="elf_farm_seed_allocate_VillageCode" class="farm_seed_allocate_VillageCode">
        </span></td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC" class="<?= $Page->NRC->footerCellClass() ?>"><span id="elf_farm_seed_allocate_NRC" class="farm_seed_allocate_NRC">
        </span></td>
    <?php } ?>
    <?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo" class="<?= $Page->FarmerNo->footerCellClass() ?>"><span id="elf_farm_seed_allocate_FarmerNo" class="farm_seed_allocate_FarmerNo">
        </span></td>
    <?php } ?>
    <?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo" class="<?= $Page->FarmNo->footerCellClass() ?>"><span id="elf_farm_seed_allocate_FarmNo" class="farm_seed_allocate_FarmNo">
        </span></td>
    <?php } ?>
    <?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <td data-name="FarmingSeason" class="<?= $Page->FarmingSeason->footerCellClass() ?>"><span id="elf_farm_seed_allocate_FarmingSeason" class="farm_seed_allocate_FarmingSeason">
        </span></td>
    <?php } ?>
    <?php if ($Page->TransNo->Visible) { // TransNo ?>
        <td data-name="TransNo" class="<?= $Page->TransNo->footerCellClass() ?>"><span id="elf_farm_seed_allocate_TransNo" class="farm_seed_allocate_TransNo">
        </span></td>
    <?php } ?>
    <?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <td data-name="SourcesOfSeedlings" class="<?= $Page->SourcesOfSeedlings->footerCellClass() ?>"><span id="elf_farm_seed_allocate_SourcesOfSeedlings" class="farm_seed_allocate_SourcesOfSeedlings">
        </span></td>
    <?php } ?>
    <?php if ($Page->GRN->Visible) { // GRN ?>
        <td data-name="GRN" class="<?= $Page->GRN->footerCellClass() ?>"><span id="elf_farm_seed_allocate_GRN" class="farm_seed_allocate_GRN">
        </span></td>
    <?php } ?>
    <?php if ($Page->TreesAllocated->Visible) { // TreesAllocated ?>
        <td data-name="TreesAllocated" class="<?= $Page->TreesAllocated->footerCellClass() ?>"><span id="elf_farm_seed_allocate_TreesAllocated" class="farm_seed_allocate_TreesAllocated">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->TreesAllocated->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->SeedType->Visible) { // SeedType ?>
        <td data-name="SeedType" class="<?= $Page->SeedType->footerCellClass() ?>"><span id="elf_farm_seed_allocate_SeedType" class="farm_seed_allocate_SeedType">
        </span></td>
    <?php } ?>
    <?php if ($Page->TransDate->Visible) { // TransDate ?>
        <td data-name="TransDate" class="<?= $Page->TransDate->footerCellClass() ?>"><span id="elf_farm_seed_allocate_TransDate" class="farm_seed_allocate_TransDate">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm_seed_allocate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
