<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("FarmSeedAllocateGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var ffarm_seed_allocategrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { farm_seed_allocate: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffarm_seed_allocategrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerNo", [fields.FarmerNo.visible && fields.FarmerNo.required ? ew.Validators.required(fields.FarmerNo.caption) : null, ew.Validators.integer], fields.FarmerNo.isInvalid],
            ["FarmNo", [fields.FarmNo.visible && fields.FarmNo.required ? ew.Validators.required(fields.FarmNo.caption) : null, ew.Validators.integer], fields.FarmNo.isInvalid],
            ["FarmingSeason", [fields.FarmingSeason.visible && fields.FarmingSeason.required ? ew.Validators.required(fields.FarmingSeason.caption) : null], fields.FarmingSeason.isInvalid],
            ["TransNo", [fields.TransNo.visible && fields.TransNo.required ? ew.Validators.required(fields.TransNo.caption) : null], fields.TransNo.isInvalid],
            ["SourcesOfSeedlings", [fields.SourcesOfSeedlings.visible && fields.SourcesOfSeedlings.required ? ew.Validators.required(fields.SourcesOfSeedlings.caption) : null], fields.SourcesOfSeedlings.isInvalid],
            ["GRN", [fields.GRN.visible && fields.GRN.required ? ew.Validators.required(fields.GRN.caption) : null], fields.GRN.isInvalid],
            ["TreesAllocated", [fields.TreesAllocated.visible && fields.TreesAllocated.required ? ew.Validators.required(fields.TreesAllocated.caption) : null], fields.TreesAllocated.isInvalid],
            ["SeedType", [fields.SeedType.visible && fields.SeedType.required ? ew.Validators.required(fields.SeedType.caption) : null], fields.SeedType.isInvalid],
            ["TransDate", [fields.TransDate.visible && fields.TransDate.required ? ew.Validators.required(fields.TransDate.caption) : null, ew.Validators.datetime(fields.TransDate.clientFormatPattern)], fields.TransDate.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false],["NRC",false],["FarmerNo",false],["FarmNo",false],["FarmingSeason",false],["SourcesOfSeedlings",false],["GRN",false],["TreesAllocated",false],["SeedType",false],["TransDate",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Grid->ProvinceCode->toClientList($Grid) ?>,
            "DistrictCode": <?= $Grid->DistrictCode->toClientList($Grid) ?>,
            "CampCode": <?= $Grid->CampCode->toClientList($Grid) ?>,
            "VillageCode": <?= $Grid->VillageCode->toClientList($Grid) ?>,
            "NRC": <?= $Grid->NRC->toClientList($Grid) ?>,
            "FarmingSeason": <?= $Grid->FarmingSeason->toClientList($Grid) ?>,
            "SourcesOfSeedlings": <?= $Grid->SourcesOfSeedlings->toClientList($Grid) ?>,
            "GRN": <?= $Grid->GRN->toClientList($Grid) ?>,
            "SeedType": <?= $Grid->SeedType->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="ffarm_seed_allocategrid" class="ew-form ew-list-form">
<div id="gmp_farm_seed_allocate" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_farm_seed_allocategrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Grid->ProvinceCode->headerCellClass() ?>"><div id="elh_farm_seed_allocate_ProvinceCode" class="farm_seed_allocate_ProvinceCode"><?= $Grid->renderFieldHeader($Grid->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Grid->DistrictCode->headerCellClass() ?>"><div id="elh_farm_seed_allocate_DistrictCode" class="farm_seed_allocate_DistrictCode"><?= $Grid->renderFieldHeader($Grid->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Grid->CampCode->headerCellClass() ?>"><div id="elh_farm_seed_allocate_CampCode" class="farm_seed_allocate_CampCode"><?= $Grid->renderFieldHeader($Grid->CampCode) ?></div></th>
<?php } ?>
<?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Grid->VillageCode->headerCellClass() ?>"><div id="elh_farm_seed_allocate_VillageCode" class="farm_seed_allocate_VillageCode"><?= $Grid->renderFieldHeader($Grid->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Grid->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Grid->NRC->headerCellClass() ?>"><div id="elh_farm_seed_allocate_NRC" class="farm_seed_allocate_NRC"><?= $Grid->renderFieldHeader($Grid->NRC) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmerNo->Visible) { // FarmerNo ?>
        <th data-name="FarmerNo" class="<?= $Grid->FarmerNo->headerCellClass() ?>"><div id="elh_farm_seed_allocate_FarmerNo" class="farm_seed_allocate_FarmerNo"><?= $Grid->renderFieldHeader($Grid->FarmerNo) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmNo->Visible) { // FarmNo ?>
        <th data-name="FarmNo" class="<?= $Grid->FarmNo->headerCellClass() ?>"><div id="elh_farm_seed_allocate_FarmNo" class="farm_seed_allocate_FarmNo"><?= $Grid->renderFieldHeader($Grid->FarmNo) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmingSeason->Visible) { // FarmingSeason ?>
        <th data-name="FarmingSeason" class="<?= $Grid->FarmingSeason->headerCellClass() ?>"><div id="elh_farm_seed_allocate_FarmingSeason" class="farm_seed_allocate_FarmingSeason"><?= $Grid->renderFieldHeader($Grid->FarmingSeason) ?></div></th>
<?php } ?>
<?php if ($Grid->TransNo->Visible) { // TransNo ?>
        <th data-name="TransNo" class="<?= $Grid->TransNo->headerCellClass() ?>"><div id="elh_farm_seed_allocate_TransNo" class="farm_seed_allocate_TransNo"><?= $Grid->renderFieldHeader($Grid->TransNo) ?></div></th>
<?php } ?>
<?php if ($Grid->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <th data-name="SourcesOfSeedlings" class="<?= $Grid->SourcesOfSeedlings->headerCellClass() ?>"><div id="elh_farm_seed_allocate_SourcesOfSeedlings" class="farm_seed_allocate_SourcesOfSeedlings"><?= $Grid->renderFieldHeader($Grid->SourcesOfSeedlings) ?></div></th>
<?php } ?>
<?php if ($Grid->GRN->Visible) { // GRN ?>
        <th data-name="GRN" class="<?= $Grid->GRN->headerCellClass() ?>"><div id="elh_farm_seed_allocate_GRN" class="farm_seed_allocate_GRN"><?= $Grid->renderFieldHeader($Grid->GRN) ?></div></th>
<?php } ?>
<?php if ($Grid->TreesAllocated->Visible) { // TreesAllocated ?>
        <th data-name="TreesAllocated" class="<?= $Grid->TreesAllocated->headerCellClass() ?>"><div id="elh_farm_seed_allocate_TreesAllocated" class="farm_seed_allocate_TreesAllocated"><?= $Grid->renderFieldHeader($Grid->TreesAllocated) ?></div></th>
<?php } ?>
<?php if ($Grid->SeedType->Visible) { // SeedType ?>
        <th data-name="SeedType" class="<?= $Grid->SeedType->headerCellClass() ?>"><div id="elh_farm_seed_allocate_SeedType" class="farm_seed_allocate_SeedType"><?= $Grid->renderFieldHeader($Grid->SeedType) ?></div></th>
<?php } ?>
<?php if ($Grid->TransDate->Visible) { // TransDate ?>
        <th data-name="TransDate" class="<?= $Grid->TransDate->headerCellClass() ?>"><div id="elh_farm_seed_allocate_TransDate" class="farm_seed_allocate_TransDate"><?= $Grid->renderFieldHeader($Grid->TransDate) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Grid->ProvinceCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_ProvinceCode" class="el_farm_seed_allocate_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProvinceCode" id="o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_ProvinceCode" class="el_farm_seed_allocate_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_ProvinceCode" class="el_farm_seed_allocate_ProvinceCode">
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<?= $Grid->ProvinceCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_ProvinceCode" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_ProvinceCode" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_ProvinceCode" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_ProvinceCode" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Grid->DistrictCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_DistrictCode" class="el_farm_seed_allocate_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DistrictCode" id="o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_DistrictCode" class="el_farm_seed_allocate_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_DistrictCode" class="el_farm_seed_allocate_DistrictCode">
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<?= $Grid->DistrictCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_DistrictCode" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_DistrictCode" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_DistrictCode" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_DistrictCode" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Grid->CampCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->CampCode->getSessionValue() != "") { ?>
<span<?= $Grid->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->CampCode->getDisplayValue($Grid->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_CampCode" name="x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_CampCode" class="el_farm_seed_allocate_CampCode">
    <select
        id="x<?= $Grid->RowIndex ?>_CampCode"
        name="x<?= $Grid->RowIndex ?>_CampCode"
        class="form-select ew-select<?= $Grid->CampCode->isInvalidClass() ?>"
        <?php if (!$Grid->CampCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_CampCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_CampCode"
        data-value-separator="<?= $Grid->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->CampCode->editAttributes() ?>>
        <?= $Grid->CampCode->selectOptionListHtml("x{$Grid->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->CampCode->getErrorMessage() ?></div>
<?= $Grid->CampCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_CampCode") ?>
<?php if (!$Grid->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_CampCode", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_CampCode" id="o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->CampCode->getSessionValue() != "") { ?>
<span<?= $Grid->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->CampCode->getDisplayValue($Grid->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_CampCode" name="x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_CampCode" class="el_farm_seed_allocate_CampCode">
    <select
        id="x<?= $Grid->RowIndex ?>_CampCode"
        name="x<?= $Grid->RowIndex ?>_CampCode"
        class="form-select ew-select<?= $Grid->CampCode->isInvalidClass() ?>"
        <?php if (!$Grid->CampCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_CampCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_CampCode"
        data-value-separator="<?= $Grid->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->CampCode->editAttributes() ?>>
        <?= $Grid->CampCode->selectOptionListHtml("x{$Grid->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->CampCode->getErrorMessage() ?></div>
<?= $Grid->CampCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_CampCode") ?>
<?php if (!$Grid->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_CampCode", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_CampCode" class="el_farm_seed_allocate_CampCode">
<span<?= $Grid->CampCode->viewAttributes() ?>>
<?= $Grid->CampCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_CampCode" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_CampCode" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_CampCode" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_CampCode" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Grid->VillageCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->VillageCode->getSessionValue() != "") { ?>
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->VillageCode->getDisplayValue($Grid->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_VillageCode" name="x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_VillageCode" class="el_farm_seed_allocate_VillageCode">
    <select
        id="x<?= $Grid->RowIndex ?>_VillageCode"
        name="x<?= $Grid->RowIndex ?>_VillageCode"
        class="form-select ew-select<?= $Grid->VillageCode->isInvalidClass() ?>"
        <?php if (!$Grid->VillageCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_VillageCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_VillageCode"
        data-value-separator="<?= $Grid->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->VillageCode->getPlaceHolder()) ?>"
        <?= $Grid->VillageCode->editAttributes() ?>>
        <?= $Grid->VillageCode->selectOptionListHtml("x{$Grid->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->VillageCode->getErrorMessage() ?></div>
<?= $Grid->VillageCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_VillageCode") ?>
<?php if (!$Grid->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_VillageCode", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_VillageCode" id="o<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->VillageCode->getSessionValue() != "") { ?>
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->VillageCode->getDisplayValue($Grid->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_VillageCode" name="x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_VillageCode" class="el_farm_seed_allocate_VillageCode">
    <select
        id="x<?= $Grid->RowIndex ?>_VillageCode"
        name="x<?= $Grid->RowIndex ?>_VillageCode"
        class="form-select ew-select<?= $Grid->VillageCode->isInvalidClass() ?>"
        <?php if (!$Grid->VillageCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_VillageCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_VillageCode"
        data-value-separator="<?= $Grid->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->VillageCode->getPlaceHolder()) ?>"
        <?= $Grid->VillageCode->editAttributes() ?>>
        <?= $Grid->VillageCode->selectOptionListHtml("x{$Grid->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->VillageCode->getErrorMessage() ?></div>
<?= $Grid->VillageCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_VillageCode") ?>
<?php if (!$Grid->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_VillageCode", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_VillageCode" class="el_farm_seed_allocate_VillageCode">
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<?= $Grid->VillageCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_VillageCode" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_VillageCode" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_VillageCode" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_VillageCode" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Grid->NRC->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_NRC" class="el_farm_seed_allocate_NRC">
<?php
if (IsRTL()) {
    $Grid->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Grid->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_NRC" id="sv_x<?= $Grid->RowIndex ?>_NRC" value="<?= RemoveHtml($Grid->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NRC->formatPattern()) ?>"<?= $Grid->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm_seed_allocate" data-field="x_NRC" data-input="sv_x<?= $Grid->RowIndex ?>_NRC" data-value-separator="<?= $Grid->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    ffarm_seed_allocategrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm_seed_allocate.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Grid->NRC->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NRC") ?>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NRC" id="o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_NRC" class="el_farm_seed_allocate_NRC">
<?php
if (IsRTL()) {
    $Grid->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Grid->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_NRC" id="sv_x<?= $Grid->RowIndex ?>_NRC" value="<?= RemoveHtml($Grid->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NRC->formatPattern()) ?>"<?= $Grid->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm_seed_allocate" data-field="x_NRC" data-input="sv_x<?= $Grid->RowIndex ?>_NRC" data-value-separator="<?= $Grid->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    ffarm_seed_allocategrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm_seed_allocate.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Grid->NRC->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NRC") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_NRC" class="el_farm_seed_allocate_NRC">
<span<?= $Grid->NRC->viewAttributes() ?>>
<?= $Grid->NRC->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_NRC" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_NRC" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_NRC" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_NRC" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo"<?= $Grid->FarmerNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_FarmerNo" class="el_farm_seed_allocate_FarmerNo">
<input type="<?= $Grid->FarmerNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmerNo" id="x<?= $Grid->RowIndex ?>_FarmerNo" data-table="farm_seed_allocate" data-field="x_FarmerNo" value="<?= $Grid->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmerNo->formatPattern()) ?>"<?= $Grid->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmerNo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmerNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmerNo" id="o<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_FarmerNo" class="el_farm_seed_allocate_FarmerNo">
<input type="<?= $Grid->FarmerNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmerNo" id="x<?= $Grid->RowIndex ?>_FarmerNo" data-table="farm_seed_allocate" data-field="x_FarmerNo" value="<?= $Grid->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmerNo->formatPattern()) ?>"<?= $Grid->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmerNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_FarmerNo" class="el_farm_seed_allocate_FarmerNo">
<span<?= $Grid->FarmerNo->viewAttributes() ?>>
<?= $Grid->FarmerNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmerNo" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_FarmerNo" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmerNo" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_FarmerNo" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo"<?= $Grid->FarmNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->FarmNo->getSessionValue() != "") { ?>
<span<?= $Grid->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->FarmNo->getDisplayValue($Grid->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_FarmNo" name="x<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_FarmNo" class="el_farm_seed_allocate_FarmNo">
<input type="<?= $Grid->FarmNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmNo" id="x<?= $Grid->RowIndex ?>_FarmNo" data-table="farm_seed_allocate" data-field="x_FarmNo" value="<?= $Grid->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmNo->formatPattern()) ?>"<?= $Grid->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmNo" id="o<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->FarmNo->getSessionValue() != "") { ?>
<span<?= $Grid->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->FarmNo->getDisplayValue($Grid->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_FarmNo" name="x<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_FarmNo" class="el_farm_seed_allocate_FarmNo">
<input type="<?= $Grid->FarmNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmNo" id="x<?= $Grid->RowIndex ?>_FarmNo" data-table="farm_seed_allocate" data-field="x_FarmNo" value="<?= $Grid->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmNo->formatPattern()) ?>"<?= $Grid->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_FarmNo" class="el_farm_seed_allocate_FarmNo">
<span<?= $Grid->FarmNo->viewAttributes() ?>>
<?= $Grid->FarmNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmNo" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_FarmNo" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmNo" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_FarmNo" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmingSeason->Visible) { // FarmingSeason ?>
        <td data-name="FarmingSeason"<?= $Grid->FarmingSeason->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_FarmingSeason" class="el_farm_seed_allocate_FarmingSeason">
    <select
        id="x<?= $Grid->RowIndex ?>_FarmingSeason"
        name="x<?= $Grid->RowIndex ?>_FarmingSeason"
        class="form-select ew-select<?= $Grid->FarmingSeason->isInvalidClass() ?>"
        <?php if (!$Grid->FarmingSeason->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_FarmingSeason"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_FarmingSeason"
        data-value-separator="<?= $Grid->FarmingSeason->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->FarmingSeason->getPlaceHolder()) ?>"
        <?= $Grid->FarmingSeason->editAttributes() ?>>
        <?= $Grid->FarmingSeason->selectOptionListHtml("x{$Grid->RowIndex}_FarmingSeason") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->FarmingSeason->getErrorMessage() ?></div>
<?= $Grid->FarmingSeason->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FarmingSeason") ?>
<?php if (!$Grid->FarmingSeason->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_FarmingSeason", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_FarmingSeason" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.FarmingSeason?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_FarmingSeason", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_FarmingSeason", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.FarmingSeason.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmingSeason" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmingSeason" id="o<?= $Grid->RowIndex ?>_FarmingSeason" value="<?= HtmlEncode($Grid->FarmingSeason->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_FarmingSeason" class="el_farm_seed_allocate_FarmingSeason">
    <select
        id="x<?= $Grid->RowIndex ?>_FarmingSeason"
        name="x<?= $Grid->RowIndex ?>_FarmingSeason"
        class="form-select ew-select<?= $Grid->FarmingSeason->isInvalidClass() ?>"
        <?php if (!$Grid->FarmingSeason->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_FarmingSeason"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_FarmingSeason"
        data-value-separator="<?= $Grid->FarmingSeason->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->FarmingSeason->getPlaceHolder()) ?>"
        <?= $Grid->FarmingSeason->editAttributes() ?>>
        <?= $Grid->FarmingSeason->selectOptionListHtml("x{$Grid->RowIndex}_FarmingSeason") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->FarmingSeason->getErrorMessage() ?></div>
<?= $Grid->FarmingSeason->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FarmingSeason") ?>
<?php if (!$Grid->FarmingSeason->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_FarmingSeason", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_FarmingSeason" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.FarmingSeason?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_FarmingSeason", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_FarmingSeason", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.FarmingSeason.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_FarmingSeason" class="el_farm_seed_allocate_FarmingSeason">
<span<?= $Grid->FarmingSeason->viewAttributes() ?>>
<?= $Grid->FarmingSeason->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmingSeason" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_FarmingSeason" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_FarmingSeason" value="<?= HtmlEncode($Grid->FarmingSeason->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_FarmingSeason" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_FarmingSeason" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_FarmingSeason" value="<?= HtmlEncode($Grid->FarmingSeason->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->TransNo->Visible) { // TransNo ?>
        <td data-name="TransNo"<?= $Grid->TransNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_TransNo" class="el_farm_seed_allocate_TransNo"></span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_TransNo" id="o<?= $Grid->RowIndex ?>_TransNo" value="<?= HtmlEncode($Grid->TransNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_TransNo" class="el_farm_seed_allocate_TransNo">
<span<?= $Grid->TransNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->TransNo->getDisplayValue($Grid->TransNo->EditValue))) ?>"></span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransNo" data-hidden="1" name="x<?= $Grid->RowIndex ?>_TransNo" id="x<?= $Grid->RowIndex ?>_TransNo" value="<?= HtmlEncode($Grid->TransNo->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_TransNo" class="el_farm_seed_allocate_TransNo">
<span<?= $Grid->TransNo->viewAttributes() ?>>
<?= $Grid->TransNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransNo" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_TransNo" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_TransNo" value="<?= HtmlEncode($Grid->TransNo->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransNo" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_TransNo" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_TransNo" value="<?= HtmlEncode($Grid->TransNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="farm_seed_allocate" data-field="x_TransNo" data-hidden="1" name="x<?= $Grid->RowIndex ?>_TransNo" id="x<?= $Grid->RowIndex ?>_TransNo" value="<?= HtmlEncode($Grid->TransNo->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <td data-name="SourcesOfSeedlings"<?= $Grid->SourcesOfSeedlings->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_SourcesOfSeedlings" class="el_farm_seed_allocate_SourcesOfSeedlings">
    <select
        id="x<?= $Grid->RowIndex ?>_SourcesOfSeedlings"
        name="x<?= $Grid->RowIndex ?>_SourcesOfSeedlings"
        class="form-select ew-select<?= $Grid->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Grid->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Grid->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->SourcesOfSeedlings->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Grid->SourcesOfSeedlings->selectOptionListHtml("x{$Grid->RowIndex}_SourcesOfSeedlings") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->SourcesOfSeedlings->getErrorMessage() ?></div>
<?= $Grid->SourcesOfSeedlings->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_SourcesOfSeedlings") ?>
<?php if (!$Grid->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_SourcesOfSeedlings", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_SourcesOfSeedlings", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_SourcesOfSeedlings", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_SourcesOfSeedlings" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_SourcesOfSeedlings" id="o<?= $Grid->RowIndex ?>_SourcesOfSeedlings" value="<?= HtmlEncode($Grid->SourcesOfSeedlings->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_SourcesOfSeedlings" class="el_farm_seed_allocate_SourcesOfSeedlings">
    <select
        id="x<?= $Grid->RowIndex ?>_SourcesOfSeedlings"
        name="x<?= $Grid->RowIndex ?>_SourcesOfSeedlings"
        class="form-select ew-select<?= $Grid->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Grid->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Grid->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->SourcesOfSeedlings->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Grid->SourcesOfSeedlings->selectOptionListHtml("x{$Grid->RowIndex}_SourcesOfSeedlings") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->SourcesOfSeedlings->getErrorMessage() ?></div>
<?= $Grid->SourcesOfSeedlings->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_SourcesOfSeedlings") ?>
<?php if (!$Grid->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_SourcesOfSeedlings", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_SourcesOfSeedlings", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_SourcesOfSeedlings", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_SourcesOfSeedlings" class="el_farm_seed_allocate_SourcesOfSeedlings">
<span<?= $Grid->SourcesOfSeedlings->viewAttributes() ?>>
<?= $Grid->SourcesOfSeedlings->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_SourcesOfSeedlings" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_SourcesOfSeedlings" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_SourcesOfSeedlings" value="<?= HtmlEncode($Grid->SourcesOfSeedlings->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_SourcesOfSeedlings" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_SourcesOfSeedlings" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_SourcesOfSeedlings" value="<?= HtmlEncode($Grid->SourcesOfSeedlings->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->GRN->Visible) { // GRN ?>
        <td data-name="GRN"<?= $Grid->GRN->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_GRN" class="el_farm_seed_allocate_GRN">
    <select
        id="x<?= $Grid->RowIndex ?>_GRN"
        name="x<?= $Grid->RowIndex ?>_GRN"
        class="form-control ew-select<?= $Grid->GRN->isInvalidClass() ?>"
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_GRN"
        data-table="farm_seed_allocate"
        data-field="x_GRN"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->GRN->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->GRN->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->GRN->getPlaceHolder()) ?>"
        <?= $Grid->GRN->editAttributes() ?>>
        <?= $Grid->GRN->selectOptionListHtml("x{$Grid->RowIndex}_GRN") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->GRN->getErrorMessage() ?></div>
<?= $Grid->GRN->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_GRN") ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_GRN", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_GRN" };
    if (ffarm_seed_allocategrid.lists.GRN?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_GRN", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_GRN", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm_seed_allocate.fields.GRN.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_GRN" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_GRN" id="o<?= $Grid->RowIndex ?>_GRN" value="<?= HtmlEncode($Grid->GRN->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_GRN" class="el_farm_seed_allocate_GRN">
    <select
        id="x<?= $Grid->RowIndex ?>_GRN"
        name="x<?= $Grid->RowIndex ?>_GRN"
        class="form-control ew-select<?= $Grid->GRN->isInvalidClass() ?>"
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_GRN"
        data-table="farm_seed_allocate"
        data-field="x_GRN"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->GRN->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->GRN->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->GRN->getPlaceHolder()) ?>"
        <?= $Grid->GRN->editAttributes() ?>>
        <?= $Grid->GRN->selectOptionListHtml("x{$Grid->RowIndex}_GRN") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->GRN->getErrorMessage() ?></div>
<?= $Grid->GRN->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_GRN") ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_GRN", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_GRN" };
    if (ffarm_seed_allocategrid.lists.GRN?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_GRN", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_GRN", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm_seed_allocate.fields.GRN.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_GRN" class="el_farm_seed_allocate_GRN">
<span<?= $Grid->GRN->viewAttributes() ?>>
<?= $Grid->GRN->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_GRN" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_GRN" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_GRN" value="<?= HtmlEncode($Grid->GRN->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_GRN" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_GRN" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_GRN" value="<?= HtmlEncode($Grid->GRN->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->TreesAllocated->Visible) { // TreesAllocated ?>
        <td data-name="TreesAllocated"<?= $Grid->TreesAllocated->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_TreesAllocated" class="el_farm_seed_allocate_TreesAllocated">
<input type="<?= $Grid->TreesAllocated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TreesAllocated" id="x<?= $Grid->RowIndex ?>_TreesAllocated" data-table="farm_seed_allocate" data-field="x_TreesAllocated" value="<?= $Grid->TreesAllocated->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->TreesAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TreesAllocated->formatPattern()) ?>"<?= $Grid->TreesAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TreesAllocated->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TreesAllocated" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_TreesAllocated" id="o<?= $Grid->RowIndex ?>_TreesAllocated" value="<?= HtmlEncode($Grid->TreesAllocated->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_TreesAllocated" class="el_farm_seed_allocate_TreesAllocated">
<input type="<?= $Grid->TreesAllocated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TreesAllocated" id="x<?= $Grid->RowIndex ?>_TreesAllocated" data-table="farm_seed_allocate" data-field="x_TreesAllocated" value="<?= $Grid->TreesAllocated->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->TreesAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TreesAllocated->formatPattern()) ?>"<?= $Grid->TreesAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TreesAllocated->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_TreesAllocated" class="el_farm_seed_allocate_TreesAllocated">
<span<?= $Grid->TreesAllocated->viewAttributes() ?>>
<?= $Grid->TreesAllocated->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TreesAllocated" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_TreesAllocated" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_TreesAllocated" value="<?= HtmlEncode($Grid->TreesAllocated->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TreesAllocated" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_TreesAllocated" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_TreesAllocated" value="<?= HtmlEncode($Grid->TreesAllocated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->SeedType->Visible) { // SeedType ?>
        <td data-name="SeedType"<?= $Grid->SeedType->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_SeedType" class="el_farm_seed_allocate_SeedType">
    <select
        id="x<?= $Grid->RowIndex ?>_SeedType"
        name="x<?= $Grid->RowIndex ?>_SeedType"
        class="form-select ew-select<?= $Grid->SeedType->isInvalidClass() ?>"
        <?php if (!$Grid->SeedType->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_SeedType"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SeedType"
        data-value-separator="<?= $Grid->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->SeedType->getPlaceHolder()) ?>"
        <?= $Grid->SeedType->editAttributes() ?>>
        <?= $Grid->SeedType->selectOptionListHtml("x{$Grid->RowIndex}_SeedType") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->SeedType->getErrorMessage() ?></div>
<?= $Grid->SeedType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_SeedType") ?>
<?php if (!$Grid->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_SeedType", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_SeedType", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_SeedType", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_SeedType" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_SeedType" id="o<?= $Grid->RowIndex ?>_SeedType" value="<?= HtmlEncode($Grid->SeedType->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_SeedType" class="el_farm_seed_allocate_SeedType">
    <select
        id="x<?= $Grid->RowIndex ?>_SeedType"
        name="x<?= $Grid->RowIndex ?>_SeedType"
        class="form-select ew-select<?= $Grid->SeedType->isInvalidClass() ?>"
        <?php if (!$Grid->SeedType->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_SeedType"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SeedType"
        data-value-separator="<?= $Grid->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->SeedType->getPlaceHolder()) ?>"
        <?= $Grid->SeedType->editAttributes() ?>>
        <?= $Grid->SeedType->selectOptionListHtml("x{$Grid->RowIndex}_SeedType") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->SeedType->getErrorMessage() ?></div>
<?= $Grid->SeedType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_SeedType") ?>
<?php if (!$Grid->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocategrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_SeedType", selectId: "ffarm_seed_allocategrid_x<?= $Grid->RowIndex ?>_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocategrid.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_SeedType", form: "ffarm_seed_allocategrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_SeedType", form: "ffarm_seed_allocategrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_SeedType" class="el_farm_seed_allocate_SeedType">
<span<?= $Grid->SeedType->viewAttributes() ?>>
<?= $Grid->SeedType->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_SeedType" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_SeedType" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_SeedType" value="<?= HtmlEncode($Grid->SeedType->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_SeedType" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_SeedType" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_SeedType" value="<?= HtmlEncode($Grid->SeedType->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->TransDate->Visible) { // TransDate ?>
        <td data-name="TransDate"<?= $Grid->TransDate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_TransDate" class="el_farm_seed_allocate_TransDate">
<input type="<?= $Grid->TransDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TransDate" id="x<?= $Grid->RowIndex ?>_TransDate" data-table="farm_seed_allocate" data-field="x_TransDate" value="<?= $Grid->TransDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->TransDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TransDate->formatPattern()) ?>"<?= $Grid->TransDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TransDate->getErrorMessage() ?></div>
<?php if (!$Grid->TransDate->ReadOnly && !$Grid->TransDate->Disabled && !isset($Grid->TransDate->EditAttrs["readonly"]) && !isset($Grid->TransDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffarm_seed_allocategrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffarm_seed_allocategrid", "x<?= $Grid->RowIndex ?>_TransDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransDate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_TransDate" id="o<?= $Grid->RowIndex ?>_TransDate" value="<?= HtmlEncode($Grid->TransDate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_TransDate" class="el_farm_seed_allocate_TransDate">
<input type="<?= $Grid->TransDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TransDate" id="x<?= $Grid->RowIndex ?>_TransDate" data-table="farm_seed_allocate" data-field="x_TransDate" value="<?= $Grid->TransDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->TransDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TransDate->formatPattern()) ?>"<?= $Grid->TransDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TransDate->getErrorMessage() ?></div>
<?php if (!$Grid->TransDate->ReadOnly && !$Grid->TransDate->Disabled && !isset($Grid->TransDate->EditAttrs["readonly"]) && !isset($Grid->TransDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffarm_seed_allocategrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffarm_seed_allocategrid", "x<?= $Grid->RowIndex ?>_TransDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_seed_allocate_TransDate" class="el_farm_seed_allocate_TransDate">
<span<?= $Grid->TransDate->viewAttributes() ?>>
<?= $Grid->TransDate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransDate" data-hidden="1" name="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_TransDate" id="ffarm_seed_allocategrid$x<?= $Grid->RowIndex ?>_TransDate" value="<?= HtmlEncode($Grid->TransDate->FormValue) ?>">
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransDate" data-hidden="1" data-old name="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_TransDate" id="ffarm_seed_allocategrid$o<?= $Grid->RowIndex ?>_TransDate" value="<?= HtmlEncode($Grid->TransDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["ffarm_seed_allocategrid","load"], () => ffarm_seed_allocategrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode" class="<?= $Grid->ProvinceCode->footerCellClass() ?>"><span id="elf_farm_seed_allocate_ProvinceCode" class="farm_seed_allocate_ProvinceCode">
        </span></td>
    <?php } ?>
    <?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode" class="<?= $Grid->DistrictCode->footerCellClass() ?>"><span id="elf_farm_seed_allocate_DistrictCode" class="farm_seed_allocate_DistrictCode">
        </span></td>
    <?php } ?>
    <?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode" class="<?= $Grid->CampCode->footerCellClass() ?>"><span id="elf_farm_seed_allocate_CampCode" class="farm_seed_allocate_CampCode">
        </span></td>
    <?php } ?>
    <?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode" class="<?= $Grid->VillageCode->footerCellClass() ?>"><span id="elf_farm_seed_allocate_VillageCode" class="farm_seed_allocate_VillageCode">
        </span></td>
    <?php } ?>
    <?php if ($Grid->NRC->Visible) { // NRC ?>
        <td data-name="NRC" class="<?= $Grid->NRC->footerCellClass() ?>"><span id="elf_farm_seed_allocate_NRC" class="farm_seed_allocate_NRC">
        </span></td>
    <?php } ?>
    <?php if ($Grid->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo" class="<?= $Grid->FarmerNo->footerCellClass() ?>"><span id="elf_farm_seed_allocate_FarmerNo" class="farm_seed_allocate_FarmerNo">
        </span></td>
    <?php } ?>
    <?php if ($Grid->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo" class="<?= $Grid->FarmNo->footerCellClass() ?>"><span id="elf_farm_seed_allocate_FarmNo" class="farm_seed_allocate_FarmNo">
        </span></td>
    <?php } ?>
    <?php if ($Grid->FarmingSeason->Visible) { // FarmingSeason ?>
        <td data-name="FarmingSeason" class="<?= $Grid->FarmingSeason->footerCellClass() ?>"><span id="elf_farm_seed_allocate_FarmingSeason" class="farm_seed_allocate_FarmingSeason">
        </span></td>
    <?php } ?>
    <?php if ($Grid->TransNo->Visible) { // TransNo ?>
        <td data-name="TransNo" class="<?= $Grid->TransNo->footerCellClass() ?>"><span id="elf_farm_seed_allocate_TransNo" class="farm_seed_allocate_TransNo">
        </span></td>
    <?php } ?>
    <?php if ($Grid->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <td data-name="SourcesOfSeedlings" class="<?= $Grid->SourcesOfSeedlings->footerCellClass() ?>"><span id="elf_farm_seed_allocate_SourcesOfSeedlings" class="farm_seed_allocate_SourcesOfSeedlings">
        </span></td>
    <?php } ?>
    <?php if ($Grid->GRN->Visible) { // GRN ?>
        <td data-name="GRN" class="<?= $Grid->GRN->footerCellClass() ?>"><span id="elf_farm_seed_allocate_GRN" class="farm_seed_allocate_GRN">
        </span></td>
    <?php } ?>
    <?php if ($Grid->TreesAllocated->Visible) { // TreesAllocated ?>
        <td data-name="TreesAllocated" class="<?= $Grid->TreesAllocated->footerCellClass() ?>"><span id="elf_farm_seed_allocate_TreesAllocated" class="farm_seed_allocate_TreesAllocated">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->TreesAllocated->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->SeedType->Visible) { // SeedType ?>
        <td data-name="SeedType" class="<?= $Grid->SeedType->footerCellClass() ?>"><span id="elf_farm_seed_allocate_SeedType" class="farm_seed_allocate_SeedType">
        </span></td>
    <?php } ?>
    <?php if ($Grid->TransDate->Visible) { // TransDate ?>
        <td data-name="TransDate" class="<?= $Grid->TransDate->footerCellClass() ?>"><span id="elf_farm_seed_allocate_TransDate" class="farm_seed_allocate_TransDate">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ffarm_seed_allocategrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm_seed_allocate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
