<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmSeedAllocateEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="ffarm_seed_allocateedit" id="ffarm_seed_allocateedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_seed_allocate: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var ffarm_seed_allocateedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffarm_seed_allocateedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerNo", [fields.FarmerNo.visible && fields.FarmerNo.required ? ew.Validators.required(fields.FarmerNo.caption) : null, ew.Validators.integer], fields.FarmerNo.isInvalid],
            ["FarmNo", [fields.FarmNo.visible && fields.FarmNo.required ? ew.Validators.required(fields.FarmNo.caption) : null, ew.Validators.integer], fields.FarmNo.isInvalid],
            ["FarmingSeason", [fields.FarmingSeason.visible && fields.FarmingSeason.required ? ew.Validators.required(fields.FarmingSeason.caption) : null], fields.FarmingSeason.isInvalid],
            ["TransNo", [fields.TransNo.visible && fields.TransNo.required ? ew.Validators.required(fields.TransNo.caption) : null], fields.TransNo.isInvalid],
            ["SourcesOfSeedlings", [fields.SourcesOfSeedlings.visible && fields.SourcesOfSeedlings.required ? ew.Validators.required(fields.SourcesOfSeedlings.caption) : null], fields.SourcesOfSeedlings.isInvalid],
            ["GRN", [fields.GRN.visible && fields.GRN.required ? ew.Validators.required(fields.GRN.caption) : null], fields.GRN.isInvalid],
            ["TreesAllocated", [fields.TreesAllocated.visible && fields.TreesAllocated.required ? ew.Validators.required(fields.TreesAllocated.caption) : null], fields.TreesAllocated.isInvalid],
            ["SeedType", [fields.SeedType.visible && fields.SeedType.required ? ew.Validators.required(fields.SeedType.caption) : null], fields.SeedType.isInvalid],
            ["TransDate", [fields.TransDate.visible && fields.TransDate.required ? ew.Validators.required(fields.TransDate.caption) : null, ew.Validators.datetime(fields.TransDate.clientFormatPattern)], fields.TransDate.isInvalid],
            ["PreparedBy", [fields.PreparedBy.visible && fields.PreparedBy.required ? ew.Validators.required(fields.PreparedBy.caption) : null], fields.PreparedBy.isInvalid],
            ["AuthorisedBy", [fields.AuthorisedBy.visible && fields.AuthorisedBy.required ? ew.Validators.required(fields.AuthorisedBy.caption) : null], fields.AuthorisedBy.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FarmingSeason": <?= $Page->FarmingSeason->toClientList($Page) ?>,
            "SourcesOfSeedlings": <?= $Page->SourcesOfSeedlings->toClientList($Page) ?>,
            "GRN": <?= $Page->GRN->toClientList($Page) ?>,
            "SeedType": <?= $Page->SeedType->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm_seed_allocate">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "farm") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="farm">
<input type="hidden" name="fk_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->getSessionValue()) ?>">
<input type="hidden" name="fk_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->getSessionValue()) ?>">
<input type="hidden" name="fk_CampCode" value="<?= HtmlEncode($Page->CampCode->getSessionValue()) ?>">
<input type="hidden" name="fk_VillageCode" value="<?= HtmlEncode($Page->VillageCode->getSessionValue()) ?>">
<input type="hidden" name="fk_FarmNo" value="<?= HtmlEncode($Page->FarmNo->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_ProvinceCode" for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceCode->caption() ?><?= $Page->ProvinceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x_ProvinceCode" name="x_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_seed_allocate_ProvinceCode">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocateedit_x_ProvinceCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <?= $Page->ProvinceCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocateedit", function() {
    var options = { name: "x_ProvinceCode", selectId: "ffarm_seed_allocateedit_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocateedit.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ffarm_seed_allocateedit" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ffarm_seed_allocateedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_DistrictCode" for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictCode->caption() ?><?= $Page->DistrictCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x_DistrictCode" name="x_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_seed_allocate_DistrictCode">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocateedit_x_DistrictCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <?= $Page->DistrictCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocateedit", function() {
    var options = { name: "x_DistrictCode", selectId: "ffarm_seed_allocateedit_x_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocateedit.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ffarm_seed_allocateedit" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ffarm_seed_allocateedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode"<?= $Page->CampCode->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_CampCode" for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CampCode->caption() ?><?= $Page->CampCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x_CampCode" name="x_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_seed_allocate_CampCode">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocateedit_x_CampCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <?= $Page->CampCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocateedit", function() {
    var options = { name: "x_CampCode", selectId: "ffarm_seed_allocateedit_x_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocateedit.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ffarm_seed_allocateedit" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ffarm_seed_allocateedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode"<?= $Page->VillageCode->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_VillageCode" for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->VillageCode->caption() ?><?= $Page->VillageCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x_VillageCode" name="x_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_seed_allocate_VillageCode">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-select ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        <?php if (!$Page->VillageCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocateedit_x_VillageCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_VillageCode"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <?= $Page->VillageCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<?php if (!$Page->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocateedit", function() {
    var options = { name: "x_VillageCode", selectId: "ffarm_seed_allocateedit_x_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocateedit.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ffarm_seed_allocateedit" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ffarm_seed_allocateedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC"<?= $Page->NRC->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_NRC" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NRC->caption() ?><?= $Page->NRC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NRC->cellAttributes() ?>>
<span id="el_farm_seed_allocate_NRC">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x_NRC" id="sv_x_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?> aria-describedby="x_NRC_help">
</span>
<selection-list hidden class="form-control" data-table="farm_seed_allocate" data-field="x_NRC" data-input="sv_x_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x_NRC" id="x_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>"></selection-list>
<?= $Page->NRC->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("ffarm_seed_allocateedit", function() {
    ffarm_seed_allocateedit.createAutoSuggest(Object.assign({"id":"x_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm_seed_allocate.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
    <div id="r_FarmerNo"<?= $Page->FarmerNo->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_FarmerNo" for="x_FarmerNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmerNo->caption() ?><?= $Page->FarmerNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmerNo->cellAttributes() ?>>
<span id="el_farm_seed_allocate_FarmerNo">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x_FarmerNo" id="x_FarmerNo" data-table="farm_seed_allocate" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?> aria-describedby="x_FarmerNo_help">
<?= $Page->FarmerNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
    <div id="r_FarmNo"<?= $Page->FarmNo->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_FarmNo" for="x_FarmNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmNo->caption() ?><?= $Page->FarmNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmNo->cellAttributes() ?>>
<?php if ($Page->FarmNo->getSessionValue() != "") { ?>
<span<?= $Page->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->FarmNo->getDisplayValue($Page->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x_FarmNo" name="x_FarmNo" value="<?= HtmlEncode($Page->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_seed_allocate_FarmNo">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x_FarmNo" id="x_FarmNo" data-table="farm_seed_allocate" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?> aria-describedby="x_FarmNo_help">
<?= $Page->FarmNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
    <div id="r_FarmingSeason"<?= $Page->FarmingSeason->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_FarmingSeason" for="x_FarmingSeason" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmingSeason->caption() ?><?= $Page->FarmingSeason->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmingSeason->cellAttributes() ?>>
<span id="el_farm_seed_allocate_FarmingSeason">
    <select
        id="x_FarmingSeason"
        name="x_FarmingSeason"
        class="form-select ew-select<?= $Page->FarmingSeason->isInvalidClass() ?>"
        <?php if (!$Page->FarmingSeason->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocateedit_x_FarmingSeason"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_FarmingSeason"
        data-value-separator="<?= $Page->FarmingSeason->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>"
        <?= $Page->FarmingSeason->editAttributes() ?>>
        <?= $Page->FarmingSeason->selectOptionListHtml("x_FarmingSeason") ?>
    </select>
    <?= $Page->FarmingSeason->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage() ?></div>
<?= $Page->FarmingSeason->Lookup->getParamTag($Page, "p_x_FarmingSeason") ?>
<?php if (!$Page->FarmingSeason->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocateedit", function() {
    var options = { name: "x_FarmingSeason", selectId: "ffarm_seed_allocateedit_x_FarmingSeason" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocateedit.lists.FarmingSeason?.lookupOptions.length) {
        options.data = { id: "x_FarmingSeason", form: "ffarm_seed_allocateedit" };
    } else {
        options.ajax = { id: "x_FarmingSeason", form: "ffarm_seed_allocateedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.FarmingSeason.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->TransNo->Visible) { // TransNo ?>
    <div id="r_TransNo"<?= $Page->TransNo->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_TransNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->TransNo->caption() ?><?= $Page->TransNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->TransNo->cellAttributes() ?>>
<span id="el_farm_seed_allocate_TransNo">
<span<?= $Page->TransNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->TransNo->getDisplayValue($Page->TransNo->EditValue))) ?>"></span>
<input type="hidden" data-table="farm_seed_allocate" data-field="x_TransNo" data-hidden="1" name="x_TransNo" id="x_TransNo" value="<?= HtmlEncode($Page->TransNo->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
    <div id="r_SourcesOfSeedlings"<?= $Page->SourcesOfSeedlings->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_SourcesOfSeedlings" for="x_SourcesOfSeedlings" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SourcesOfSeedlings->caption() ?><?= $Page->SourcesOfSeedlings->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SourcesOfSeedlings->cellAttributes() ?>>
<span id="el_farm_seed_allocate_SourcesOfSeedlings">
    <select
        id="x_SourcesOfSeedlings"
        name="x_SourcesOfSeedlings"
        class="form-select ew-select<?= $Page->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocateedit_x_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Page->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SourcesOfSeedlings->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Page->SourcesOfSeedlings->selectOptionListHtml("x_SourcesOfSeedlings") ?>
    </select>
    <?= $Page->SourcesOfSeedlings->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->SourcesOfSeedlings->getErrorMessage() ?></div>
<?= $Page->SourcesOfSeedlings->Lookup->getParamTag($Page, "p_x_SourcesOfSeedlings") ?>
<?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocateedit", function() {
    var options = { name: "x_SourcesOfSeedlings", selectId: "ffarm_seed_allocateedit_x_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocateedit.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x_SourcesOfSeedlings", form: "ffarm_seed_allocateedit" };
    } else {
        options.ajax = { id: "x_SourcesOfSeedlings", form: "ffarm_seed_allocateedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
    <div id="r_GRN"<?= $Page->GRN->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_GRN" for="x_GRN" class="<?= $Page->LeftColumnClass ?>"><?= $Page->GRN->caption() ?><?= $Page->GRN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->GRN->cellAttributes() ?>>
<span id="el_farm_seed_allocate_GRN">
    <select
        id="x_GRN"
        name="x_GRN"
        class="form-control ew-select<?= $Page->GRN->isInvalidClass() ?>"
        data-select2-id="ffarm_seed_allocateedit_x_GRN"
        data-table="farm_seed_allocate"
        data-field="x_GRN"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->GRN->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->GRN->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>"
        <?= $Page->GRN->editAttributes() ?>>
        <?= $Page->GRN->selectOptionListHtml("x_GRN") ?>
    </select>
    <?= $Page->GRN->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->GRN->getErrorMessage() ?></div>
<?= $Page->GRN->Lookup->getParamTag($Page, "p_x_GRN") ?>
<script>
loadjs.ready("ffarm_seed_allocateedit", function() {
    var options = { name: "x_GRN", selectId: "ffarm_seed_allocateedit_x_GRN" };
    if (ffarm_seed_allocateedit.lists.GRN?.lookupOptions.length) {
        options.data = { id: "x_GRN", form: "ffarm_seed_allocateedit" };
    } else {
        options.ajax = { id: "x_GRN", form: "ffarm_seed_allocateedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm_seed_allocate.fields.GRN.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->TreesAllocated->Visible) { // TreesAllocated ?>
    <div id="r_TreesAllocated"<?= $Page->TreesAllocated->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_TreesAllocated" for="x_TreesAllocated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->TreesAllocated->caption() ?><?= $Page->TreesAllocated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->TreesAllocated->cellAttributes() ?>>
<span id="el_farm_seed_allocate_TreesAllocated">
<input type="<?= $Page->TreesAllocated->getInputTextType() ?>" name="x_TreesAllocated" id="x_TreesAllocated" data-table="farm_seed_allocate" data-field="x_TreesAllocated" value="<?= $Page->TreesAllocated->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->TreesAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesAllocated->formatPattern()) ?>"<?= $Page->TreesAllocated->editAttributes() ?> aria-describedby="x_TreesAllocated_help">
<?= $Page->TreesAllocated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->TreesAllocated->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
    <div id="r_SeedType"<?= $Page->SeedType->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_SeedType" for="x_SeedType" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SeedType->caption() ?><?= $Page->SeedType->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SeedType->cellAttributes() ?>>
<span id="el_farm_seed_allocate_SeedType">
    <select
        id="x_SeedType"
        name="x_SeedType"
        class="form-select ew-select<?= $Page->SeedType->isInvalidClass() ?>"
        <?php if (!$Page->SeedType->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocateedit_x_SeedType"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SeedType"
        data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
        <?= $Page->SeedType->editAttributes() ?>>
        <?= $Page->SeedType->selectOptionListHtml("x_SeedType") ?>
    </select>
    <?= $Page->SeedType->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage() ?></div>
<?= $Page->SeedType->Lookup->getParamTag($Page, "p_x_SeedType") ?>
<?php if (!$Page->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocateedit", function() {
    var options = { name: "x_SeedType", selectId: "ffarm_seed_allocateedit_x_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocateedit.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x_SeedType", form: "ffarm_seed_allocateedit" };
    } else {
        options.ajax = { id: "x_SeedType", form: "ffarm_seed_allocateedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->TransDate->Visible) { // TransDate ?>
    <div id="r_TransDate"<?= $Page->TransDate->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_TransDate" for="x_TransDate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->TransDate->caption() ?><?= $Page->TransDate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->TransDate->cellAttributes() ?>>
<span id="el_farm_seed_allocate_TransDate">
<input type="<?= $Page->TransDate->getInputTextType() ?>" name="x_TransDate" id="x_TransDate" data-table="farm_seed_allocate" data-field="x_TransDate" value="<?= $Page->TransDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->TransDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TransDate->formatPattern()) ?>"<?= $Page->TransDate->editAttributes() ?> aria-describedby="x_TransDate_help">
<?= $Page->TransDate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->TransDate->getErrorMessage() ?></div>
<?php if (!$Page->TransDate->ReadOnly && !$Page->TransDate->Disabled && !isset($Page->TransDate->EditAttrs["readonly"]) && !isset($Page->TransDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffarm_seed_allocateedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffarm_seed_allocateedit", "x_TransDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PreparedBy->Visible) { // PreparedBy ?>
    <div id="r_PreparedBy"<?= $Page->PreparedBy->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_PreparedBy" for="x_PreparedBy" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PreparedBy->caption() ?><?= $Page->PreparedBy->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PreparedBy->cellAttributes() ?>>
<span id="el_farm_seed_allocate_PreparedBy">
<input type="<?= $Page->PreparedBy->getInputTextType() ?>" name="x_PreparedBy" id="x_PreparedBy" data-table="farm_seed_allocate" data-field="x_PreparedBy" value="<?= $Page->PreparedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PreparedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PreparedBy->formatPattern()) ?>"<?= $Page->PreparedBy->editAttributes() ?> aria-describedby="x_PreparedBy_help">
<?= $Page->PreparedBy->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PreparedBy->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->AuthorisedBy->Visible) { // AuthorisedBy ?>
    <div id="r_AuthorisedBy"<?= $Page->AuthorisedBy->rowAttributes() ?>>
        <label id="elh_farm_seed_allocate_AuthorisedBy" for="x_AuthorisedBy" class="<?= $Page->LeftColumnClass ?>"><?= $Page->AuthorisedBy->caption() ?><?= $Page->AuthorisedBy->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->AuthorisedBy->cellAttributes() ?>>
<span id="el_farm_seed_allocate_AuthorisedBy">
<input type="<?= $Page->AuthorisedBy->getInputTextType() ?>" name="x_AuthorisedBy" id="x_AuthorisedBy" data-table="farm_seed_allocate" data-field="x_AuthorisedBy" value="<?= $Page->AuthorisedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->AuthorisedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AuthorisedBy->formatPattern()) ?>"<?= $Page->AuthorisedBy->editAttributes() ?> aria-describedby="x_AuthorisedBy_help">
<?= $Page->AuthorisedBy->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->AuthorisedBy->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffarm_seed_allocateedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffarm_seed_allocateedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm_seed_allocate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
