<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmInspectionList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_inspection: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerNo", [fields.FarmerNo.visible && fields.FarmerNo.required ? ew.Validators.required(fields.FarmerNo.caption) : null, ew.Validators.integer], fields.FarmerNo.isInvalid],
            ["FarmNo", [fields.FarmNo.visible && fields.FarmNo.required ? ew.Validators.required(fields.FarmNo.caption) : null, ew.Validators.integer], fields.FarmNo.isInvalid],
            ["InspectionTransNo", [fields.InspectionTransNo.visible && fields.InspectionTransNo.required ? ew.Validators.required(fields.InspectionTransNo.caption) : null], fields.InspectionTransNo.isInvalid],
            ["PlantsDead", [fields.PlantsDead.visible && fields.PlantsDead.required ? ew.Validators.required(fields.PlantsDead.caption) : null, ew.Validators.integer], fields.PlantsDead.isInvalid],
            ["PlantsVerifiedNo", [fields.PlantsVerifiedNo.visible && fields.PlantsVerifiedNo.required ? ew.Validators.required(fields.PlantsVerifiedNo.caption) : null, ew.Validators.integer], fields.PlantsVerifiedNo.isInvalid],
            ["PlantsReplaced", [fields.PlantsReplaced.visible && fields.PlantsReplaced.required ? ew.Validators.required(fields.PlantsReplaced.caption) : null, ew.Validators.integer], fields.PlantsReplaced.isInvalid],
            ["FungicidesReceived", [fields.FungicidesReceived.visible && fields.FungicidesReceived.required ? ew.Validators.required(fields.FungicidesReceived.caption) : null, ew.Validators.float], fields.FungicidesReceived.isInvalid],
            ["PescticidesReceived", [fields.PescticidesReceived.visible && fields.PescticidesReceived.required ? ew.Validators.required(fields.PescticidesReceived.caption) : null, ew.Validators.float], fields.PescticidesReceived.isInvalid],
            ["DiseasePresence", [fields.DiseasePresence.visible && fields.DiseasePresence.required ? ew.Validators.required(fields.DiseasePresence.caption) : null], fields.DiseasePresence.isInvalid],
            ["AvailableLand", [fields.AvailableLand.visible && fields.AvailableLand.required ? ew.Validators.required(fields.AvailableLand.caption) : null, ew.Validators.float], fields.AvailableLand.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false],["NRC",false],["FarmerNo",false],["FarmNo",false],["PlantsDead",false],["PlantsVerifiedNo",false],["PlantsReplaced",false],["FungicidesReceived",false],["PescticidesReceived",false],["DiseasePresence[]",false],["AvailableLand",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "DiseasePresence": <?= $Page->DiseasePresence->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "farm") {
    if ($Page->MasterRecordExists) {
        include_once "views/FarmMaster.php";
    }
}
?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ffarm_inspectionsrch" id="ffarm_inspectionsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="ffarm_inspectionsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_inspection: currentTable } });
var currentForm;
var ffarm_inspectionsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarm_inspectionsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ffarm_inspectionsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ffarm_inspectionsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ffarm_inspectionsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ffarm_inspectionsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm_inspection">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "farm" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="farm">
<input type="hidden" name="fk_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->getSessionValue()) ?>">
<input type="hidden" name="fk_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->getSessionValue()) ?>">
<input type="hidden" name="fk_CampCode" value="<?= HtmlEncode($Page->CampCode->getSessionValue()) ?>">
<input type="hidden" name="fk_VillageCode" value="<?= HtmlEncode($Page->VillageCode->getSessionValue()) ?>">
<input type="hidden" name="fk_NRC" value="<?= HtmlEncode($Page->NRC->getSessionValue()) ?>">
<input type="hidden" name="fk_FarmNo" value="<?= HtmlEncode($Page->FarmNo->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_farm_inspection" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_farm_inspectionlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Page->ProvinceCode->headerCellClass() ?>"><div id="elh_farm_inspection_ProvinceCode" class="farm_inspection_ProvinceCode"><?= $Page->renderFieldHeader($Page->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Page->DistrictCode->headerCellClass() ?>"><div id="elh_farm_inspection_DistrictCode" class="farm_inspection_DistrictCode"><?= $Page->renderFieldHeader($Page->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Page->CampCode->headerCellClass() ?>"><div id="elh_farm_inspection_CampCode" class="farm_inspection_CampCode"><?= $Page->renderFieldHeader($Page->CampCode) ?></div></th>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Page->VillageCode->headerCellClass() ?>"><div id="elh_farm_inspection_VillageCode" class="farm_inspection_VillageCode"><?= $Page->renderFieldHeader($Page->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_farm_inspection_NRC" class="farm_inspection_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <th data-name="FarmerNo" class="<?= $Page->FarmerNo->headerCellClass() ?>"><div id="elh_farm_inspection_FarmerNo" class="farm_inspection_FarmerNo"><?= $Page->renderFieldHeader($Page->FarmerNo) ?></div></th>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <th data-name="FarmNo" class="<?= $Page->FarmNo->headerCellClass() ?>"><div id="elh_farm_inspection_FarmNo" class="farm_inspection_FarmNo"><?= $Page->renderFieldHeader($Page->FarmNo) ?></div></th>
<?php } ?>
<?php if ($Page->InspectionTransNo->Visible) { // InspectionTransNo ?>
        <th data-name="InspectionTransNo" class="<?= $Page->InspectionTransNo->headerCellClass() ?>"><div id="elh_farm_inspection_InspectionTransNo" class="farm_inspection_InspectionTransNo"><?= $Page->renderFieldHeader($Page->InspectionTransNo) ?></div></th>
<?php } ?>
<?php if ($Page->PlantsDead->Visible) { // PlantsDead ?>
        <th data-name="PlantsDead" class="<?= $Page->PlantsDead->headerCellClass() ?>"><div id="elh_farm_inspection_PlantsDead" class="farm_inspection_PlantsDead"><?= $Page->renderFieldHeader($Page->PlantsDead) ?></div></th>
<?php } ?>
<?php if ($Page->PlantsVerifiedNo->Visible) { // PlantsVerifiedNo ?>
        <th data-name="PlantsVerifiedNo" class="<?= $Page->PlantsVerifiedNo->headerCellClass() ?>"><div id="elh_farm_inspection_PlantsVerifiedNo" class="farm_inspection_PlantsVerifiedNo"><?= $Page->renderFieldHeader($Page->PlantsVerifiedNo) ?></div></th>
<?php } ?>
<?php if ($Page->PlantsReplaced->Visible) { // PlantsReplaced ?>
        <th data-name="PlantsReplaced" class="<?= $Page->PlantsReplaced->headerCellClass() ?>"><div id="elh_farm_inspection_PlantsReplaced" class="farm_inspection_PlantsReplaced"><?= $Page->renderFieldHeader($Page->PlantsReplaced) ?></div></th>
<?php } ?>
<?php if ($Page->FungicidesReceived->Visible) { // FungicidesReceived ?>
        <th data-name="FungicidesReceived" class="<?= $Page->FungicidesReceived->headerCellClass() ?>"><div id="elh_farm_inspection_FungicidesReceived" class="farm_inspection_FungicidesReceived"><?= $Page->renderFieldHeader($Page->FungicidesReceived) ?></div></th>
<?php } ?>
<?php if ($Page->PescticidesReceived->Visible) { // PescticidesReceived ?>
        <th data-name="PescticidesReceived" class="<?= $Page->PescticidesReceived->headerCellClass() ?>"><div id="elh_farm_inspection_PescticidesReceived" class="farm_inspection_PescticidesReceived"><?= $Page->renderFieldHeader($Page->PescticidesReceived) ?></div></th>
<?php } ?>
<?php if ($Page->DiseasePresence->Visible) { // DiseasePresence ?>
        <th data-name="DiseasePresence" class="<?= $Page->DiseasePresence->headerCellClass() ?>"><div id="elh_farm_inspection_DiseasePresence" class="farm_inspection_DiseasePresence"><?= $Page->renderFieldHeader($Page->DiseasePresence) ?></div></th>
<?php } ?>
<?php if ($Page->AvailableLand->Visible) { // AvailableLand ?>
        <th data-name="AvailableLand" class="<?= $Page->AvailableLand->headerCellClass() ?>"><div id="elh_farm_inspection_AvailableLand" class="farm_inspection_AvailableLand"><?= $Page->renderFieldHeader($Page->AvailableLand) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_ProvinceCode" name="x<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_ProvinceCode" class="el_farm_inspection_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ProvinceCode" id="o<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_ProvinceCode" name="x<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_ProvinceCode" class="el_farm_inspection_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_ProvinceCode" class="el_farm_inspection_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_DistrictCode" name="x<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_DistrictCode" class="el_farm_inspection_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DistrictCode" id="o<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_DistrictCode" name="x<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_DistrictCode" class="el_farm_inspection_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_DistrictCode" class="el_farm_inspection_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_CampCode" name="x<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_CampCode" class="el_farm_inspection_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_CampCode" id="o<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_CampCode" name="x<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_CampCode" class="el_farm_inspection_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_CampCode" class="el_farm_inspection_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_VillageCode" name="x<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_VillageCode" class="el_farm_inspection_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-select ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        <?php if (!$Page->VillageCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_VillageCode"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<?php if (!$Page->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_VillageCode" id="o<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_VillageCode" name="x<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_VillageCode" class="el_farm_inspection_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-select ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        <?php if (!$Page->VillageCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_VillageCode"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<?php if (!$Page->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_VillageCode" class="el_farm_inspection_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->NRC->getSessionValue() != "") { ?>
<span<?= $Page->NRC->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->NRC->getDisplayValue($Page->NRC->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_NRC" name="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_NRC" class="el_farm_inspection_NRC">
    <select
        id="x<?= $Page->RowIndex ?>_NRC"
        name="x<?= $Page->RowIndex ?>_NRC"
        class="form-select ew-select<?= $Page->NRC->isInvalidClass() ?>"
        <?php if (!$Page->NRC->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_NRC"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_NRC"
        data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->NRC->editAttributes() ?>>
        <?= $Page->NRC->selectOptionListHtml("x{$Page->RowIndex}_NRC") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
<?php if (!$Page->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_NRC", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_NRC", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_NRC", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_NRC" id="o<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->NRC->getSessionValue() != "") { ?>
<span<?= $Page->NRC->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->NRC->getDisplayValue($Page->NRC->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_NRC" name="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_NRC" class="el_farm_inspection_NRC">
    <select
        id="x<?= $Page->RowIndex ?>_NRC"
        name="x<?= $Page->RowIndex ?>_NRC"
        class="form-select ew-select<?= $Page->NRC->isInvalidClass() ?>"
        <?php if (!$Page->NRC->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_NRC"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_NRC"
        data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->NRC->editAttributes() ?>>
        <?= $Page->NRC->selectOptionListHtml("x{$Page->RowIndex}_NRC") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
<?php if (!$Page->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_NRC", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_NRC", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_NRC", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_NRC" class="el_farm_inspection_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo"<?= $Page->FarmerNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_FarmerNo" class="el_farm_inspection_FarmerNo">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmerNo" id="x<?= $Page->RowIndex ?>_FarmerNo" data-table="farm_inspection" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_FarmerNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmerNo" id="o<?= $Page->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Page->FarmerNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_FarmerNo" class="el_farm_inspection_FarmerNo">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmerNo" id="x<?= $Page->RowIndex ?>_FarmerNo" data-table="farm_inspection" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_FarmerNo" class="el_farm_inspection_FarmerNo">
<span<?= $Page->FarmerNo->viewAttributes() ?>>
<?= $Page->FarmerNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->FarmNo->getSessionValue() != "") { ?>
<span<?= $Page->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->FarmNo->getDisplayValue($Page->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_FarmNo" name="x<?= $Page->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Page->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_FarmNo" class="el_farm_inspection_FarmNo">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmNo" id="x<?= $Page->RowIndex ?>_FarmNo" data-table="farm_inspection" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_FarmNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmNo" id="o<?= $Page->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Page->FarmNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->FarmNo->getSessionValue() != "") { ?>
<span<?= $Page->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->FarmNo->getDisplayValue($Page->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_FarmNo" name="x<?= $Page->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Page->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_FarmNo" class="el_farm_inspection_FarmNo">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmNo" id="x<?= $Page->RowIndex ?>_FarmNo" data-table="farm_inspection" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_FarmNo" class="el_farm_inspection_FarmNo">
<span<?= $Page->FarmNo->viewAttributes() ?>>
<?= $Page->FarmNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->InspectionTransNo->Visible) { // InspectionTransNo ?>
        <td data-name="InspectionTransNo"<?= $Page->InspectionTransNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_InspectionTransNo" class="el_farm_inspection_InspectionTransNo"></span>
<input type="hidden" data-table="farm_inspection" data-field="x_InspectionTransNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_InspectionTransNo" id="o<?= $Page->RowIndex ?>_InspectionTransNo" value="<?= HtmlEncode($Page->InspectionTransNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_InspectionTransNo" class="el_farm_inspection_InspectionTransNo">
<span<?= $Page->InspectionTransNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->InspectionTransNo->getDisplayValue($Page->InspectionTransNo->EditValue))) ?>"></span>
<input type="hidden" data-table="farm_inspection" data-field="x_InspectionTransNo" data-hidden="1" name="x<?= $Page->RowIndex ?>_InspectionTransNo" id="x<?= $Page->RowIndex ?>_InspectionTransNo" value="<?= HtmlEncode($Page->InspectionTransNo->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_InspectionTransNo" class="el_farm_inspection_InspectionTransNo">
<span<?= $Page->InspectionTransNo->viewAttributes() ?>>
<?= $Page->InspectionTransNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="farm_inspection" data-field="x_InspectionTransNo" data-hidden="1" name="x<?= $Page->RowIndex ?>_InspectionTransNo" id="x<?= $Page->RowIndex ?>_InspectionTransNo" value="<?= HtmlEncode($Page->InspectionTransNo->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->PlantsDead->Visible) { // PlantsDead ?>
        <td data-name="PlantsDead"<?= $Page->PlantsDead->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PlantsDead" class="el_farm_inspection_PlantsDead">
<input type="<?= $Page->PlantsDead->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PlantsDead" id="x<?= $Page->RowIndex ?>_PlantsDead" data-table="farm_inspection" data-field="x_PlantsDead" value="<?= $Page->PlantsDead->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsDead->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsDead->formatPattern()) ?>"<?= $Page->PlantsDead->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlantsDead->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsDead" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_PlantsDead" id="o<?= $Page->RowIndex ?>_PlantsDead" value="<?= HtmlEncode($Page->PlantsDead->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PlantsDead" class="el_farm_inspection_PlantsDead">
<input type="<?= $Page->PlantsDead->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PlantsDead" id="x<?= $Page->RowIndex ?>_PlantsDead" data-table="farm_inspection" data-field="x_PlantsDead" value="<?= $Page->PlantsDead->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsDead->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsDead->formatPattern()) ?>"<?= $Page->PlantsDead->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlantsDead->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PlantsDead" class="el_farm_inspection_PlantsDead">
<span<?= $Page->PlantsDead->viewAttributes() ?>>
<?= $Page->PlantsDead->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->PlantsVerifiedNo->Visible) { // PlantsVerifiedNo ?>
        <td data-name="PlantsVerifiedNo"<?= $Page->PlantsVerifiedNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PlantsVerifiedNo" class="el_farm_inspection_PlantsVerifiedNo">
<input type="<?= $Page->PlantsVerifiedNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PlantsVerifiedNo" id="x<?= $Page->RowIndex ?>_PlantsVerifiedNo" data-table="farm_inspection" data-field="x_PlantsVerifiedNo" value="<?= $Page->PlantsVerifiedNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsVerifiedNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsVerifiedNo->formatPattern()) ?>"<?= $Page->PlantsVerifiedNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlantsVerifiedNo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsVerifiedNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_PlantsVerifiedNo" id="o<?= $Page->RowIndex ?>_PlantsVerifiedNo" value="<?= HtmlEncode($Page->PlantsVerifiedNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PlantsVerifiedNo" class="el_farm_inspection_PlantsVerifiedNo">
<input type="<?= $Page->PlantsVerifiedNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PlantsVerifiedNo" id="x<?= $Page->RowIndex ?>_PlantsVerifiedNo" data-table="farm_inspection" data-field="x_PlantsVerifiedNo" value="<?= $Page->PlantsVerifiedNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsVerifiedNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsVerifiedNo->formatPattern()) ?>"<?= $Page->PlantsVerifiedNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlantsVerifiedNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PlantsVerifiedNo" class="el_farm_inspection_PlantsVerifiedNo">
<span<?= $Page->PlantsVerifiedNo->viewAttributes() ?>>
<?= $Page->PlantsVerifiedNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->PlantsReplaced->Visible) { // PlantsReplaced ?>
        <td data-name="PlantsReplaced"<?= $Page->PlantsReplaced->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PlantsReplaced" class="el_farm_inspection_PlantsReplaced">
<input type="<?= $Page->PlantsReplaced->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PlantsReplaced" id="x<?= $Page->RowIndex ?>_PlantsReplaced" data-table="farm_inspection" data-field="x_PlantsReplaced" value="<?= $Page->PlantsReplaced->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsReplaced->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsReplaced->formatPattern()) ?>"<?= $Page->PlantsReplaced->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlantsReplaced->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsReplaced" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_PlantsReplaced" id="o<?= $Page->RowIndex ?>_PlantsReplaced" value="<?= HtmlEncode($Page->PlantsReplaced->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PlantsReplaced" class="el_farm_inspection_PlantsReplaced">
<input type="<?= $Page->PlantsReplaced->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PlantsReplaced" id="x<?= $Page->RowIndex ?>_PlantsReplaced" data-table="farm_inspection" data-field="x_PlantsReplaced" value="<?= $Page->PlantsReplaced->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsReplaced->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsReplaced->formatPattern()) ?>"<?= $Page->PlantsReplaced->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlantsReplaced->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PlantsReplaced" class="el_farm_inspection_PlantsReplaced">
<span<?= $Page->PlantsReplaced->viewAttributes() ?>>
<?= $Page->PlantsReplaced->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FungicidesReceived->Visible) { // FungicidesReceived ?>
        <td data-name="FungicidesReceived"<?= $Page->FungicidesReceived->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_FungicidesReceived" class="el_farm_inspection_FungicidesReceived">
<input type="<?= $Page->FungicidesReceived->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FungicidesReceived" id="x<?= $Page->RowIndex ?>_FungicidesReceived" data-table="farm_inspection" data-field="x_FungicidesReceived" value="<?= $Page->FungicidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FungicidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FungicidesReceived->formatPattern()) ?>"<?= $Page->FungicidesReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FungicidesReceived->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_FungicidesReceived" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FungicidesReceived" id="o<?= $Page->RowIndex ?>_FungicidesReceived" value="<?= HtmlEncode($Page->FungicidesReceived->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_FungicidesReceived" class="el_farm_inspection_FungicidesReceived">
<input type="<?= $Page->FungicidesReceived->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FungicidesReceived" id="x<?= $Page->RowIndex ?>_FungicidesReceived" data-table="farm_inspection" data-field="x_FungicidesReceived" value="<?= $Page->FungicidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FungicidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FungicidesReceived->formatPattern()) ?>"<?= $Page->FungicidesReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FungicidesReceived->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_FungicidesReceived" class="el_farm_inspection_FungicidesReceived">
<span<?= $Page->FungicidesReceived->viewAttributes() ?>>
<?= $Page->FungicidesReceived->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->PescticidesReceived->Visible) { // PescticidesReceived ?>
        <td data-name="PescticidesReceived"<?= $Page->PescticidesReceived->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PescticidesReceived" class="el_farm_inspection_PescticidesReceived">
<input type="<?= $Page->PescticidesReceived->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PescticidesReceived" id="x<?= $Page->RowIndex ?>_PescticidesReceived" data-table="farm_inspection" data-field="x_PescticidesReceived" value="<?= $Page->PescticidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PescticidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PescticidesReceived->formatPattern()) ?>"<?= $Page->PescticidesReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PescticidesReceived->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_PescticidesReceived" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_PescticidesReceived" id="o<?= $Page->RowIndex ?>_PescticidesReceived" value="<?= HtmlEncode($Page->PescticidesReceived->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PescticidesReceived" class="el_farm_inspection_PescticidesReceived">
<input type="<?= $Page->PescticidesReceived->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PescticidesReceived" id="x<?= $Page->RowIndex ?>_PescticidesReceived" data-table="farm_inspection" data-field="x_PescticidesReceived" value="<?= $Page->PescticidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PescticidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PescticidesReceived->formatPattern()) ?>"<?= $Page->PescticidesReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PescticidesReceived->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_PescticidesReceived" class="el_farm_inspection_PescticidesReceived">
<span<?= $Page->PescticidesReceived->viewAttributes() ?>>
<?= $Page->PescticidesReceived->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DiseasePresence->Visible) { // DiseasePresence ?>
        <td data-name="DiseasePresence"<?= $Page->DiseasePresence->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_DiseasePresence" class="el_farm_inspection_DiseasePresence">
<template id="tp_x<?= $Page->RowIndex ?>_DiseasePresence">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="farm_inspection" data-field="x_DiseasePresence" name="x<?= $Page->RowIndex ?>_DiseasePresence" id="x<?= $Page->RowIndex ?>_DiseasePresence"<?= $Page->DiseasePresence->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Page->RowIndex ?>_DiseasePresence" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Page->RowIndex ?>_DiseasePresence[]"
    name="x<?= $Page->RowIndex ?>_DiseasePresence[]"
    value="<?= HtmlEncode($Page->DiseasePresence->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x<?= $Page->RowIndex ?>_DiseasePresence"
    data-target="dsl_x<?= $Page->RowIndex ?>_DiseasePresence"
    data-repeatcolumn="5"
    class="form-control<?= $Page->DiseasePresence->isInvalidClass() ?>"
    data-table="farm_inspection"
    data-field="x_DiseasePresence"
    data-value-separator="<?= $Page->DiseasePresence->displayValueSeparatorAttribute() ?>"
    <?= $Page->DiseasePresence->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->DiseasePresence->getErrorMessage() ?></div>
<?= $Page->DiseasePresence->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DiseasePresence") ?>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_DiseasePresence" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DiseasePresence[]" id="o<?= $Page->RowIndex ?>_DiseasePresence[]" value="<?= HtmlEncode($Page->DiseasePresence->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_DiseasePresence" class="el_farm_inspection_DiseasePresence">
<template id="tp_x<?= $Page->RowIndex ?>_DiseasePresence">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="farm_inspection" data-field="x_DiseasePresence" name="x<?= $Page->RowIndex ?>_DiseasePresence" id="x<?= $Page->RowIndex ?>_DiseasePresence"<?= $Page->DiseasePresence->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Page->RowIndex ?>_DiseasePresence" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Page->RowIndex ?>_DiseasePresence[]"
    name="x<?= $Page->RowIndex ?>_DiseasePresence[]"
    value="<?= HtmlEncode($Page->DiseasePresence->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x<?= $Page->RowIndex ?>_DiseasePresence"
    data-target="dsl_x<?= $Page->RowIndex ?>_DiseasePresence"
    data-repeatcolumn="5"
    class="form-control<?= $Page->DiseasePresence->isInvalidClass() ?>"
    data-table="farm_inspection"
    data-field="x_DiseasePresence"
    data-value-separator="<?= $Page->DiseasePresence->displayValueSeparatorAttribute() ?>"
    <?= $Page->DiseasePresence->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->DiseasePresence->getErrorMessage() ?></div>
<?= $Page->DiseasePresence->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DiseasePresence") ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_DiseasePresence" class="el_farm_inspection_DiseasePresence">
<span<?= $Page->DiseasePresence->viewAttributes() ?>>
<?= $Page->DiseasePresence->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->AvailableLand->Visible) { // AvailableLand ?>
        <td data-name="AvailableLand"<?= $Page->AvailableLand->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_AvailableLand" class="el_farm_inspection_AvailableLand">
<input type="<?= $Page->AvailableLand->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_AvailableLand" id="x<?= $Page->RowIndex ?>_AvailableLand" data-table="farm_inspection" data-field="x_AvailableLand" value="<?= $Page->AvailableLand->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AvailableLand->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AvailableLand->formatPattern()) ?>"<?= $Page->AvailableLand->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AvailableLand->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_AvailableLand" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_AvailableLand" id="o<?= $Page->RowIndex ?>_AvailableLand" value="<?= HtmlEncode($Page->AvailableLand->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_AvailableLand" class="el_farm_inspection_AvailableLand">
<input type="<?= $Page->AvailableLand->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_AvailableLand" id="x<?= $Page->RowIndex ?>_AvailableLand" data-table="farm_inspection" data-field="x_AvailableLand" value="<?= $Page->AvailableLand->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AvailableLand->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AvailableLand->formatPattern()) ?>"<?= $Page->AvailableLand->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AvailableLand->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_inspection_AvailableLand" class="el_farm_inspection_AvailableLand">
<span<?= $Page->AvailableLand->viewAttributes() ?>>
<?= $Page->AvailableLand->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm_inspection");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
