<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("FarmGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var ffarmgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { farm: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffarmgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FieldType", [fields.FieldType.visible && fields.FieldType.required ? ew.Validators.required(fields.FieldType.caption) : null], fields.FieldType.isInvalid],
            ["Ownership", [fields.Ownership.visible && fields.Ownership.required ? ew.Validators.required(fields.Ownership.caption) : null], fields.Ownership.isInvalid],
            ["SeedlingsAllocated", [fields.SeedlingsAllocated.visible && fields.SeedlingsAllocated.required ? ew.Validators.required(fields.SeedlingsAllocated.caption) : null], fields.SeedlingsAllocated.isInvalid],
            ["TreesPlantedEstimated", [fields.TreesPlantedEstimated.visible && fields.TreesPlantedEstimated.required ? ew.Validators.required(fields.TreesPlantedEstimated.caption) : null, ew.Validators.float], fields.TreesPlantedEstimated.isInvalid],
            ["TreesPlantedVerified", [fields.TreesPlantedVerified.visible && fields.TreesPlantedVerified.required ? ew.Validators.required(fields.TreesPlantedVerified.caption) : null, ew.Validators.float], fields.TreesPlantedVerified.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false],["NRC",false],["FieldType",false],["Ownership",false],["SeedlingsAllocated",false],["TreesPlantedEstimated",false],["TreesPlantedVerified",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Grid->ProvinceCode->toClientList($Grid) ?>,
            "DistrictCode": <?= $Grid->DistrictCode->toClientList($Grid) ?>,
            "CampCode": <?= $Grid->CampCode->toClientList($Grid) ?>,
            "VillageCode": <?= $Grid->VillageCode->toClientList($Grid) ?>,
            "NRC": <?= $Grid->NRC->toClientList($Grid) ?>,
            "FieldType": <?= $Grid->FieldType->toClientList($Grid) ?>,
            "Ownership": <?= $Grid->Ownership->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="ffarmgrid" class="ew-form ew-list-form">
<div id="gmp_farm" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_farmgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Grid->ProvinceCode->headerCellClass() ?>"><div id="elh_farm_ProvinceCode" class="farm_ProvinceCode"><?= $Grid->renderFieldHeader($Grid->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Grid->DistrictCode->headerCellClass() ?>"><div id="elh_farm_DistrictCode" class="farm_DistrictCode"><?= $Grid->renderFieldHeader($Grid->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Grid->CampCode->headerCellClass() ?>"><div id="elh_farm_CampCode" class="farm_CampCode"><?= $Grid->renderFieldHeader($Grid->CampCode) ?></div></th>
<?php } ?>
<?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Grid->VillageCode->headerCellClass() ?>"><div id="elh_farm_VillageCode" class="farm_VillageCode"><?= $Grid->renderFieldHeader($Grid->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Grid->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Grid->NRC->headerCellClass() ?>"><div id="elh_farm_NRC" class="farm_NRC"><?= $Grid->renderFieldHeader($Grid->NRC) ?></div></th>
<?php } ?>
<?php if ($Grid->FieldType->Visible) { // FieldType ?>
        <th data-name="FieldType" class="<?= $Grid->FieldType->headerCellClass() ?>"><div id="elh_farm_FieldType" class="farm_FieldType"><?= $Grid->renderFieldHeader($Grid->FieldType) ?></div></th>
<?php } ?>
<?php if ($Grid->Ownership->Visible) { // Ownership ?>
        <th data-name="Ownership" class="<?= $Grid->Ownership->headerCellClass() ?>"><div id="elh_farm_Ownership" class="farm_Ownership"><?= $Grid->renderFieldHeader($Grid->Ownership) ?></div></th>
<?php } ?>
<?php if ($Grid->SeedlingsAllocated->Visible) { // SeedlingsAllocated ?>
        <th data-name="SeedlingsAllocated" class="<?= $Grid->SeedlingsAllocated->headerCellClass() ?>"><div id="elh_farm_SeedlingsAllocated" class="farm_SeedlingsAllocated"><?= $Grid->renderFieldHeader($Grid->SeedlingsAllocated) ?></div></th>
<?php } ?>
<?php if ($Grid->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
        <th data-name="TreesPlantedEstimated" class="<?= $Grid->TreesPlantedEstimated->headerCellClass() ?>"><div id="elh_farm_TreesPlantedEstimated" class="farm_TreesPlantedEstimated"><?= $Grid->renderFieldHeader($Grid->TreesPlantedEstimated) ?></div></th>
<?php } ?>
<?php if ($Grid->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
        <th data-name="TreesPlantedVerified" class="<?= $Grid->TreesPlantedVerified->headerCellClass() ?>"><div id="elh_farm_TreesPlantedVerified" class="farm_TreesPlantedVerified"><?= $Grid->renderFieldHeader($Grid->TreesPlantedVerified) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Grid->ProvinceCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_ProvinceCode" class="el_farm_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmgrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProvinceCode" id="o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_ProvinceCode" class="el_farm_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmgrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_ProvinceCode" class="el_farm_ProvinceCode">
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<?= $Grid->ProvinceCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm" data-field="x_ProvinceCode" data-hidden="1" name="ffarmgrid$x<?= $Grid->RowIndex ?>_ProvinceCode" id="ffarmgrid$x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->FormValue) ?>">
<input type="hidden" data-table="farm" data-field="x_ProvinceCode" data-hidden="1" data-old name="ffarmgrid$o<?= $Grid->RowIndex ?>_ProvinceCode" id="ffarmgrid$o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Grid->DistrictCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_DistrictCode" class="el_farm_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        data-table="farm"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_DistrictCode" };
    if (ffarmgrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="farm" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DistrictCode" id="o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_DistrictCode" class="el_farm_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        data-table="farm"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_DistrictCode" };
    if (ffarmgrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_DistrictCode" class="el_farm_DistrictCode">
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<?= $Grid->DistrictCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm" data-field="x_DistrictCode" data-hidden="1" name="ffarmgrid$x<?= $Grid->RowIndex ?>_DistrictCode" id="ffarmgrid$x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->FormValue) ?>">
<input type="hidden" data-table="farm" data-field="x_DistrictCode" data-hidden="1" data-old name="ffarmgrid$o<?= $Grid->RowIndex ?>_DistrictCode" id="ffarmgrid$o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Grid->CampCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->CampCode->getSessionValue() != "") { ?>
<span<?= $Grid->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->CampCode->getDisplayValue($Grid->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_CampCode" name="x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_CampCode" class="el_farm_CampCode">
    <select
        id="x<?= $Grid->RowIndex ?>_CampCode"
        name="x<?= $Grid->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Grid->CampCode->isInvalidClass() ?>"
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_CampCode"
        data-table="farm"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->CampCode->editAttributes() ?>>
        <?= $Grid->CampCode->selectOptionListHtml("x{$Grid->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->CampCode->getErrorMessage() ?></div>
<?= $Grid->CampCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_CampCode", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_CampCode" };
    if (ffarmgrid.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="farm" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_CampCode" id="o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->CampCode->getSessionValue() != "") { ?>
<span<?= $Grid->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->CampCode->getDisplayValue($Grid->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_CampCode" name="x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_CampCode" class="el_farm_CampCode">
    <select
        id="x<?= $Grid->RowIndex ?>_CampCode"
        name="x<?= $Grid->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Grid->CampCode->isInvalidClass() ?>"
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_CampCode"
        data-table="farm"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->CampCode->editAttributes() ?>>
        <?= $Grid->CampCode->selectOptionListHtml("x{$Grid->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->CampCode->getErrorMessage() ?></div>
<?= $Grid->CampCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_CampCode", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_CampCode" };
    if (ffarmgrid.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_CampCode" class="el_farm_CampCode">
<span<?= $Grid->CampCode->viewAttributes() ?>>
<?= $Grid->CampCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm" data-field="x_CampCode" data-hidden="1" name="ffarmgrid$x<?= $Grid->RowIndex ?>_CampCode" id="ffarmgrid$x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->FormValue) ?>">
<input type="hidden" data-table="farm" data-field="x_CampCode" data-hidden="1" data-old name="ffarmgrid$o<?= $Grid->RowIndex ?>_CampCode" id="ffarmgrid$o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Grid->VillageCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->VillageCode->getSessionValue() != "") { ?>
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->VillageCode->getDisplayValue($Grid->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_VillageCode" name="x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_VillageCode" class="el_farm_VillageCode">
    <select
        id="x<?= $Grid->RowIndex ?>_VillageCode"
        name="x<?= $Grid->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Grid->VillageCode->isInvalidClass() ?>"
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_VillageCode"
        data-table="farm"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->VillageCode->getPlaceHolder()) ?>"
        <?= $Grid->VillageCode->editAttributes() ?>>
        <?= $Grid->VillageCode->selectOptionListHtml("x{$Grid->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->VillageCode->getErrorMessage() ?></div>
<?= $Grid->VillageCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_VillageCode", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_VillageCode" };
    if (ffarmgrid.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="farm" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_VillageCode" id="o<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->VillageCode->getSessionValue() != "") { ?>
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->VillageCode->getDisplayValue($Grid->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_VillageCode" name="x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_VillageCode" class="el_farm_VillageCode">
    <select
        id="x<?= $Grid->RowIndex ?>_VillageCode"
        name="x<?= $Grid->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Grid->VillageCode->isInvalidClass() ?>"
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_VillageCode"
        data-table="farm"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->VillageCode->getPlaceHolder()) ?>"
        <?= $Grid->VillageCode->editAttributes() ?>>
        <?= $Grid->VillageCode->selectOptionListHtml("x{$Grid->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->VillageCode->getErrorMessage() ?></div>
<?= $Grid->VillageCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_VillageCode", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_VillageCode" };
    if (ffarmgrid.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_VillageCode" class="el_farm_VillageCode">
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<?= $Grid->VillageCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm" data-field="x_VillageCode" data-hidden="1" name="ffarmgrid$x<?= $Grid->RowIndex ?>_VillageCode" id="ffarmgrid$x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->FormValue) ?>">
<input type="hidden" data-table="farm" data-field="x_VillageCode" data-hidden="1" data-old name="ffarmgrid$o<?= $Grid->RowIndex ?>_VillageCode" id="ffarmgrid$o<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Grid->NRC->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->NRC->getSessionValue() != "") { ?>
<span<?= $Grid->NRC->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->NRC->getDisplayValue($Grid->NRC->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_NRC" name="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_NRC" class="el_farm_NRC">
<?php
if (IsRTL()) {
    $Grid->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Grid->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_NRC" id="sv_x<?= $Grid->RowIndex ?>_NRC" value="<?= RemoveHtml($Grid->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NRC->formatPattern()) ?>"<?= $Grid->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm" data-field="x_NRC" data-input="sv_x<?= $Grid->RowIndex ?>_NRC" data-value-separator="<?= $Grid->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("ffarmgrid", function() {
    ffarmgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Grid->NRC->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NRC") ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NRC" id="o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->NRC->getSessionValue() != "") { ?>
<span<?= $Grid->NRC->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->NRC->getDisplayValue($Grid->NRC->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_NRC" name="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_NRC" class="el_farm_NRC">
<?php
if (IsRTL()) {
    $Grid->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Grid->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_NRC" id="sv_x<?= $Grid->RowIndex ?>_NRC" value="<?= RemoveHtml($Grid->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NRC->formatPattern()) ?>"<?= $Grid->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm" data-field="x_NRC" data-input="sv_x<?= $Grid->RowIndex ?>_NRC" data-value-separator="<?= $Grid->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("ffarmgrid", function() {
    ffarmgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Grid->NRC->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NRC") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_NRC" class="el_farm_NRC">
<span<?= $Grid->NRC->viewAttributes() ?>>
<?= $Grid->NRC->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm" data-field="x_NRC" data-hidden="1" name="ffarmgrid$x<?= $Grid->RowIndex ?>_NRC" id="ffarmgrid$x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->FormValue) ?>">
<input type="hidden" data-table="farm" data-field="x_NRC" data-hidden="1" data-old name="ffarmgrid$o<?= $Grid->RowIndex ?>_NRC" id="ffarmgrid$o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FieldType->Visible) { // FieldType ?>
        <td data-name="FieldType"<?= $Grid->FieldType->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_FieldType" class="el_farm_FieldType">
    <select
        id="x<?= $Grid->RowIndex ?>_FieldType"
        name="x<?= $Grid->RowIndex ?>_FieldType"
        class="form-select ew-select<?= $Grid->FieldType->isInvalidClass() ?>"
        <?php if (!$Grid->FieldType->IsNativeSelect) { ?>
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_FieldType"
        <?php } ?>
        data-table="farm"
        data-field="x_FieldType"
        data-value-separator="<?= $Grid->FieldType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->FieldType->getPlaceHolder()) ?>"
        <?= $Grid->FieldType->editAttributes() ?>>
        <?= $Grid->FieldType->selectOptionListHtml("x{$Grid->RowIndex}_FieldType") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->FieldType->getErrorMessage() ?></div>
<?= $Grid->FieldType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FieldType") ?>
<?php if (!$Grid->FieldType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_FieldType", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_FieldType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmgrid.lists.FieldType?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_FieldType", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_FieldType", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.FieldType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm" data-field="x_FieldType" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FieldType" id="o<?= $Grid->RowIndex ?>_FieldType" value="<?= HtmlEncode($Grid->FieldType->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_FieldType" class="el_farm_FieldType">
    <select
        id="x<?= $Grid->RowIndex ?>_FieldType"
        name="x<?= $Grid->RowIndex ?>_FieldType"
        class="form-select ew-select<?= $Grid->FieldType->isInvalidClass() ?>"
        <?php if (!$Grid->FieldType->IsNativeSelect) { ?>
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_FieldType"
        <?php } ?>
        data-table="farm"
        data-field="x_FieldType"
        data-value-separator="<?= $Grid->FieldType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->FieldType->getPlaceHolder()) ?>"
        <?= $Grid->FieldType->editAttributes() ?>>
        <?= $Grid->FieldType->selectOptionListHtml("x{$Grid->RowIndex}_FieldType") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->FieldType->getErrorMessage() ?></div>
<?= $Grid->FieldType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FieldType") ?>
<?php if (!$Grid->FieldType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_FieldType", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_FieldType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmgrid.lists.FieldType?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_FieldType", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_FieldType", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.FieldType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_FieldType" class="el_farm_FieldType">
<span<?= $Grid->FieldType->viewAttributes() ?>>
<?= $Grid->FieldType->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm" data-field="x_FieldType" data-hidden="1" name="ffarmgrid$x<?= $Grid->RowIndex ?>_FieldType" id="ffarmgrid$x<?= $Grid->RowIndex ?>_FieldType" value="<?= HtmlEncode($Grid->FieldType->FormValue) ?>">
<input type="hidden" data-table="farm" data-field="x_FieldType" data-hidden="1" data-old name="ffarmgrid$o<?= $Grid->RowIndex ?>_FieldType" id="ffarmgrid$o<?= $Grid->RowIndex ?>_FieldType" value="<?= HtmlEncode($Grid->FieldType->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Ownership->Visible) { // Ownership ?>
        <td data-name="Ownership"<?= $Grid->Ownership->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_Ownership" class="el_farm_Ownership">
    <select
        id="x<?= $Grid->RowIndex ?>_Ownership"
        name="x<?= $Grid->RowIndex ?>_Ownership"
        class="form-select ew-select<?= $Grid->Ownership->isInvalidClass() ?>"
        <?php if (!$Grid->Ownership->IsNativeSelect) { ?>
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_Ownership"
        <?php } ?>
        data-table="farm"
        data-field="x_Ownership"
        data-value-separator="<?= $Grid->Ownership->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Ownership->getPlaceHolder()) ?>"
        <?= $Grid->Ownership->editAttributes() ?>>
        <?= $Grid->Ownership->selectOptionListHtml("x{$Grid->RowIndex}_Ownership") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->Ownership->getErrorMessage() ?></div>
<?= $Grid->Ownership->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Ownership") ?>
<?php if (!$Grid->Ownership->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Ownership", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_Ownership" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmgrid.lists.Ownership?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Ownership", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Ownership", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.Ownership.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm" data-field="x_Ownership" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Ownership" id="o<?= $Grid->RowIndex ?>_Ownership" value="<?= HtmlEncode($Grid->Ownership->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_Ownership" class="el_farm_Ownership">
    <select
        id="x<?= $Grid->RowIndex ?>_Ownership"
        name="x<?= $Grid->RowIndex ?>_Ownership"
        class="form-select ew-select<?= $Grid->Ownership->isInvalidClass() ?>"
        <?php if (!$Grid->Ownership->IsNativeSelect) { ?>
        data-select2-id="ffarmgrid_x<?= $Grid->RowIndex ?>_Ownership"
        <?php } ?>
        data-table="farm"
        data-field="x_Ownership"
        data-value-separator="<?= $Grid->Ownership->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Ownership->getPlaceHolder()) ?>"
        <?= $Grid->Ownership->editAttributes() ?>>
        <?= $Grid->Ownership->selectOptionListHtml("x{$Grid->RowIndex}_Ownership") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->Ownership->getErrorMessage() ?></div>
<?= $Grid->Ownership->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Ownership") ?>
<?php if (!$Grid->Ownership->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Ownership", selectId: "ffarmgrid_x<?= $Grid->RowIndex ?>_Ownership" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmgrid.lists.Ownership?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Ownership", form: "ffarmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Ownership", form: "ffarmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.Ownership.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_Ownership" class="el_farm_Ownership">
<span<?= $Grid->Ownership->viewAttributes() ?>>
<?= $Grid->Ownership->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm" data-field="x_Ownership" data-hidden="1" name="ffarmgrid$x<?= $Grid->RowIndex ?>_Ownership" id="ffarmgrid$x<?= $Grid->RowIndex ?>_Ownership" value="<?= HtmlEncode($Grid->Ownership->FormValue) ?>">
<input type="hidden" data-table="farm" data-field="x_Ownership" data-hidden="1" data-old name="ffarmgrid$o<?= $Grid->RowIndex ?>_Ownership" id="ffarmgrid$o<?= $Grid->RowIndex ?>_Ownership" value="<?= HtmlEncode($Grid->Ownership->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->SeedlingsAllocated->Visible) { // SeedlingsAllocated ?>
        <td data-name="SeedlingsAllocated"<?= $Grid->SeedlingsAllocated->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_SeedlingsAllocated" class="el_farm_SeedlingsAllocated">
<input type="<?= $Grid->SeedlingsAllocated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_SeedlingsAllocated" id="x<?= $Grid->RowIndex ?>_SeedlingsAllocated" data-table="farm" data-field="x_SeedlingsAllocated" value="<?= $Grid->SeedlingsAllocated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->SeedlingsAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->SeedlingsAllocated->formatPattern()) ?>"<?= $Grid->SeedlingsAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->SeedlingsAllocated->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm" data-field="x_SeedlingsAllocated" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_SeedlingsAllocated" id="o<?= $Grid->RowIndex ?>_SeedlingsAllocated" value="<?= HtmlEncode($Grid->SeedlingsAllocated->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_SeedlingsAllocated" class="el_farm_SeedlingsAllocated">
<span<?= $Grid->SeedlingsAllocated->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->SeedlingsAllocated->getDisplayValue($Grid->SeedlingsAllocated->EditValue))) ?>"></span>
<input type="hidden" data-table="farm" data-field="x_SeedlingsAllocated" data-hidden="1" name="x<?= $Grid->RowIndex ?>_SeedlingsAllocated" id="x<?= $Grid->RowIndex ?>_SeedlingsAllocated" value="<?= HtmlEncode($Grid->SeedlingsAllocated->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_SeedlingsAllocated" class="el_farm_SeedlingsAllocated">
<span<?= $Grid->SeedlingsAllocated->viewAttributes() ?>>
<?= $Grid->SeedlingsAllocated->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm" data-field="x_SeedlingsAllocated" data-hidden="1" name="ffarmgrid$x<?= $Grid->RowIndex ?>_SeedlingsAllocated" id="ffarmgrid$x<?= $Grid->RowIndex ?>_SeedlingsAllocated" value="<?= HtmlEncode($Grid->SeedlingsAllocated->FormValue) ?>">
<input type="hidden" data-table="farm" data-field="x_SeedlingsAllocated" data-hidden="1" data-old name="ffarmgrid$o<?= $Grid->RowIndex ?>_SeedlingsAllocated" id="ffarmgrid$o<?= $Grid->RowIndex ?>_SeedlingsAllocated" value="<?= HtmlEncode($Grid->SeedlingsAllocated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
        <td data-name="TreesPlantedEstimated"<?= $Grid->TreesPlantedEstimated->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_TreesPlantedEstimated" class="el_farm_TreesPlantedEstimated">
<input type="<?= $Grid->TreesPlantedEstimated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TreesPlantedEstimated" id="x<?= $Grid->RowIndex ?>_TreesPlantedEstimated" data-table="farm" data-field="x_TreesPlantedEstimated" value="<?= $Grid->TreesPlantedEstimated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->TreesPlantedEstimated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TreesPlantedEstimated->formatPattern()) ?>"<?= $Grid->TreesPlantedEstimated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TreesPlantedEstimated->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm" data-field="x_TreesPlantedEstimated" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_TreesPlantedEstimated" id="o<?= $Grid->RowIndex ?>_TreesPlantedEstimated" value="<?= HtmlEncode($Grid->TreesPlantedEstimated->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_TreesPlantedEstimated" class="el_farm_TreesPlantedEstimated">
<input type="<?= $Grid->TreesPlantedEstimated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TreesPlantedEstimated" id="x<?= $Grid->RowIndex ?>_TreesPlantedEstimated" data-table="farm" data-field="x_TreesPlantedEstimated" value="<?= $Grid->TreesPlantedEstimated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->TreesPlantedEstimated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TreesPlantedEstimated->formatPattern()) ?>"<?= $Grid->TreesPlantedEstimated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TreesPlantedEstimated->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_TreesPlantedEstimated" class="el_farm_TreesPlantedEstimated">
<span<?= $Grid->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Grid->TreesPlantedEstimated->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm" data-field="x_TreesPlantedEstimated" data-hidden="1" name="ffarmgrid$x<?= $Grid->RowIndex ?>_TreesPlantedEstimated" id="ffarmgrid$x<?= $Grid->RowIndex ?>_TreesPlantedEstimated" value="<?= HtmlEncode($Grid->TreesPlantedEstimated->FormValue) ?>">
<input type="hidden" data-table="farm" data-field="x_TreesPlantedEstimated" data-hidden="1" data-old name="ffarmgrid$o<?= $Grid->RowIndex ?>_TreesPlantedEstimated" id="ffarmgrid$o<?= $Grid->RowIndex ?>_TreesPlantedEstimated" value="<?= HtmlEncode($Grid->TreesPlantedEstimated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
        <td data-name="TreesPlantedVerified"<?= $Grid->TreesPlantedVerified->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_TreesPlantedVerified" class="el_farm_TreesPlantedVerified">
<input type="<?= $Grid->TreesPlantedVerified->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TreesPlantedVerified" id="x<?= $Grid->RowIndex ?>_TreesPlantedVerified" data-table="farm" data-field="x_TreesPlantedVerified" value="<?= $Grid->TreesPlantedVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->TreesPlantedVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TreesPlantedVerified->formatPattern()) ?>"<?= $Grid->TreesPlantedVerified->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TreesPlantedVerified->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm" data-field="x_TreesPlantedVerified" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_TreesPlantedVerified" id="o<?= $Grid->RowIndex ?>_TreesPlantedVerified" value="<?= HtmlEncode($Grid->TreesPlantedVerified->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_TreesPlantedVerified" class="el_farm_TreesPlantedVerified">
<input type="<?= $Grid->TreesPlantedVerified->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_TreesPlantedVerified" id="x<?= $Grid->RowIndex ?>_TreesPlantedVerified" data-table="farm" data-field="x_TreesPlantedVerified" value="<?= $Grid->TreesPlantedVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->TreesPlantedVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->TreesPlantedVerified->formatPattern()) ?>"<?= $Grid->TreesPlantedVerified->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->TreesPlantedVerified->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_TreesPlantedVerified" class="el_farm_TreesPlantedVerified">
<span<?= $Grid->TreesPlantedVerified->viewAttributes() ?>>
<?= $Grid->TreesPlantedVerified->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm" data-field="x_TreesPlantedVerified" data-hidden="1" name="ffarmgrid$x<?= $Grid->RowIndex ?>_TreesPlantedVerified" id="ffarmgrid$x<?= $Grid->RowIndex ?>_TreesPlantedVerified" value="<?= HtmlEncode($Grid->TreesPlantedVerified->FormValue) ?>">
<input type="hidden" data-table="farm" data-field="x_TreesPlantedVerified" data-hidden="1" data-old name="ffarmgrid$o<?= $Grid->RowIndex ?>_TreesPlantedVerified" id="ffarmgrid$o<?= $Grid->RowIndex ?>_TreesPlantedVerified" value="<?= HtmlEncode($Grid->TreesPlantedVerified->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["ffarmgrid","load"], () => ffarmgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ffarmgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
