<?php

namespace PHPMaker2024\cidp24;

// Page object
$DistrictView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
<form name="fdistrictview" id="fdistrictview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { district: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fdistrictview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fdistrictview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="district">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <tr id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_district_DistrictCode"><?= $Page->DistrictCode->caption() ?></span></td>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="el_district_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <tr id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_district_ProvinceCode"><?= $Page->ProvinceCode->caption() ?></span></td>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<span id="el_district_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
    <tr id="r_DistrictName"<?= $Page->DistrictName->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_district_DistrictName"><?= $Page->DistrictName->caption() ?></span></td>
        <td data-name="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
<span id="el_district_DistrictName">
<span<?= $Page->DistrictName->viewAttributes() ?>>
<?= $Page->DistrictName->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php
    if (in_array("camp", explode(",", $Page->getCurrentDetailTable())) && $camp->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("camp", "TblCaption") ?>&nbsp;<?= str_replace("%s", "blue", str_replace("%c", Container("camp")->Count, $Language->phrase("DetailCount"))) ?></h4>
<?php } ?>
<?php include_once "CampGrid.php" ?>
<?php } ?>
<?php
    if (in_array("nursery", explode(",", $Page->getCurrentDetailTable())) && $nursery->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("nursery", "TblCaption") ?>&nbsp;<?= str_replace("%s", "blue", str_replace("%c", Container("nursery")->Count, $Language->phrase("DetailCount"))) ?></h4>
<?php } ?>
<?php include_once "NurseryGrid.php" ?>
<?php } ?>
<?php
    if (in_array("farmer_organisation", explode(",", $Page->getCurrentDetailTable())) && $farmer_organisation->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("farmer_organisation", "TblCaption") ?>&nbsp;<?= str_replace("%s", "blue", str_replace("%c", Container("farmer_organisation")->Count, $Language->phrase("DetailCount"))) ?></h4>
<?php } ?>
<?php include_once "FarmerOrganisationGrid.php" ?>
<?php } ?>
</form>
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
