<?php

namespace PHPMaker2024\cidp24;

// Page object
$CidpDataSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cidp_data: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fcidp_datasearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcidp_datasearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["DistrictCode", [], fields.DistrictCode.isInvalid],
            ["DistrictName", [], fields.DistrictName.isInvalid],
            ["GRNCode", [], fields.GRNCode.isInvalid],
            ["GRN", [], fields.GRN.isInvalid],
            ["SupplierCode", [ew.Validators.integer], fields.SupplierCode.isInvalid],
            ["Supplier", [], fields.Supplier.isInvalid],
            ["CampCode", [], fields.CampCode.isInvalid],
            ["Camp", [], fields.Camp.isInvalid],
            ["VillageCode", [], fields.VillageCode.isInvalid],
            ["Village", [], fields.Village.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["FarmerName", [], fields.FarmerName.isInvalid],
            ["DOB", [], fields.DOB.isInvalid],
            ["Age", [ew.Validators.float], fields.Age.isInvalid],
            ["Group", [], fields.Group.isInvalid],
            ["Gender", [], fields.Gender.isInvalid],
            ["Seedlings", [ew.Validators.float], fields.Seedlings.isInvalid],
            ["Seeds", [], fields.Seeds.isInvalid],
            ["Type", [], fields.Type.isInvalid],
            ["DateAllocated", [], fields.DateAllocated.isInvalid],
            ["ID", [ew.Validators.integer], fields.ID.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "GRNCode": <?= $Page->GRNCode->toClientList($Page) ?>,
            "SupplierCode": <?= $Page->SupplierCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "Group": <?= $Page->Group->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "Type": <?= $Page->Type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcidp_datasearch" id="fcidp_datasearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="cidp_data">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode" class="row"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_DistrictCode"><?= $Page->DistrictCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_DistrictCode" id="z_DistrictCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_DistrictCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="fcidp_datasearch_x_DistrictCode"
        data-table="cidp_data"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<script>
loadjs.ready("fcidp_datasearch", function() {
    var options = { name: "x_DistrictCode", selectId: "fcidp_datasearch_x_DistrictCode" };
    if (fcidp_datasearch.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "fcidp_datasearch" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "fcidp_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
    <div id="r_DistrictName" class="row"<?= $Page->DistrictName->rowAttributes() ?>>
        <label for="x_DistrictName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_DistrictName"><?= $Page->DistrictName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_DistrictName" id="z_DistrictName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_DistrictName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DistrictName->getInputTextType() ?>" name="x_DistrictName" id="x_DistrictName" data-table="cidp_data" data-field="x_DistrictName" value="<?= $Page->DistrictName->EditValue ?>" size="30" maxlength="80" placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictName->formatPattern()) ?>"<?= $Page->DistrictName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->GRNCode->Visible) { // GRNCode ?>
    <div id="r_GRNCode" class="row"<?= $Page->GRNCode->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_GRNCode"><?= $Page->GRNCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_GRNCode" id="z_GRNCode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->GRNCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_GRNCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_GRNCode"
        name="x_GRNCode"
        class="form-control ew-select<?= $Page->GRNCode->isInvalidClass() ?>"
        data-select2-id="fcidp_datasearch_x_GRNCode"
        data-table="cidp_data"
        data-field="x_GRNCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->GRNCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->GRNCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->GRNCode->getPlaceHolder()) ?>"
        <?= $Page->GRNCode->editAttributes() ?>>
        <?= $Page->GRNCode->selectOptionListHtml("x_GRNCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->GRNCode->getErrorMessage(false) ?></div>
<?= $Page->GRNCode->Lookup->getParamTag($Page, "p_x_GRNCode") ?>
<script>
loadjs.ready("fcidp_datasearch", function() {
    var options = { name: "x_GRNCode", selectId: "fcidp_datasearch_x_GRNCode" };
    if (fcidp_datasearch.lists.GRNCode?.lookupOptions.length) {
        options.data = { id: "x_GRNCode", form: "fcidp_datasearch" };
    } else {
        options.ajax = { id: "x_GRNCode", form: "fcidp_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.GRNCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
    <div id="r_GRN" class="row"<?= $Page->GRN->rowAttributes() ?>>
        <label for="x_GRN" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_GRN"><?= $Page->GRN->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_GRN" id="z_GRN" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->GRN->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_GRN" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->GRN->getInputTextType() ?>" name="x_GRN" id="x_GRN" data-table="cidp_data" data-field="x_GRN" value="<?= $Page->GRN->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GRN->formatPattern()) ?>"<?= $Page->GRN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GRN->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SupplierCode->Visible) { // SupplierCode ?>
    <div id="r_SupplierCode" class="row"<?= $Page->SupplierCode->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_SupplierCode"><?= $Page->SupplierCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SupplierCode" id="z_SupplierCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SupplierCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_SupplierCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_SupplierCode"
        name="x_SupplierCode"
        class="form-control ew-select<?= $Page->SupplierCode->isInvalidClass() ?>"
        data-select2-id="fcidp_datasearch_x_SupplierCode"
        data-table="cidp_data"
        data-field="x_SupplierCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->SupplierCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->SupplierCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SupplierCode->getPlaceHolder()) ?>"
        <?= $Page->SupplierCode->editAttributes() ?>>
        <?= $Page->SupplierCode->selectOptionListHtml("x_SupplierCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SupplierCode->getErrorMessage(false) ?></div>
<?= $Page->SupplierCode->Lookup->getParamTag($Page, "p_x_SupplierCode") ?>
<script>
loadjs.ready("fcidp_datasearch", function() {
    var options = { name: "x_SupplierCode", selectId: "fcidp_datasearch_x_SupplierCode" };
    if (fcidp_datasearch.lists.SupplierCode?.lookupOptions.length) {
        options.data = { id: "x_SupplierCode", form: "fcidp_datasearch" };
    } else {
        options.ajax = { id: "x_SupplierCode", form: "fcidp_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.SupplierCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Supplier->Visible) { // Supplier ?>
    <div id="r_Supplier" class="row"<?= $Page->Supplier->rowAttributes() ?>>
        <label for="x_Supplier" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_Supplier"><?= $Page->Supplier->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Supplier" id="z_Supplier" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Supplier->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_Supplier" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Supplier->getInputTextType() ?>" name="x_Supplier" id="x_Supplier" data-table="cidp_data" data-field="x_Supplier" value="<?= $Page->Supplier->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Supplier->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Supplier->formatPattern()) ?>"<?= $Page->Supplier->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Supplier->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode" class="row"<?= $Page->CampCode->rowAttributes() ?>>
        <label for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_CampCode"><?= $Page->CampCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_CampCode" id="z_CampCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->CampCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_CampCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="fcidp_datasearch_x_CampCode"
        data-table="cidp_data"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage(false) ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<script>
loadjs.ready("fcidp_datasearch", function() {
    var options = { name: "x_CampCode", selectId: "fcidp_datasearch_x_CampCode" };
    if (fcidp_datasearch.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "fcidp_datasearch" };
    } else {
        options.ajax = { id: "x_CampCode", form: "fcidp_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Camp->Visible) { // Camp ?>
    <div id="r_Camp" class="row"<?= $Page->Camp->rowAttributes() ?>>
        <label for="x_Camp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_Camp"><?= $Page->Camp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Camp" id="z_Camp" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Camp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_Camp" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Camp->getInputTextType() ?>" name="x_Camp" id="x_Camp" data-table="cidp_data" data-field="x_Camp" value="<?= $Page->Camp->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Camp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Camp->formatPattern()) ?>"<?= $Page->Camp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Camp->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode" class="row"<?= $Page->VillageCode->rowAttributes() ?>>
        <label for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_VillageCode"><?= $Page->VillageCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_VillageCode" id="z_VillageCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->VillageCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_VillageCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="fcidp_datasearch_x_VillageCode"
        data-table="cidp_data"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage(false) ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<script>
loadjs.ready("fcidp_datasearch", function() {
    var options = { name: "x_VillageCode", selectId: "fcidp_datasearch_x_VillageCode" };
    if (fcidp_datasearch.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "fcidp_datasearch" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "fcidp_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
    <div id="r_Village" class="row"<?= $Page->Village->rowAttributes() ?>>
        <label for="x_Village" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_Village"><?= $Page->Village->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Village" id="z_Village" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Village->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_Village" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Village->getInputTextType() ?>" name="x_Village" id="x_Village" data-table="cidp_data" data-field="x_Village" value="<?= $Page->Village->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Village->formatPattern()) ?>"<?= $Page->Village->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Village->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC" class="row"<?= $Page->NRC->rowAttributes() ?>>
        <label for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_NRC"><?= $Page->NRC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NRC" id="z_NRC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NRC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_NRC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x_NRC" id="x_NRC" data-table="cidp_data" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
    <div id="r_FarmerName" class="row"<?= $Page->FarmerName->rowAttributes() ?>>
        <label for="x_FarmerName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_FarmerName"><?= $Page->FarmerName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_FarmerName" id="z_FarmerName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmerName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_FarmerName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmerName->getInputTextType() ?>" name="x_FarmerName" id="x_FarmerName" data-table="cidp_data" data-field="x_FarmerName" value="<?= $Page->FarmerName->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerName->formatPattern()) ?>"<?= $Page->FarmerName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
    <div id="r_DOB" class="row"<?= $Page->DOB->rowAttributes() ?>>
        <label for="x_DOB" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_DOB"><?= $Page->DOB->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_DOB" id="z_DOB" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DOB->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_DOB" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DOB->getInputTextType() ?>" name="x_DOB" id="x_DOB" data-table="cidp_data" data-field="x_DOB" value="<?= $Page->DOB->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DOB->formatPattern()) ?>"<?= $Page->DOB->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DOB->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
    <div id="r_Age" class="row"<?= $Page->Age->rowAttributes() ?>>
        <label for="x_Age" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_Age"><?= $Page->Age->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Age" id="z_Age" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Age->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_Age" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Age->getInputTextType() ?>" name="x_Age" id="x_Age" data-table="cidp_data" data-field="x_Age" value="<?= $Page->Age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Age->formatPattern()) ?>"<?= $Page->Age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Age->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Group->Visible) { // Group ?>
    <div id="r_Group" class="row"<?= $Page->Group->rowAttributes() ?>>
        <label for="x_Group" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_Group"><?= $Page->Group->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Group" id="z_Group" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Group->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_Group" class="ew-search-field ew-search-field-single">
    <select
        id="x_Group[]"
        name="x_Group[]"
        class="form-select ew-select<?= $Page->Group->isInvalidClass() ?>"
        <?php if (!$Page->Group->IsNativeSelect) { ?>
        data-select2-id="fcidp_datasearch_x_Group[]"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Group"
        multiple
        size="1"
        data-value-separator="<?= $Page->Group->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Group->getPlaceHolder()) ?>"
        <?= $Page->Group->editAttributes() ?>>
        <?= $Page->Group->selectOptionListHtml("x_Group[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Group->getErrorMessage(false) ?></div>
<?php if (!$Page->Group->IsNativeSelect) { ?>
<script>
loadjs.ready("fcidp_datasearch", function() {
    var options = { name: "x_Group[]", selectId: "fcidp_datasearch_x_Group[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcidp_datasearch.lists.Group?.lookupOptions.length) {
        options.data = { id: "x_Group[]", form: "fcidp_datasearch" };
    } else {
        options.ajax = { id: "x_Group[]", form: "fcidp_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Group.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender" class="row"<?= $Page->Gender->rowAttributes() ?>>
        <label for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_Gender"><?= $Page->Gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Gender" id="z_Gender" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_Gender" class="ew-search-field ew-search-field-single">
    <select
        id="x_Gender"
        name="x_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="fcidp_datasearch_x_Gender"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Gender"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x_Gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
<?= $Page->Gender->Lookup->getParamTag($Page, "p_x_Gender") ?>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("fcidp_datasearch", function() {
    var options = { name: "x_Gender", selectId: "fcidp_datasearch_x_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcidp_datasearch.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x_Gender", form: "fcidp_datasearch" };
    } else {
        options.ajax = { id: "x_Gender", form: "fcidp_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Seedlings->Visible) { // Seedlings ?>
    <div id="r_Seedlings" class="row"<?= $Page->Seedlings->rowAttributes() ?>>
        <label for="x_Seedlings" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_Seedlings"><?= $Page->Seedlings->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Seedlings" id="z_Seedlings" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Seedlings->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_Seedlings" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Seedlings->getInputTextType() ?>" name="x_Seedlings" id="x_Seedlings" data-table="cidp_data" data-field="x_Seedlings" value="<?= $Page->Seedlings->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Seedlings->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Seedlings->formatPattern()) ?>"<?= $Page->Seedlings->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Seedlings->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Seeds->Visible) { // Seeds ?>
    <div id="r_Seeds" class="row"<?= $Page->Seeds->rowAttributes() ?>>
        <label for="x_Seeds" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_Seeds"><?= $Page->Seeds->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Seeds" id="z_Seeds" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Seeds->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_Seeds" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Seeds->getInputTextType() ?>" name="x_Seeds" id="x_Seeds" data-table="cidp_data" data-field="x_Seeds" value="<?= $Page->Seeds->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Seeds->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Seeds->formatPattern()) ?>"<?= $Page->Seeds->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Seeds->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Type->Visible) { // Type ?>
    <div id="r_Type" class="row"<?= $Page->Type->rowAttributes() ?>>
        <label for="x_Type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_Type"><?= $Page->Type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Type" id="z_Type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_Type" class="ew-search-field ew-search-field-single">
    <select
        id="x_Type"
        name="x_Type"
        class="form-select ew-select<?= $Page->Type->isInvalidClass() ?>"
        <?php if (!$Page->Type->IsNativeSelect) { ?>
        data-select2-id="fcidp_datasearch_x_Type"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Type"
        data-value-separator="<?= $Page->Type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Type->getPlaceHolder()) ?>"
        <?= $Page->Type->editAttributes() ?>>
        <?= $Page->Type->selectOptionListHtml("x_Type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Type->getErrorMessage(false) ?></div>
<?= $Page->Type->Lookup->getParamTag($Page, "p_x_Type") ?>
<?php if (!$Page->Type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcidp_datasearch", function() {
    var options = { name: "x_Type", selectId: "fcidp_datasearch_x_Type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcidp_datasearch.lists.Type?.lookupOptions.length) {
        options.data = { id: "x_Type", form: "fcidp_datasearch" };
    } else {
        options.ajax = { id: "x_Type", form: "fcidp_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DateAllocated->Visible) { // DateAllocated ?>
    <div id="r_DateAllocated" class="row"<?= $Page->DateAllocated->rowAttributes() ?>>
        <label for="x_DateAllocated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_DateAllocated"><?= $Page->DateAllocated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_DateAllocated" id="z_DateAllocated" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DateAllocated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_DateAllocated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DateAllocated->getInputTextType() ?>" name="x_DateAllocated" id="x_DateAllocated" data-table="cidp_data" data-field="x_DateAllocated" value="<?= $Page->DateAllocated->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->DateAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateAllocated->formatPattern()) ?>"<?= $Page->DateAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DateAllocated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ID->Visible) { // ID ?>
    <div id="r_ID" class="row"<?= $Page->ID->rowAttributes() ?>>
        <label for="x_ID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cidp_data_ID"><?= $Page->ID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ID" id="z_ID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cidp_data_ID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ID->getInputTextType() ?>" name="x_ID" id="x_ID" data-table="cidp_data" data-field="x_ID" value="<?= $Page->ID->EditValue ?>" placeholder="<?= HtmlEncode($Page->ID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ID->formatPattern()) ?>"<?= $Page->ID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ID->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcidp_datasearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcidp_datasearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fcidp_datasearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("cidp_data");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
