<?php

namespace PHPMaker2024\cidp24;

// Page object
$CidpDataAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cidp_data: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fcidp_dataadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcidp_dataadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["DistrictName", [fields.DistrictName.visible && fields.DistrictName.required ? ew.Validators.required(fields.DistrictName.caption) : null], fields.DistrictName.isInvalid],
            ["GRNCode", [fields.GRNCode.visible && fields.GRNCode.required ? ew.Validators.required(fields.GRNCode.caption) : null], fields.GRNCode.isInvalid],
            ["GRN", [fields.GRN.visible && fields.GRN.required ? ew.Validators.required(fields.GRN.caption) : null], fields.GRN.isInvalid],
            ["SupplierCode", [fields.SupplierCode.visible && fields.SupplierCode.required ? ew.Validators.required(fields.SupplierCode.caption) : null, ew.Validators.integer], fields.SupplierCode.isInvalid],
            ["Supplier", [fields.Supplier.visible && fields.Supplier.required ? ew.Validators.required(fields.Supplier.caption) : null], fields.Supplier.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["Camp", [fields.Camp.visible && fields.Camp.required ? ew.Validators.required(fields.Camp.caption) : null], fields.Camp.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["Village", [fields.Village.visible && fields.Village.required ? ew.Validators.required(fields.Village.caption) : null], fields.Village.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerName", [fields.FarmerName.visible && fields.FarmerName.required ? ew.Validators.required(fields.FarmerName.caption) : null], fields.FarmerName.isInvalid],
            ["DOB", [fields.DOB.visible && fields.DOB.required ? ew.Validators.required(fields.DOB.caption) : null], fields.DOB.isInvalid],
            ["Age", [fields.Age.visible && fields.Age.required ? ew.Validators.required(fields.Age.caption) : null, ew.Validators.float], fields.Age.isInvalid],
            ["Group", [fields.Group.visible && fields.Group.required ? ew.Validators.required(fields.Group.caption) : null], fields.Group.isInvalid],
            ["Gender", [fields.Gender.visible && fields.Gender.required ? ew.Validators.required(fields.Gender.caption) : null], fields.Gender.isInvalid],
            ["Seedlings", [fields.Seedlings.visible && fields.Seedlings.required ? ew.Validators.required(fields.Seedlings.caption) : null, ew.Validators.float], fields.Seedlings.isInvalid],
            ["Seeds", [fields.Seeds.visible && fields.Seeds.required ? ew.Validators.required(fields.Seeds.caption) : null], fields.Seeds.isInvalid],
            ["Type", [fields.Type.visible && fields.Type.required ? ew.Validators.required(fields.Type.caption) : null], fields.Type.isInvalid],
            ["DateAllocated", [fields.DateAllocated.visible && fields.DateAllocated.required ? ew.Validators.required(fields.DateAllocated.caption) : null], fields.DateAllocated.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "GRNCode": <?= $Page->GRNCode->toClientList($Page) ?>,
            "SupplierCode": <?= $Page->SupplierCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "Group": <?= $Page->Group->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "Type": <?= $Page->Type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcidp_dataadd" id="fcidp_dataadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="cidp_data">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label id="elh_cidp_data_DistrictCode" for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictCode->caption() ?><?= $Page->DistrictCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="el_cidp_data_DistrictCode">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="fcidp_dataadd_x_DistrictCode"
        data-table="cidp_data"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <?= $Page->DistrictCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<script>
loadjs.ready("fcidp_dataadd", function() {
    var options = { name: "x_DistrictCode", selectId: "fcidp_dataadd_x_DistrictCode" };
    if (fcidp_dataadd.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "fcidp_dataadd" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "fcidp_dataadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
    <div id="r_DistrictName"<?= $Page->DistrictName->rowAttributes() ?>>
        <label id="elh_cidp_data_DistrictName" for="x_DistrictName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictName->caption() ?><?= $Page->DistrictName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictName->cellAttributes() ?>>
<span id="el_cidp_data_DistrictName">
<input type="<?= $Page->DistrictName->getInputTextType() ?>" name="x_DistrictName" id="x_DistrictName" data-table="cidp_data" data-field="x_DistrictName" value="<?= $Page->DistrictName->EditValue ?>" size="30" maxlength="80" placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictName->formatPattern()) ?>"<?= $Page->DistrictName->editAttributes() ?> aria-describedby="x_DistrictName_help">
<?= $Page->DistrictName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->GRNCode->Visible) { // GRNCode ?>
    <div id="r_GRNCode"<?= $Page->GRNCode->rowAttributes() ?>>
        <label id="elh_cidp_data_GRNCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->GRNCode->caption() ?><?= $Page->GRNCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->GRNCode->cellAttributes() ?>>
<span id="el_cidp_data_GRNCode">
    <select
        id="x_GRNCode"
        name="x_GRNCode"
        class="form-control ew-select<?= $Page->GRNCode->isInvalidClass() ?>"
        data-select2-id="fcidp_dataadd_x_GRNCode"
        data-table="cidp_data"
        data-field="x_GRNCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->GRNCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->GRNCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->GRNCode->getPlaceHolder()) ?>"
        <?= $Page->GRNCode->editAttributes() ?>>
        <?= $Page->GRNCode->selectOptionListHtml("x_GRNCode") ?>
    </select>
    <?= $Page->GRNCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->GRNCode->getErrorMessage() ?></div>
<?= $Page->GRNCode->Lookup->getParamTag($Page, "p_x_GRNCode") ?>
<script>
loadjs.ready("fcidp_dataadd", function() {
    var options = { name: "x_GRNCode", selectId: "fcidp_dataadd_x_GRNCode" };
    if (fcidp_dataadd.lists.GRNCode?.lookupOptions.length) {
        options.data = { id: "x_GRNCode", form: "fcidp_dataadd" };
    } else {
        options.ajax = { id: "x_GRNCode", form: "fcidp_dataadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.GRNCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
    <div id="r_GRN"<?= $Page->GRN->rowAttributes() ?>>
        <label id="elh_cidp_data_GRN" for="x_GRN" class="<?= $Page->LeftColumnClass ?>"><?= $Page->GRN->caption() ?><?= $Page->GRN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->GRN->cellAttributes() ?>>
<span id="el_cidp_data_GRN">
<input type="<?= $Page->GRN->getInputTextType() ?>" name="x_GRN" id="x_GRN" data-table="cidp_data" data-field="x_GRN" value="<?= $Page->GRN->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GRN->formatPattern()) ?>"<?= $Page->GRN->editAttributes() ?> aria-describedby="x_GRN_help">
<?= $Page->GRN->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->GRN->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SupplierCode->Visible) { // SupplierCode ?>
    <div id="r_SupplierCode"<?= $Page->SupplierCode->rowAttributes() ?>>
        <label id="elh_cidp_data_SupplierCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SupplierCode->caption() ?><?= $Page->SupplierCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SupplierCode->cellAttributes() ?>>
<span id="el_cidp_data_SupplierCode">
    <select
        id="x_SupplierCode"
        name="x_SupplierCode"
        class="form-control ew-select<?= $Page->SupplierCode->isInvalidClass() ?>"
        data-select2-id="fcidp_dataadd_x_SupplierCode"
        data-table="cidp_data"
        data-field="x_SupplierCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->SupplierCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->SupplierCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SupplierCode->getPlaceHolder()) ?>"
        <?= $Page->SupplierCode->editAttributes() ?>>
        <?= $Page->SupplierCode->selectOptionListHtml("x_SupplierCode") ?>
    </select>
    <?= $Page->SupplierCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->SupplierCode->getErrorMessage() ?></div>
<?= $Page->SupplierCode->Lookup->getParamTag($Page, "p_x_SupplierCode") ?>
<script>
loadjs.ready("fcidp_dataadd", function() {
    var options = { name: "x_SupplierCode", selectId: "fcidp_dataadd_x_SupplierCode" };
    if (fcidp_dataadd.lists.SupplierCode?.lookupOptions.length) {
        options.data = { id: "x_SupplierCode", form: "fcidp_dataadd" };
    } else {
        options.ajax = { id: "x_SupplierCode", form: "fcidp_dataadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.SupplierCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Supplier->Visible) { // Supplier ?>
    <div id="r_Supplier"<?= $Page->Supplier->rowAttributes() ?>>
        <label id="elh_cidp_data_Supplier" for="x_Supplier" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Supplier->caption() ?><?= $Page->Supplier->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Supplier->cellAttributes() ?>>
<span id="el_cidp_data_Supplier">
<input type="<?= $Page->Supplier->getInputTextType() ?>" name="x_Supplier" id="x_Supplier" data-table="cidp_data" data-field="x_Supplier" value="<?= $Page->Supplier->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Supplier->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Supplier->formatPattern()) ?>"<?= $Page->Supplier->editAttributes() ?> aria-describedby="x_Supplier_help">
<?= $Page->Supplier->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Supplier->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode"<?= $Page->CampCode->rowAttributes() ?>>
        <label id="elh_cidp_data_CampCode" for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CampCode->caption() ?><?= $Page->CampCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CampCode->cellAttributes() ?>>
<span id="el_cidp_data_CampCode">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="fcidp_dataadd_x_CampCode"
        data-table="cidp_data"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <?= $Page->CampCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<script>
loadjs.ready("fcidp_dataadd", function() {
    var options = { name: "x_CampCode", selectId: "fcidp_dataadd_x_CampCode" };
    if (fcidp_dataadd.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "fcidp_dataadd" };
    } else {
        options.ajax = { id: "x_CampCode", form: "fcidp_dataadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Camp->Visible) { // Camp ?>
    <div id="r_Camp"<?= $Page->Camp->rowAttributes() ?>>
        <label id="elh_cidp_data_Camp" for="x_Camp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Camp->caption() ?><?= $Page->Camp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Camp->cellAttributes() ?>>
<span id="el_cidp_data_Camp">
<input type="<?= $Page->Camp->getInputTextType() ?>" name="x_Camp" id="x_Camp" data-table="cidp_data" data-field="x_Camp" value="<?= $Page->Camp->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Camp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Camp->formatPattern()) ?>"<?= $Page->Camp->editAttributes() ?> aria-describedby="x_Camp_help">
<?= $Page->Camp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Camp->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode"<?= $Page->VillageCode->rowAttributes() ?>>
        <label id="elh_cidp_data_VillageCode" for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->VillageCode->caption() ?><?= $Page->VillageCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->VillageCode->cellAttributes() ?>>
<span id="el_cidp_data_VillageCode">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="fcidp_dataadd_x_VillageCode"
        data-table="cidp_data"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <?= $Page->VillageCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<script>
loadjs.ready("fcidp_dataadd", function() {
    var options = { name: "x_VillageCode", selectId: "fcidp_dataadd_x_VillageCode" };
    if (fcidp_dataadd.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "fcidp_dataadd" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "fcidp_dataadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
    <div id="r_Village"<?= $Page->Village->rowAttributes() ?>>
        <label id="elh_cidp_data_Village" for="x_Village" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Village->caption() ?><?= $Page->Village->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Village->cellAttributes() ?>>
<span id="el_cidp_data_Village">
<input type="<?= $Page->Village->getInputTextType() ?>" name="x_Village" id="x_Village" data-table="cidp_data" data-field="x_Village" value="<?= $Page->Village->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Village->formatPattern()) ?>"<?= $Page->Village->editAttributes() ?> aria-describedby="x_Village_help">
<?= $Page->Village->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Village->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC"<?= $Page->NRC->rowAttributes() ?>>
        <label id="elh_cidp_data_NRC" for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NRC->caption() ?><?= $Page->NRC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NRC->cellAttributes() ?>>
<span id="el_cidp_data_NRC">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x_NRC" id="x_NRC" data-table="cidp_data" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?> aria-describedby="x_NRC_help">
<?= $Page->NRC->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
    <div id="r_FarmerName"<?= $Page->FarmerName->rowAttributes() ?>>
        <label id="elh_cidp_data_FarmerName" for="x_FarmerName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmerName->caption() ?><?= $Page->FarmerName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmerName->cellAttributes() ?>>
<span id="el_cidp_data_FarmerName">
<input type="<?= $Page->FarmerName->getInputTextType() ?>" name="x_FarmerName" id="x_FarmerName" data-table="cidp_data" data-field="x_FarmerName" value="<?= $Page->FarmerName->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerName->formatPattern()) ?>"<?= $Page->FarmerName->editAttributes() ?> aria-describedby="x_FarmerName_help">
<?= $Page->FarmerName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
    <div id="r_DOB"<?= $Page->DOB->rowAttributes() ?>>
        <label id="elh_cidp_data_DOB" for="x_DOB" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DOB->caption() ?><?= $Page->DOB->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DOB->cellAttributes() ?>>
<span id="el_cidp_data_DOB">
<input type="<?= $Page->DOB->getInputTextType() ?>" name="x_DOB" id="x_DOB" data-table="cidp_data" data-field="x_DOB" value="<?= $Page->DOB->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DOB->formatPattern()) ?>"<?= $Page->DOB->editAttributes() ?> aria-describedby="x_DOB_help">
<?= $Page->DOB->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DOB->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
    <div id="r_Age"<?= $Page->Age->rowAttributes() ?>>
        <label id="elh_cidp_data_Age" for="x_Age" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Age->caption() ?><?= $Page->Age->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Age->cellAttributes() ?>>
<span id="el_cidp_data_Age">
<input type="<?= $Page->Age->getInputTextType() ?>" name="x_Age" id="x_Age" data-table="cidp_data" data-field="x_Age" value="<?= $Page->Age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Age->formatPattern()) ?>"<?= $Page->Age->editAttributes() ?> aria-describedby="x_Age_help">
<?= $Page->Age->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Age->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Group->Visible) { // Group ?>
    <div id="r_Group"<?= $Page->Group->rowAttributes() ?>>
        <label id="elh_cidp_data_Group" for="x_Group" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Group->caption() ?><?= $Page->Group->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Group->cellAttributes() ?>>
<span id="el_cidp_data_Group">
    <select
        id="x_Group[]"
        name="x_Group[]"
        class="form-select ew-select<?= $Page->Group->isInvalidClass() ?>"
        <?php if (!$Page->Group->IsNativeSelect) { ?>
        data-select2-id="fcidp_dataadd_x_Group[]"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Group"
        multiple
        size="1"
        data-value-separator="<?= $Page->Group->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Group->getPlaceHolder()) ?>"
        <?= $Page->Group->editAttributes() ?>>
        <?= $Page->Group->selectOptionListHtml("x_Group[]") ?>
    </select>
    <?= $Page->Group->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Group->getErrorMessage() ?></div>
<?php if (!$Page->Group->IsNativeSelect) { ?>
<script>
loadjs.ready("fcidp_dataadd", function() {
    var options = { name: "x_Group[]", selectId: "fcidp_dataadd_x_Group[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcidp_dataadd.lists.Group?.lookupOptions.length) {
        options.data = { id: "x_Group[]", form: "fcidp_dataadd" };
    } else {
        options.ajax = { id: "x_Group[]", form: "fcidp_dataadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Group.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender"<?= $Page->Gender->rowAttributes() ?>>
        <label id="elh_cidp_data_Gender" for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Gender->caption() ?><?= $Page->Gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Gender->cellAttributes() ?>>
<span id="el_cidp_data_Gender">
    <select
        id="x_Gender"
        name="x_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="fcidp_dataadd_x_Gender"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Gender"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x_Gender") ?>
    </select>
    <?= $Page->Gender->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
<?= $Page->Gender->Lookup->getParamTag($Page, "p_x_Gender") ?>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("fcidp_dataadd", function() {
    var options = { name: "x_Gender", selectId: "fcidp_dataadd_x_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcidp_dataadd.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x_Gender", form: "fcidp_dataadd" };
    } else {
        options.ajax = { id: "x_Gender", form: "fcidp_dataadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Seedlings->Visible) { // Seedlings ?>
    <div id="r_Seedlings"<?= $Page->Seedlings->rowAttributes() ?>>
        <label id="elh_cidp_data_Seedlings" for="x_Seedlings" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Seedlings->caption() ?><?= $Page->Seedlings->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Seedlings->cellAttributes() ?>>
<span id="el_cidp_data_Seedlings">
<input type="<?= $Page->Seedlings->getInputTextType() ?>" name="x_Seedlings" id="x_Seedlings" data-table="cidp_data" data-field="x_Seedlings" value="<?= $Page->Seedlings->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Seedlings->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Seedlings->formatPattern()) ?>"<?= $Page->Seedlings->editAttributes() ?> aria-describedby="x_Seedlings_help">
<?= $Page->Seedlings->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Seedlings->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Seeds->Visible) { // Seeds ?>
    <div id="r_Seeds"<?= $Page->Seeds->rowAttributes() ?>>
        <label id="elh_cidp_data_Seeds" for="x_Seeds" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Seeds->caption() ?><?= $Page->Seeds->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Seeds->cellAttributes() ?>>
<span id="el_cidp_data_Seeds">
<input type="<?= $Page->Seeds->getInputTextType() ?>" name="x_Seeds" id="x_Seeds" data-table="cidp_data" data-field="x_Seeds" value="<?= $Page->Seeds->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Seeds->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Seeds->formatPattern()) ?>"<?= $Page->Seeds->editAttributes() ?> aria-describedby="x_Seeds_help">
<?= $Page->Seeds->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Seeds->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Type->Visible) { // Type ?>
    <div id="r_Type"<?= $Page->Type->rowAttributes() ?>>
        <label id="elh_cidp_data_Type" for="x_Type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Type->caption() ?><?= $Page->Type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Type->cellAttributes() ?>>
<span id="el_cidp_data_Type">
    <select
        id="x_Type"
        name="x_Type"
        class="form-select ew-select<?= $Page->Type->isInvalidClass() ?>"
        <?php if (!$Page->Type->IsNativeSelect) { ?>
        data-select2-id="fcidp_dataadd_x_Type"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Type"
        data-value-separator="<?= $Page->Type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Type->getPlaceHolder()) ?>"
        <?= $Page->Type->editAttributes() ?>>
        <?= $Page->Type->selectOptionListHtml("x_Type") ?>
    </select>
    <?= $Page->Type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Type->getErrorMessage() ?></div>
<?= $Page->Type->Lookup->getParamTag($Page, "p_x_Type") ?>
<?php if (!$Page->Type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcidp_dataadd", function() {
    var options = { name: "x_Type", selectId: "fcidp_dataadd_x_Type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcidp_dataadd.lists.Type?.lookupOptions.length) {
        options.data = { id: "x_Type", form: "fcidp_dataadd" };
    } else {
        options.ajax = { id: "x_Type", form: "fcidp_dataadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DateAllocated->Visible) { // DateAllocated ?>
    <div id="r_DateAllocated"<?= $Page->DateAllocated->rowAttributes() ?>>
        <label id="elh_cidp_data_DateAllocated" for="x_DateAllocated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DateAllocated->caption() ?><?= $Page->DateAllocated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DateAllocated->cellAttributes() ?>>
<span id="el_cidp_data_DateAllocated">
<input type="<?= $Page->DateAllocated->getInputTextType() ?>" name="x_DateAllocated" id="x_DateAllocated" data-table="cidp_data" data-field="x_DateAllocated" value="<?= $Page->DateAllocated->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->DateAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateAllocated->formatPattern()) ?>"<?= $Page->DateAllocated->editAttributes() ?> aria-describedby="x_DateAllocated_help">
<?= $Page->DateAllocated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DateAllocated->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcidp_dataadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcidp_dataadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("cidp_data");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
