<?php

namespace PHPMaker2024\cidp24;

// Page object
$BeneficiaryBySupplierReportSummary = &$Page;
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { Beneficiary_by_Supplier_Report: currentTable } });
var currentPageID = ew.PAGE_ID = "summary";
var currentForm;
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<a id="top"></a>
<!-- Content Container -->
<div id="ew-report" class="ew-report container-fluid">
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<div class="btn-toolbar ew-toolbar">
<?php
if (!$Page->DrillDownInPanel) {
    $Page->ExportOptions->render("body");
    $Page->SearchOptions->render("body");
    $Page->FilterOptions->render("body");
}
?>
</div>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<form name="fBeneficiary_by_Supplier_Reportsrch" id="fBeneficiary_by_Supplier_Reportsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fBeneficiary_by_Supplier_Reportsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { Beneficiary_by_Supplier_Report: currentTable } });
var currentPageID = ew.PAGE_ID = "summary";
var currentForm;
var fBeneficiary_by_Supplier_Reportsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fBeneficiary_by_Supplier_Reportsrch")
        .setPageId("summary")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "DistrictName": <?= $Page->DistrictName->toClientList($Page) ?>,
            "GRN": <?= $Page->GRN->toClientList($Page) ?>,
            "SeedType": <?= $Page->SeedType->toClientList($Page) ?>,
            "NurseryName": <?= $Page->NurseryName->toClientList($Page) ?>,
            "Age": <?= $Page->Age->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
<?php
if (!$Page->DistrictName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictName"
            name="x_DistrictName[]"
            class="form-control ew-select<?= $Page->DistrictName->isInvalidClass() ?>"
            data-select2-id="fBeneficiary_by_Supplier_Reportsrch_x_DistrictName"
            data-table="Beneficiary_by_Supplier_Report"
            data-field="x_DistrictName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictName->editAttributes() ?>>
            <?= $Page->DistrictName->selectOptionListHtml("x_DistrictName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fBeneficiary_by_Supplier_Reportsrch", function() {
            var options = {
                name: "x_DistrictName",
                selectId: "fBeneficiary_by_Supplier_Reportsrch_x_DistrictName",
                ajax: { id: "x_DistrictName", form: "fBeneficiary_by_Supplier_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Beneficiary_by_Supplier_Report.fields.DistrictName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
<?php
if (!$Page->GRN->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_GRN" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->GRN->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_GRN"
            name="x_GRN[]"
            class="form-control ew-select<?= $Page->GRN->isInvalidClass() ?>"
            data-select2-id="fBeneficiary_by_Supplier_Reportsrch_x_GRN"
            data-table="Beneficiary_by_Supplier_Report"
            data-field="x_GRN"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->GRN->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->GRN->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->GRN->editAttributes() ?>>
            <?= $Page->GRN->selectOptionListHtml("x_GRN", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->GRN->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fBeneficiary_by_Supplier_Reportsrch", function() {
            var options = {
                name: "x_GRN",
                selectId: "fBeneficiary_by_Supplier_Reportsrch_x_GRN",
                ajax: { id: "x_GRN", form: "fBeneficiary_by_Supplier_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Beneficiary_by_Supplier_Report.fields.GRN.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
<?php
if (!$Page->SeedType->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_SeedType" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->SeedType->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_SeedType"
            name="x_SeedType[]"
            class="form-control ew-select<?= $Page->SeedType->isInvalidClass() ?>"
            data-select2-id="fBeneficiary_by_Supplier_Reportsrch_x_SeedType"
            data-table="Beneficiary_by_Supplier_Report"
            data-field="x_SeedType"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->SeedType->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->SeedType->editAttributes() ?>>
            <?= $Page->SeedType->selectOptionListHtml("x_SeedType", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fBeneficiary_by_Supplier_Reportsrch", function() {
            var options = {
                name: "x_SeedType",
                selectId: "fBeneficiary_by_Supplier_Reportsrch_x_SeedType",
                ajax: { id: "x_SeedType", form: "fBeneficiary_by_Supplier_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Beneficiary_by_Supplier_Report.fields.SeedType.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->NurseryName->Visible) { // NurseryName ?>
<?php
if (!$Page->NurseryName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_NurseryName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->NurseryName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_NurseryName"
            name="x_NurseryName[]"
            class="form-control ew-select<?= $Page->NurseryName->isInvalidClass() ?>"
            data-select2-id="fBeneficiary_by_Supplier_Reportsrch_x_NurseryName"
            data-table="Beneficiary_by_Supplier_Report"
            data-field="x_NurseryName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->NurseryName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->NurseryName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->NurseryName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->NurseryName->editAttributes() ?>>
            <?= $Page->NurseryName->selectOptionListHtml("x_NurseryName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->NurseryName->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fBeneficiary_by_Supplier_Reportsrch", function() {
            var options = {
                name: "x_NurseryName",
                selectId: "fBeneficiary_by_Supplier_Reportsrch_x_NurseryName",
                ajax: { id: "x_NurseryName", form: "fBeneficiary_by_Supplier_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Beneficiary_by_Supplier_Report.fields.NurseryName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
<?php
if (!$Page->Age->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Age" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Age->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Age"
            name="x_Age[]"
            class="form-control ew-select<?= $Page->Age->isInvalidClass() ?>"
            data-select2-id="fBeneficiary_by_Supplier_Reportsrch_x_Age"
            data-table="Beneficiary_by_Supplier_Report"
            data-field="x_Age"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Age->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Age->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Age->editAttributes() ?>>
            <?= $Page->Age->selectOptionListHtml("x_Age", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Age->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fBeneficiary_by_Supplier_Reportsrch", function() {
            var options = {
                name: "x_Age",
                selectId: "fBeneficiary_by_Supplier_Reportsrch_x_Age",
                ajax: { id: "x_Age", form: "fBeneficiary_by_Supplier_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Beneficiary_by_Supplier_Report.fields.Age.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
<?php
if (!$Page->Gender->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Gender" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Gender->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Gender"
            name="x_Gender[]"
            class="form-control ew-select<?= $Page->Gender->isInvalidClass() ?>"
            data-select2-id="fBeneficiary_by_Supplier_Reportsrch_x_Gender"
            data-table="Beneficiary_by_Supplier_Report"
            data-field="x_Gender"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Gender->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Gender->editAttributes() ?>>
            <?= $Page->Gender->selectOptionListHtml("x_Gender", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fBeneficiary_by_Supplier_Reportsrch", function() {
            var options = {
                name: "x_Gender",
                selectId: "fBeneficiary_by_Supplier_Reportsrch_x_Gender",
                ajax: { id: "x_Gender", form: "fBeneficiary_by_Supplier_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Beneficiary_by_Supplier_Report.fields.Gender.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<?php if ($Page->ShowReport) { ?>
<!-- Summary report (begin) -->
<main class="report-summary<?= ($Page->TotalGroups == 0) ? " ew-no-record" : "" ?>">
<?php
while ($Page->GroupCount <= count($Page->GroupRecords) && $Page->GroupCount <= $Page->DisplayGroups) {
?>
<?php
    // Show header
    if ($Page->ShowHeader) {
?>
<?php if ($Page->GroupCount > 1) { ?>
</tbody>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?= $Page->PageBreakHtml ?>
<?php } ?>
<div class="<?= $Page->ReportContainerClass ?>">
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Top pager -->
<div class="card-header ew-grid-upper-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<!-- Report grid (begin) -->
<div id="gmp_Beneficiary_by_Supplier_Report" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>">
<table class="<?= $Page->TableClass ?>">
<thead>
	<!-- Table header -->
    <tr class="ew-table-header">
<?php if ($Page->DistrictName->Visible) { ?>
    <?php if ($Page->DistrictName->ShowGroupHeaderAsRow) { ?>
    <th data-name="DistrictName"<?= $Page->DistrictName->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->DistrictName->groupToggleIcon() ?></th>
    <?php } else { ?>
    <th data-name="DistrictName" class="<?= $Page->DistrictName->headerCellClass() ?>"><div class="Beneficiary_by_Supplier_Report_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->NurseryName->Visible) { ?>
    <?php if ($Page->NurseryName->ShowGroupHeaderAsRow) { ?>
    <th data-name="NurseryName">&nbsp;</th>
    <?php } else { ?>
    <th data-name="NurseryName" class="<?= $Page->NurseryName->headerCellClass() ?>"><div class="Beneficiary_by_Supplier_Report_NurseryName"><?= $Page->renderFieldHeader($Page->NurseryName) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { ?>
    <th data-name="NoOfBeneficiaries" class="<?= $Page->NoOfBeneficiaries->headerCellClass() ?>"><div class="Beneficiary_by_Supplier_Report_NoOfBeneficiaries"><?= $Page->renderFieldHeader($Page->NoOfBeneficiaries) ?></div></th>
<?php } ?>
<?php if ($Page->GRN->Visible) { ?>
    <th data-name="GRN" class="<?= $Page->GRN->headerCellClass() ?>"><div class="Beneficiary_by_Supplier_Report_GRN"><?= $Page->renderFieldHeader($Page->GRN) ?></div></th>
<?php } ?>
<?php if ($Page->Seedlings->Visible) { ?>
    <th data-name="Seedlings" class="<?= $Page->Seedlings->headerCellClass() ?>"><div class="Beneficiary_by_Supplier_Report_Seedlings"><?= $Page->renderFieldHeader($Page->Seedlings) ?></div></th>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { ?>
    <th data-name="FarmingSeason" class="<?= $Page->FarmingSeason->headerCellClass() ?>"><div class="Beneficiary_by_Supplier_Report_FarmingSeason"><?= $Page->renderFieldHeader($Page->FarmingSeason) ?></div></th>
<?php } ?>
<?php if ($Page->SeedType->Visible) { ?>
    <th data-name="SeedType" class="<?= $Page->SeedType->headerCellClass() ?>"><div class="Beneficiary_by_Supplier_Report_SeedType"><?= $Page->renderFieldHeader($Page->SeedType) ?></div></th>
<?php } ?>
    </tr>
</thead>
<tbody>
<?php
        if ($Page->TotalGroups == 0) {
            break; // Show header only
        }
        $Page->ShowHeader = false;
    } // End show header
?>
<?php

    // Build detail SQL
    $where = DetailFilterSql($Page->DistrictName, $Page->getSqlFirstGroupField(), $Page->DistrictName->groupValue(), $Page->Dbid);
    AddFilter($Page->PageFirstGroupFilter, $where, "OR");
    AddFilter($where, $Page->Filter);
    $sql = $Page->buildReportSql($Page->getSqlSelect(), $Page->getSqlFrom(), $Page->getSqlWhere(), $Page->getSqlGroupBy(), $Page->getSqlHaving(), $Page->getSqlOrderBy(), $where, $Page->Sort);
    $rs = $sql->executeQuery();
    $Page->DetailRecords = $rs?->fetchAll() ?? [];
    $Page->DetailRecordCount = count($Page->DetailRecords);

    // Load detail records
    $Page->DistrictName->Records = &$Page->DetailRecords;
    $Page->DistrictName->LevelBreak = true; // Set field level break
        $Page->GroupCounter[1] = $Page->GroupCount;
        $Page->DistrictName->getCnt($Page->DistrictName->Records); // Get record count
?>
<?php if ($Page->DistrictName->Visible && $Page->DistrictName->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 1;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->DistrictName->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="DistrictName" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 1) ?>"<?= $Page->DistrictName->cellAttributes() ?>>
            <span class="ew-summary-caption Beneficiary_by_Supplier_Report_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->DistrictName->viewAttributes() ?>><?= $Page->DistrictName->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->DistrictName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->NurseryName->getDistinctValues($Page->DistrictName->Records, $Page->NurseryName->getSort());
    $Page->setGroupCount(count($Page->NurseryName->DistinctValues), $Page->GroupCounter[1]);
    $Page->GroupCounter[2] = 0; // Init group count index
    foreach ($Page->NurseryName->DistinctValues as $NurseryName) { // Load records for this distinct value
        $Page->NurseryName->setGroupValue($NurseryName); // Set group value
        $Page->NurseryName->getDistinctRecords($Page->DistrictName->Records, $Page->NurseryName->groupValue());
        $Page->NurseryName->LevelBreak = true; // Set field level break
        $Page->GroupCounter[2]++;
        $Page->NurseryName->getCnt($Page->NurseryName->Records); // Get record count
        $Page->setGroupCount($Page->NurseryName->Count, $Page->GroupCounter[1], $Page->GroupCounter[2]);
?>
<?php if ($Page->NurseryName->Visible && $Page->NurseryName->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->NurseryName->setDbValue($NurseryName); // Set current value for NurseryName
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 2;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->NurseryName->Visible) { ?>
        <td data-field="NurseryName"<?= $Page->NurseryName->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->NurseryName->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="NurseryName" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 2) ?>"<?= $Page->NurseryName->cellAttributes() ?>>
            <span class="ew-summary-caption Beneficiary_by_Supplier_Report_NurseryName"><?= $Page->renderFieldHeader($Page->NurseryName) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->NurseryName->viewAttributes() ?>><?= $Page->NurseryName->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->NurseryName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
        $Page->RecordCount = 0; // Reset record count
        foreach ($Page->NurseryName->Records as $record) {
            $Page->RecordCount++;
            $Page->RecordIndex++;
            $Page->loadRowValues($record);
?>
<?php
        // Render detail row
        $Page->resetAttributes();
        $Page->RowType = RowType::DETAIL;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
    <?php if ($Page->DistrictName->ShowGroupHeaderAsRow) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>><span<?= $Page->DistrictName->viewAttributes() ?>><?= $Page->DistrictName->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->NurseryName->Visible) { ?>
    <?php if ($Page->NurseryName->ShowGroupHeaderAsRow) { ?>
        <td data-field="NurseryName"<?= $Page->NurseryName->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="NurseryName"<?= $Page->NurseryName->cellAttributes() ?>><span<?= $Page->NurseryName->viewAttributes() ?>><?= $Page->NurseryName->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { ?>
        <td data-field="NoOfBeneficiaries"<?= $Page->NoOfBeneficiaries->cellAttributes() ?>>
<span<?= $Page->NoOfBeneficiaries->viewAttributes() ?>>
<?= $Page->NoOfBeneficiaries->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->GRN->Visible) { ?>
        <td data-field="GRN"<?= $Page->GRN->cellAttributes() ?>>
<span<?= $Page->GRN->viewAttributes() ?>>
<?= $Page->GRN->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Seedlings->Visible) { ?>
        <td data-field="Seedlings"<?= $Page->Seedlings->cellAttributes() ?>>
<span<?= $Page->Seedlings->viewAttributes() ?>>
<?= $Page->Seedlings->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { ?>
        <td data-field="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>>
<span<?= $Page->FarmingSeason->viewAttributes() ?>>
<?= $Page->FarmingSeason->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->SeedType->Visible) { ?>
        <td data-field="SeedType"<?= $Page->SeedType->cellAttributes() ?>>
<span<?= $Page->SeedType->viewAttributes() ?>>
<?= $Page->SeedType->getViewValue() ?></span>
</td>
<?php } ?>
    </tr>
<?php
    }
    } // End group level 1
?>
<?php

    // Next group
    $Page->loadGroupRowValues();

    // Show header if page break
    if ($Page->isExport()) {
        $Page->ShowHeader = ($Page->ExportPageBreakCount == 0) ? false : ($Page->GroupCount % $Page->ExportPageBreakCount == 0);
    }

    // Page_Breaking server event
    if ($Page->ShowHeader) {
        $Page->pageBreaking($Page->ShowHeader, $Page->PageBreakHtml);
    }
    $Page->GroupCount++;
} // End while
?>
<?php if ($Page->TotalGroups > 0) { ?>
</tbody>
<tfoot>
<?php
    $Page->resetAttributes();
    $Page->RowType = RowType::TOTAL;
    $Page->RowTotalType = RowSummary::GRAND;
    $Page->RowTotalSubType = RowTotal::FOOTER;
    $Page->RowAttrs["class"] = "ew-rpt-grand-summary";
    $Page->renderRow();
?>
<?php if ($Page->DistrictName->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->TotalCount, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate"></td>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { ?>
        <td data-field="NoOfBeneficiaries"<?= $Page->NoOfBeneficiaries->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->NoOfBeneficiaries->viewAttributes() ?>><?= $Page->NoOfBeneficiaries->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->GRN->Visible) { ?>
        <td data-field="GRN"<?= $Page->GRN->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Seedlings->Visible) { ?>
        <td data-field="Seedlings"<?= $Page->Seedlings->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->Seedlings->viewAttributes() ?>><?= $Page->Seedlings->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { ?>
        <td data-field="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->SeedType->Visible) { ?>
        <td data-field="SeedType"<?= $Page->SeedType->cellAttributes() ?>></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<?= FormatNumber($Page->TotalCount, Config("DEFAULT_NUMBER_FORMAT")) ?><?= $Language->phrase("RptDtlRec") ?>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate"><?= $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { ?>
        <td data-field="NoOfBeneficiaries"<?= $Page->NoOfBeneficiaries->cellAttributes() ?>>
<span<?= $Page->NoOfBeneficiaries->viewAttributes() ?>>
<?= $Page->NoOfBeneficiaries->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->GRN->Visible) { ?>
        <td data-field="GRN"<?= $Page->GRN->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Seedlings->Visible) { ?>
        <td data-field="Seedlings"<?= $Page->Seedlings->cellAttributes() ?>>
<span<?= $Page->Seedlings->viewAttributes() ?>>
<?= $Page->Seedlings->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { ?>
        <td data-field="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->SeedType->Visible) { ?>
        <td data-field="SeedType"<?= $Page->SeedType->cellAttributes() ?>></td>
<?php } ?>
    </tr>
<?php } ?>
</tfoot>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?php } ?>
</main>
<!-- /.report-summary -->
<!-- Summary report (end) -->
<?php } ?>
</div>
<!-- /.ew-report -->
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
