<?php

namespace PHPMaker2024\cidp24;

use Slim\Views\PhpRenderer;
use Slim\Csrf\Guard;
use Slim\HttpCache\CacheProvider;
use Slim\Flash\Messages;
use Psr\Container\ContainerInterface;
use Monolog\Logger;
use Monolog\Handler\RotatingFileHandler;
use Doctrine\DBAL\Logging\LoggerChain;
use Doctrine\DBAL\Logging\DebugStack;
use Doctrine\DBAL\Platforms;
use Doctrine\Common\Cache\Psr6\DoctrineProvider;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Tools\Setup;
use Doctrine\ORM\Events;
use Symfony\Component\Cache\Adapter\ArrayAdapter;
use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\Mime\MimeTypes;
use FastRoute\RouteParser\Std;
use Illuminate\Encryption\Encrypter;
use HTMLPurifier_Config;
use HTMLPurifier;

// Connections and entity managers
$definitions = [];
$dbids = array_keys(Config("Databases"));
foreach ($dbids as $dbid) {
    $definitions["connection." . $dbid] = \DI\factory(function (string $dbid) {
        return ConnectDb(Db($dbid));
    })->parameter("dbid", $dbid);
    $definitions["entitymanager." . $dbid] = \DI\factory(function (ContainerInterface $c, string $dbid) {
        $cache = IsDevelopment()
            ? DoctrineProvider::wrap(new ArrayAdapter())
            : DoctrineProvider::wrap(new FilesystemAdapter(directory: Config("DOCTRINE.CACHE_DIR")));
        $config = Setup::createAttributeMetadataConfiguration(
            Config("DOCTRINE.METADATA_DIRS"),
            IsDevelopment(),
            null,
            $cache
        );
        $conn = $c->get("connection." . $dbid);
        return new EntityManager($conn, $config);
    })->parameter("dbid", $dbid);
}

return [
    "app.cache" => \DI\create(CacheProvider::class),
    "app.flash" => fn(ContainerInterface $c) => new Messages(),
    "app.view" => fn(ContainerInterface $c) => new PhpRenderer($GLOBALS["RELATIVE_PATH"] . "views/"),
    "email.view" => fn(ContainerInterface $c) => new PhpRenderer($GLOBALS["RELATIVE_PATH"] . "lang/"),
    "sms.view" => fn(ContainerInterface $c) => new PhpRenderer($GLOBALS["RELATIVE_PATH"] . "lang/"),
    "app.audit" => fn(ContainerInterface $c) => (new Logger("audit"))->pushHandler(new AuditTrailHandler($GLOBALS["RELATIVE_PATH"] . "log/audit.log")), // For audit trail
    "app.logger" => fn(ContainerInterface $c) => (new Logger("log"))->pushHandler(new RotatingFileHandler($GLOBALS["RELATIVE_PATH"] . "log/log.log")),
    "sql.logger" => function (ContainerInterface $c) {
        $loggers = [];
        if (Config("DEBUG")) {
            $loggers[] = $c->get("debug.stack");
        }
        return (count($loggers) > 0) ? new LoggerChain($loggers) : null;
    },
    "app.csrf" => fn(ContainerInterface $c) => new Guard($GLOBALS["ResponseFactory"], Config("CSRF_PREFIX")),
    "html.purifier.config" => fn(ContainerInterface $c) => HTMLPurifier_Config::createDefault(),
    "html.purifier" => fn(ContainerInterface $c) => new HTMLPurifier($c->get("html.purifier.config")),
    "debug.stack" => \DI\create(DebugStack::class),
    "debug.sql.logger" => \DI\create(DebugSqlLogger::class),
    "debug.timer" => \DI\create(Timer::class),
    "app.security" => \DI\create(AdvancedSecurity::class),
    "user.profile" => \DI\create(UserProfile::class),
    "app.session" => \DI\create(HttpSession::class),
    "mime.types" => \DI\create(MimeTypes::class),
    "app.language" => \DI\create(Language::class),
    PermissionMiddleware::class => \DI\create(PermissionMiddleware::class),
    ApiPermissionMiddleware::class => \DI\create(ApiPermissionMiddleware::class),
    JwtMiddleware::class => \DI\create(JwtMiddleware::class),
    Std::class => \DI\create(Std::class),
    Encrypter::class => fn(ContainerInterface $c) => new Encrypter(AesEncryptionKey(base64_decode(Config("AES_ENCRYPTION_KEY"))), Config("AES_ENCRYPTION_CIPHER")),

    // Tables
    "awp" => \DI\create(Awp::class),
    "camp" => \DI\create(Camp::class),
    "CampFarmActivity" => \DI\create(CampFarmActivity::class),
    "currency" => \DI\create(Currency::class),
    "current_ref" => \DI\create(CurrentRef::class),
    "disease" => \DI\create(Disease::class),
    "district" => \DI\create(District::class),
    "facilitator" => \DI\create(Facilitator::class),
    "farm" => \DI\create(Farm::class),
    "farm_inspection" => \DI\create(FarmInspection::class),
    "farm_open_bal" => \DI\create(FarmOpenBal::class),
    "farm_seed_allocate" => \DI\create(FarmSeedAllocate::class),
    "farm_seed_delivered" => \DI\create(FarmSeedDelivered::class),
    "farmer" => \DI\create(Farmer::class),
    "farmer_organisation" => \DI\create(FarmerOrganisation::class),
    "field_type" => \DI\create(FieldType::class),
    "fo_type" => \DI\create(FoType::class),
    "foposition" => \DI\create(Foposition::class),
    "grant" => \DI\create(Grant::class),
    "grant_beneficiary" => \DI\create(GrantBeneficiary::class),
    "lock_status" => \DI\create(LockStatus::class),
    "marital_status" => \DI\create(MaritalStatus::class),
    "monguvillages" => \DI\create(Monguvillages::class),
    "month_ref" => \DI\create(MonthRef::class),
    "musers" => \DI\create(Musers::class),
    "nrc_dups" => \DI\create(NrcDups::class),
    "nursery" => \DI\create(Nursery::class),
    "nursery_ownership" => \DI\create(NurseryOwnership::class),
    "nursery_type" => \DI\create(NurseryType::class),
    "ownership" => \DI\create(Ownership::class),
    "period_type" => \DI\create(PeriodType::class),
    "planting_materials" => \DI\create(PlantingMaterials::class),
    "production_sales" => \DI\create(ProductionSales::class),
    "province" => \DI\create(Province::class),
    "quarter_ref" => \DI\create(QuarterRef::class),
    "security_matrix" => \DI\create(SecurityMatrix::class),
    "seed_variety" => \DI\create(SeedVariety::class),
    "sex" => \DI\create(Sex::class),
    "SummaryFarmActivity" => \DI\create(SummaryFarmActivity::class),
    "trainee" => \DI\create(Trainee::class),
    "training_attendee" => \DI\create(TrainingAttendee::class),
    "training_course" => \DI\create(TrainingCourse::class),
    "training_type" => \DI\create(TrainingType::class),
    "unit_of_measure" => \DI\create(UnitOfMeasure::class),
    "user_role" => \DI\create(UserRole::class),
    "user_status" => \DI\create(UserStatus::class),
    "userlevelpermissions" => \DI\create(Userlevelpermissions::class),
    "userlevels" => \DI\create(Userlevels::class),
    "village" => \DI\create(Village::class),
    "years" => \DI\create(Years::class),
    "yesno" => \DI\create(Yesno::class),
    "goods_received_note" => \DI\create(GoodsReceivedNote::class),
    "famer_farm_view" => \DI\create(FamerFarmView::class),
    "inspection_view" => \DI\create(InspectionView::class),
    "production_view" => \DI\create(ProductionView::class),
    "seed_allocate_view" => \DI\create(SeedAllocateView::class),
    "beneficiary_by_supplier" => \DI\create(BeneficiaryBySupplier::class),
    "farmer_type" => \DI\create(FarmerType::class),
    "farm_view2" => \DI\create(FarmView2::class),
    "grn_view" => \DI\create(GrnView::class),
    "cidp_data" => \DI\create(CidpData::class),
    "beneficiary_by_gender" => \DI\create(BeneficiaryByGender::class),
    "beneficiary_by_gender_view2" => \DI\create(BeneficiaryByGenderView2::class),
    "farm_extra" => \DI\create(FarmExtra::class),
    "farm_notfarmerno" => \DI\create(FarmNotfarmerno::class),
    "farm_seed_allocate_nofamno" => \DI\create(FarmSeedAllocateNofamno::class),
    "farm_seed_allocate_offline" => \DI\create(FarmSeedAllocateOffline::class),
    "farmer_extra" => \DI\create(FarmerExtra::class),
    "farmer_other" => \DI\create(FarmerOther::class),
    "farmers" => \DI\create(Farmers::class),
    "farmers_extra" => \DI\create(FarmersExtra::class),
    "farms_extra" => \DI\create(FarmsExtra::class),
    "farmseed" => \DI\create(Farmseed::class),
    "nursery_ref" => \DI\create(NurseryRef::class),
    "seed_allocate_src" => \DI\create(SeedAllocateSrc::class),
    "supplier_summary_view" => \DI\create(SupplierSummaryView::class),
    "supplier_view" => \DI\create(SupplierView::class),
    "Beneficiary_by_Supplier_Report" => \DI\create(BeneficiaryBySupplierReport::class),
    "Beneficiaries_By_Gender_Report" => \DI\create(BeneficiariesByGenderReport::class),
    "Beneficiaries_By_Supplier_Summary" => \DI\create(BeneficiariesBySupplierSummary::class),
    "Camp_Farm_Activity_Report" => \DI\create(CampFarmActivityReport::class),
    "District_Farm_Activity_Report" => \DI\create(DistrictFarmActivityReport::class),
    "Village_Farm_Activity_report" => \DI\create(VillageFarmActivityReport::class),
    "Farms_Report" => \DI\create(FarmsReport::class),
    "Field_Inspection_Report" => \DI\create(FieldInspectionReport::class),
    "season20_21" => \DI\create(Season2021::class),
    "season19_20" => \DI\create(Season1920::class),

    // User table
    "usertable" => \DI\get("musers"),
] + $definitions;
