<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "user_role" table
 */
#[Entity]
#[Table(name: "user_role")]
class UserRole extends AbstractEntity
{
    public static array $propertyNames = [
        'Role' => 'role',
        'RoleDescription' => 'roleDescription',
    ];

    #[Id]
    #[Column(name: "Role", type: "string", unique: true)]
    private string $role;

    #[Column(name: "RoleDescription", type: "string")]
    private string $roleDescription;

    public function getRole(): string
    {
        return $this->role;
    }

    public function setRole(string $value): static
    {
        $this->role = $value;
        return $this;
    }

    public function getRoleDescription(): string
    {
        return HtmlDecode($this->roleDescription);
    }

    public function setRoleDescription(string $value): static
    {
        $this->roleDescription = RemoveXss($value);
        return $this;
    }
}
