<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "training_type" table
 */
#[Entity]
#[Table(name: "training_type")]
class TrainingType extends AbstractEntity
{
    public static array $propertyNames = [
        'TrainingTypeCode' => 'trainingTypeCode',
        'TrainingType' => 'trainingType',
    ];

    #[Id]
    #[Column(name: "TrainingTypeCode", type: "boolean", unique: true)]
    #[GeneratedValue]
    private bool $trainingTypeCode;

    #[Column(name: "TrainingType", type: "string")]
    private string $trainingType;

    public function getTrainingTypeCode(): bool
    {
        return $this->trainingTypeCode;
    }

    public function setTrainingTypeCode(bool $value): static
    {
        $this->trainingTypeCode = $value;
        return $this;
    }

    public function getTrainingType(): string
    {
        return HtmlDecode($this->trainingType);
    }

    public function setTrainingType(string $value): static
    {
        $this->trainingType = RemoveXss($value);
        return $this;
    }
}
