<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "training_attendee" table
 */
#[Entity]
#[Table(name: "training_attendee")]
class TrainingAttendee extends AbstractEntity
{
    public static array $propertyNames = [
        'TrainingRef' => 'trainingRef',
        'NRC' => 'nrc',
        'Evaluation' => 'evaluation',
        'Rating' => 'rating',
    ];

    #[Id]
    #[Column(name: "TrainingRef", type: "integer")]
    private int $trainingRef;

    #[Id]
    #[Column(name: "NRC", type: "string")]
    private string $nrc;

    #[Column(name: "Evaluation", type: "string", nullable: true)]
    private ?string $evaluation;

    #[Column(name: "Rating", type: "float", nullable: true)]
    private ?float $rating;

    public function __construct(int $trainingRef, string $nrc)
    {
        $this->trainingRef = $trainingRef;
        $this->nrc = $nrc;
    }

    public function getTrainingRef(): int
    {
        return $this->trainingRef;
    }

    public function setTrainingRef(int $value): static
    {
        $this->trainingRef = $value;
        return $this;
    }

    public function getNrc(): string
    {
        return $this->nrc;
    }

    public function setNrc(string $value): static
    {
        $this->nrc = $value;
        return $this;
    }

    public function getEvaluation(): ?string
    {
        return HtmlDecode($this->evaluation);
    }

    public function setEvaluation(?string $value): static
    {
        $this->evaluation = RemoveXss($value);
        return $this;
    }

    public function getRating(): ?float
    {
        return $this->rating;
    }

    public function setRating(?float $value): static
    {
        $this->rating = $value;
        return $this;
    }
}
