<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "season20_21" table
 */
#[Entity]
#[Table(name: "season20_21")]
class Season2021 extends AbstractEntity
{
    public static array $propertyNames = [
        'SerialNo' => 'serialNo',
        'IPC' => 'ipc',
        'PageNo' => 'pageNo',
        'Activity' => 'activity',
        'District' => 'district',
        'Block' => 'block',
        'Camp' => 'camp',
        'NurseryArea' => 'nurseryArea',
        'Zone' => 'zone',
        'ChiefArea' => 'chiefArea',
        'Date' => 'date',
        'Village' => 'village',
        'NameOfFarmer' => 'nameOfFarmer',
        'YearOfBirth' => 'yearOfBirth',
        'Gender' => 'gender',
        'NRC' => 'nrc',
        'SeedlingsReceived20_21' => 'seedlingsReceived2021',
        'FieldType' => 'fieldType',
        'Contact' => 'contact',
    ];

    #[Column(name: "SerialNo", type: "integer", nullable: true)]
    private ?int $serialNo;

    #[Column(name: "IPC", type: "string", nullable: true)]
    private ?string $ipc;

    #[Column(name: "PageNo", type: "integer", nullable: true)]
    private ?int $pageNo;

    #[Column(name: "Activity", type: "string", nullable: true)]
    private ?string $activity;

    #[Column(name: "District", type: "string", nullable: true)]
    private ?string $district;

    #[Column(name: "Block", type: "string", nullable: true)]
    private ?string $block;

    #[Column(name: "Camp", type: "string", nullable: true)]
    private ?string $camp;

    #[Column(name: "NurseryArea", type: "string", nullable: true)]
    private ?string $nurseryArea;

    #[Column(name: "Zone", type: "string", nullable: true)]
    private ?string $zone;

    #[Column(name: "ChiefArea", type: "string", nullable: true)]
    private ?string $chiefArea;

    #[Column(name: "Date", type: "string", nullable: true)]
    private ?string $date;

    #[Column(name: "Village", type: "string", nullable: true)]
    private ?string $village;

    #[Column(name: "NameOfFarmer", type: "string", nullable: true)]
    private ?string $nameOfFarmer;

    #[Column(name: "YearOfBirth", type: "smallint", nullable: true)]
    private ?int $yearOfBirth;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Column(name: "NRC", type: "string", nullable: true)]
    private ?string $nrc;

    #[Column(name: "SeedlingsReceived20_21", type: "integer", nullable: true)]
    private ?int $seedlingsReceived2021;

    #[Column(name: "FieldType", type: "string", nullable: true)]
    private ?string $fieldType;

    #[Column(name: "Contact", type: "string", nullable: true)]
    private ?string $contact;

    public function getSerialNo(): ?int
    {
        return $this->serialNo;
    }

    public function setSerialNo(?int $value): static
    {
        $this->serialNo = $value;
        return $this;
    }

    public function getIpc(): ?string
    {
        return HtmlDecode($this->ipc);
    }

    public function setIpc(?string $value): static
    {
        $this->ipc = RemoveXss($value);
        return $this;
    }

    public function getPageNo(): ?int
    {
        return $this->pageNo;
    }

    public function setPageNo(?int $value): static
    {
        $this->pageNo = $value;
        return $this;
    }

    public function getActivity(): ?string
    {
        return HtmlDecode($this->activity);
    }

    public function setActivity(?string $value): static
    {
        $this->activity = RemoveXss($value);
        return $this;
    }

    public function getDistrict(): ?string
    {
        return HtmlDecode($this->district);
    }

    public function setDistrict(?string $value): static
    {
        $this->district = RemoveXss($value);
        return $this;
    }

    public function getBlock(): ?string
    {
        return HtmlDecode($this->block);
    }

    public function setBlock(?string $value): static
    {
        $this->block = RemoveXss($value);
        return $this;
    }

    public function getCamp(): ?string
    {
        return HtmlDecode($this->camp);
    }

    public function setCamp(?string $value): static
    {
        $this->camp = RemoveXss($value);
        return $this;
    }

    public function getNurseryArea(): ?string
    {
        return HtmlDecode($this->nurseryArea);
    }

    public function setNurseryArea(?string $value): static
    {
        $this->nurseryArea = RemoveXss($value);
        return $this;
    }

    public function getZone(): ?string
    {
        return HtmlDecode($this->zone);
    }

    public function setZone(?string $value): static
    {
        $this->zone = RemoveXss($value);
        return $this;
    }

    public function getChiefArea(): ?string
    {
        return HtmlDecode($this->chiefArea);
    }

    public function setChiefArea(?string $value): static
    {
        $this->chiefArea = RemoveXss($value);
        return $this;
    }

    public function getDate(): ?string
    {
        return HtmlDecode($this->date);
    }

    public function setDate(?string $value): static
    {
        $this->date = RemoveXss($value);
        return $this;
    }

    public function getVillage(): ?string
    {
        return HtmlDecode($this->village);
    }

    public function setVillage(?string $value): static
    {
        $this->village = RemoveXss($value);
        return $this;
    }

    public function getNameOfFarmer(): ?string
    {
        return HtmlDecode($this->nameOfFarmer);
    }

    public function setNameOfFarmer(?string $value): static
    {
        $this->nameOfFarmer = RemoveXss($value);
        return $this;
    }

    public function getYearOfBirth(): ?int
    {
        return $this->yearOfBirth;
    }

    public function setYearOfBirth(?int $value): static
    {
        $this->yearOfBirth = $value;
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getNrc(): ?string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(?string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getSeedlingsReceived2021(): ?int
    {
        return $this->seedlingsReceived2021;
    }

    public function setSeedlingsReceived2021(?int $value): static
    {
        $this->seedlingsReceived2021 = $value;
        return $this;
    }

    public function getFieldType(): ?string
    {
        return HtmlDecode($this->fieldType);
    }

    public function setFieldType(?string $value): static
    {
        $this->fieldType = RemoveXss($value);
        return $this;
    }

    public function getContact(): ?string
    {
        return HtmlDecode($this->contact);
    }

    public function setContact(?string $value): static
    {
        $this->contact = RemoveXss($value);
        return $this;
    }
}
