<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "production_view" table
 */
#[Entity]
#[Table(name: "production_view")]
class ProductionView extends AbstractEntity
{
    public static array $propertyNames = [
        'FarmerName' => 'farmerName',
        'NRC' => 'nrc',
        'DOB' => 'dob',
        'Gender' => 'gender',
        'Age' => 'age',
        'FarmNo' => 'farmNo',
        'FieldType' => 'fieldType',
        'Ownership' => 'ownership',
        'FarmSize' => 'farmSize',
        'FarmSizeEstimated' => 'farmSizeEstimated',
        'TreesPlantedEstimated' => 'treesPlantedEstimated',
        'FarmSizeVerified' => 'farmSizeVerified',
        'TreesPlantedVerified' => 'treesPlantedVerified',
        'MaritalStatus' => 'maritalStatus',
        'PhoneNo' => 'phoneNo',
        'Email' => 'email',
        'Dependants' => 'dependants',
        'MaleChildren' => 'maleChildren',
        'FemaleChildren' => 'femaleChildren',
        'HouseholdHead' => 'householdHead',
        'FarmerOrg' => 'farmerOrg',
        'FarmerOrgPosition' => 'farmerOrgPosition',
        'JoiningDate' => 'joiningDate',
        'CampName' => 'campName',
        'DistrictName' => 'districtName',
        'SeasonYear' => 'seasonYear',
        'CashewProduced' => 'cashewProduced',
        'AmountRealised' => 'amountRealised',
        'SoldTo' => 'soldTo',
        'Comments' => 'comments',
        'Longitude' => 'longitude',
        'Latitude' => 'latitude',
    ];

    #[Column(name: "FarmerName", type: "string")]
    private string $farmerName;

    #[Column(name: "NRC", type: "string")]
    private string $nrc;

    #[Column(name: "DOB", type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Column(name: "Age", type: "float", nullable: true)]
    private ?float $age;

    #[Id]
    #[Column(name: "FarmNo", type: "integer")]
    #[GeneratedValue]
    private int $farmNo;

    #[Column(name: "FieldType", type: "boolean", nullable: true)]
    private ?bool $fieldType;

    #[Column(name: "Ownership", type: "boolean", nullable: true)]
    private ?bool $ownership;

    #[Column(name: "FarmSize", type: "string", nullable: true)]
    private ?string $farmSize;

    #[Column(name: "FarmSizeEstimated", type: "float", nullable: true)]
    private ?float $farmSizeEstimated;

    #[Column(name: "TreesPlantedEstimated", type: "float", nullable: true)]
    private ?float $treesPlantedEstimated;

    #[Column(name: "FarmSizeVerified", type: "float", nullable: true)]
    private ?float $farmSizeVerified;

    #[Column(name: "TreesPlantedVerified", type: "float", nullable: true)]
    private ?float $treesPlantedVerified;

    #[Column(name: "MaritalStatus", type: "boolean", nullable: true)]
    private ?bool $maritalStatus;

    #[Column(name: "PhoneNo", type: "string", nullable: true)]
    private ?string $phoneNo;

    #[Column(name: "Email", type: "string", nullable: true)]
    private ?string $email;

    #[Column(name: "Dependants", type: "boolean", nullable: true)]
    private ?bool $dependants;

    #[Column(name: "MaleChildren", type: "boolean", nullable: true)]
    private ?bool $maleChildren;

    #[Column(name: "FemaleChildren", type: "boolean", nullable: true)]
    private ?bool $femaleChildren;

    #[Column(name: "HouseholdHead", type: "boolean", nullable: true)]
    private ?bool $householdHead;

    #[Column(name: "FarmerOrg", type: "string", nullable: true)]
    private ?string $farmerOrg;

    #[Column(name: "FarmerOrgPosition", type: "string", nullable: true)]
    private ?string $farmerOrgPosition;

    #[Column(name: "JoiningDate", type: "date", nullable: true)]
    private ?DateTime $joiningDate;

    #[Column(name: "CampName", type: "string", nullable: true)]
    private ?string $campName;

    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    #[Id]
    #[Column(name: "SeasonYear", type: "smallint")]
    private int $seasonYear;

    #[Column(name: "CashewProduced", type: "float", nullable: true)]
    private ?float $cashewProduced;

    #[Column(name: "AmountRealised", type: "float", nullable: true)]
    private ?float $amountRealised;

    #[Column(name: "SoldTo", type: "string", nullable: true)]
    private ?string $soldTo;

    #[Column(name: "Comments", type: "string", nullable: true)]
    private ?string $comments;

    #[Column(name: "Longitude", type: "decimal")]
    private string $longitude;

    #[Column(name: "Latitude", type: "decimal")]
    private string $latitude;

    public function __construct(int $farmNo, int $seasonYear)
    {
        $this->farmNo = $farmNo;
        $this->seasonYear = $seasonYear;
    }

    public function getFarmerName(): string
    {
        return HtmlDecode($this->farmerName);
    }

    public function setFarmerName(string $value): static
    {
        $this->farmerName = RemoveXss($value);
        return $this;
    }

    public function getNrc(): string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getAge(): ?float
    {
        return $this->age;
    }

    public function setAge(?float $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getFarmNo(): int
    {
        return $this->farmNo;
    }

    public function setFarmNo(int $value): static
    {
        $this->farmNo = $value;
        return $this;
    }

    public function getFieldType(): ?bool
    {
        return $this->fieldType;
    }

    public function setFieldType(?bool $value): static
    {
        $this->fieldType = $value;
        return $this;
    }

    public function getOwnership(): ?bool
    {
        return $this->ownership;
    }

    public function setOwnership(?bool $value): static
    {
        $this->ownership = $value;
        return $this;
    }

    public function getFarmSize(): ?string
    {
        return HtmlDecode($this->farmSize);
    }

    public function setFarmSize(?string $value): static
    {
        $this->farmSize = RemoveXss($value);
        return $this;
    }

    public function getFarmSizeEstimated(): ?float
    {
        return $this->farmSizeEstimated;
    }

    public function setFarmSizeEstimated(?float $value): static
    {
        $this->farmSizeEstimated = $value;
        return $this;
    }

    public function getTreesPlantedEstimated(): ?float
    {
        return $this->treesPlantedEstimated;
    }

    public function setTreesPlantedEstimated(?float $value): static
    {
        $this->treesPlantedEstimated = $value;
        return $this;
    }

    public function getFarmSizeVerified(): ?float
    {
        return $this->farmSizeVerified;
    }

    public function setFarmSizeVerified(?float $value): static
    {
        $this->farmSizeVerified = $value;
        return $this;
    }

    public function getTreesPlantedVerified(): ?float
    {
        return $this->treesPlantedVerified;
    }

    public function setTreesPlantedVerified(?float $value): static
    {
        $this->treesPlantedVerified = $value;
        return $this;
    }

    public function getMaritalStatus(): ?bool
    {
        return $this->maritalStatus;
    }

    public function setMaritalStatus(?bool $value): static
    {
        $this->maritalStatus = $value;
        return $this;
    }

    public function getPhoneNo(): ?string
    {
        return HtmlDecode($this->phoneNo);
    }

    public function setPhoneNo(?string $value): static
    {
        $this->phoneNo = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getDependants(): ?bool
    {
        return $this->dependants;
    }

    public function setDependants(?bool $value): static
    {
        $this->dependants = $value;
        return $this;
    }

    public function getMaleChildren(): ?bool
    {
        return $this->maleChildren;
    }

    public function setMaleChildren(?bool $value): static
    {
        $this->maleChildren = $value;
        return $this;
    }

    public function getFemaleChildren(): ?bool
    {
        return $this->femaleChildren;
    }

    public function setFemaleChildren(?bool $value): static
    {
        $this->femaleChildren = $value;
        return $this;
    }

    public function getHouseholdHead(): ?bool
    {
        return $this->householdHead;
    }

    public function setHouseholdHead(?bool $value): static
    {
        $this->householdHead = $value;
        return $this;
    }

    public function getFarmerOrg(): ?string
    {
        return HtmlDecode($this->farmerOrg);
    }

    public function setFarmerOrg(?string $value): static
    {
        $this->farmerOrg = RemoveXss($value);
        return $this;
    }

    public function getFarmerOrgPosition(): ?string
    {
        return HtmlDecode($this->farmerOrgPosition);
    }

    public function setFarmerOrgPosition(?string $value): static
    {
        $this->farmerOrgPosition = RemoveXss($value);
        return $this;
    }

    public function getJoiningDate(): ?DateTime
    {
        return $this->joiningDate;
    }

    public function setJoiningDate(?DateTime $value): static
    {
        $this->joiningDate = $value;
        return $this;
    }

    public function getCampName(): ?string
    {
        return HtmlDecode($this->campName);
    }

    public function setCampName(?string $value): static
    {
        $this->campName = RemoveXss($value);
        return $this;
    }

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }

    public function getSeasonYear(): int
    {
        return $this->seasonYear;
    }

    public function setSeasonYear(int $value): static
    {
        $this->seasonYear = $value;
        return $this;
    }

    public function getCashewProduced(): ?float
    {
        return $this->cashewProduced;
    }

    public function setCashewProduced(?float $value): static
    {
        $this->cashewProduced = $value;
        return $this;
    }

    public function getAmountRealised(): ?float
    {
        return $this->amountRealised;
    }

    public function setAmountRealised(?float $value): static
    {
        $this->amountRealised = $value;
        return $this;
    }

    public function getSoldTo(): ?string
    {
        return HtmlDecode($this->soldTo);
    }

    public function setSoldTo(?string $value): static
    {
        $this->soldTo = RemoveXss($value);
        return $this;
    }

    public function getComments(): ?string
    {
        return HtmlDecode($this->comments);
    }

    public function setComments(?string $value): static
    {
        $this->comments = RemoveXss($value);
        return $this;
    }

    public function getLongitude(): string
    {
        return $this->longitude;
    }

    public function setLongitude(string $value): static
    {
        $this->longitude = $value;
        return $this;
    }

    public function getLatitude(): string
    {
        return $this->latitude;
    }

    public function setLatitude(string $value): static
    {
        $this->latitude = $value;
        return $this;
    }
}
