<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "planting_materials" table
 */
#[Entity]
#[Table(name: "planting_materials")]
class PlantingMaterial extends AbstractEntity
{
    public static array $propertyNames = [
        'MaterialCode' => 'materialCode',
        'PlantingMaterials' => 'plantingMaterials',
    ];

    #[Id]
    #[Column(name: "MaterialCode", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $materialCode;

    #[Column(name: "PlantingMaterials", type: "string")]
    private string $plantingMaterials;

    public function getMaterialCode(): int
    {
        return $this->materialCode;
    }

    public function setMaterialCode(int $value): static
    {
        $this->materialCode = $value;
        return $this;
    }

    public function getPlantingMaterials(): string
    {
        return HtmlDecode($this->plantingMaterials);
    }

    public function setPlantingMaterials(string $value): static
    {
        $this->plantingMaterials = RemoveXss($value);
        return $this;
    }
}
