<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "nursery_type" table
 */
#[Entity]
#[Table(name: "nursery_type")]
class NurseryType extends AbstractEntity
{
    public static array $propertyNames = [
        'NurseryTpeCode' => 'nurseryTpeCode',
        'NurseryType' => 'nurseryType',
    ];

    #[Id]
    #[Column(name: "NurseryTpeCode", type: "boolean", unique: true)]
    #[GeneratedValue]
    private bool $nurseryTpeCode;

    #[Column(name: "NurseryType", type: "string")]
    private string $nurseryType;

    public function getNurseryTpeCode(): bool
    {
        return $this->nurseryTpeCode;
    }

    public function setNurseryTpeCode(bool $value): static
    {
        $this->nurseryTpeCode = $value;
        return $this;
    }

    public function getNurseryType(): string
    {
        return HtmlDecode($this->nurseryType);
    }

    public function setNurseryType(string $value): static
    {
        $this->nurseryType = RemoveXss($value);
        return $this;
    }
}
