<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "nursery_ref" table
 */
#[Entity]
#[Table(name: "nursery_ref")]
class NurseryRef extends AbstractEntity
{
    public static array $propertyNames = [
        'ProvinceCode' => 'provinceCode',
        'DistrictCode' => 'districtCode',
        'NurseryCode' => 'nurseryCode',
        'NurseryName' => 'nurseryName',
        'NurseryType' => 'nurseryType',
        'PhysicalAddress' => 'physicalAddress',
        'PostalAddress' => 'postalAddress',
        'Phone' => 'phone',
        'Email' => 'email',
        'NurseryOwnership' => 'nurseryOwnership',
        'SeedVariety' => 'seedVariety',
        'NumberOfMembers' => 'numberOfMembers',
        'FemaleMembers' => 'femaleMembers',
        'MaleMembers' => 'maleMembers',
        'YoungFemales' => 'youngFemales',
        'YoungMales' => 'youngMales',
        'FemalesInManagement' => 'femalesInManagement',
        'MalesInManagement' => 'malesInManagement',
        'Latitude' => 'latitude',
        'Longitude' => 'longitude',
    ];

    #[Column(name: "ProvinceCode", type: "integer")]
    private int $provinceCode;

    #[Column(name: "DistrictCode", type: "integer")]
    private int $districtCode;

    #[Column(name: "NurseryCode", type: "integer")]
    private int $nurseryCode;

    #[Column(name: "NurseryName", type: "string", nullable: true)]
    private ?string $nurseryName;

    #[Column(name: "NurseryType", type: "boolean", nullable: true)]
    private ?bool $nurseryType;

    #[Column(name: "PhysicalAddress", type: "string", nullable: true)]
    private ?string $physicalAddress;

    #[Column(name: "PostalAddress", type: "string", nullable: true)]
    private ?string $postalAddress;

    #[Column(name: "Phone", type: "string", nullable: true)]
    private ?string $phone;

    #[Column(name: "Email", type: "string", nullable: true)]
    private ?string $email;

    #[Column(name: "NurseryOwnership", type: "boolean", nullable: true)]
    private ?bool $nurseryOwnership;

    #[Column(name: "SeedVariety", type: "string", nullable: true)]
    private ?string $seedVariety;

    #[Column(name: "NumberOfMembers", type: "integer", nullable: true)]
    private ?int $numberOfMembers;

    #[Column(name: "FemaleMembers", type: "integer", nullable: true)]
    private ?int $femaleMembers;

    #[Column(name: "MaleMembers", type: "integer", nullable: true)]
    private ?int $maleMembers;

    #[Column(name: "YoungFemales", type: "integer", nullable: true)]
    private ?int $youngFemales;

    #[Column(name: "YoungMales", type: "integer", nullable: true)]
    private ?int $youngMales;

    #[Column(name: "FemalesInManagement", type: "integer", nullable: true)]
    private ?int $femalesInManagement;

    #[Column(name: "MalesInManagement", type: "integer", nullable: true)]
    private ?int $malesInManagement;

    #[Column(name: "Latitude", type: "decimal", nullable: true)]
    private ?string $latitude;

    #[Column(name: "Longitude", type: "decimal", nullable: true)]
    private ?string $longitude;

    public function getProvinceCode(): int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getNurseryCode(): int
    {
        return $this->nurseryCode;
    }

    public function setNurseryCode(int $value): static
    {
        $this->nurseryCode = $value;
        return $this;
    }

    public function getNurseryName(): ?string
    {
        return HtmlDecode($this->nurseryName);
    }

    public function setNurseryName(?string $value): static
    {
        $this->nurseryName = RemoveXss($value);
        return $this;
    }

    public function getNurseryType(): ?bool
    {
        return $this->nurseryType;
    }

    public function setNurseryType(?bool $value): static
    {
        $this->nurseryType = $value;
        return $this;
    }

    public function getPhysicalAddress(): ?string
    {
        return HtmlDecode($this->physicalAddress);
    }

    public function setPhysicalAddress(?string $value): static
    {
        $this->physicalAddress = RemoveXss($value);
        return $this;
    }

    public function getPostalAddress(): ?string
    {
        return HtmlDecode($this->postalAddress);
    }

    public function setPostalAddress(?string $value): static
    {
        $this->postalAddress = RemoveXss($value);
        return $this;
    }

    public function getPhone(): ?string
    {
        return HtmlDecode($this->phone);
    }

    public function setPhone(?string $value): static
    {
        $this->phone = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getNurseryOwnership(): ?bool
    {
        return $this->nurseryOwnership;
    }

    public function setNurseryOwnership(?bool $value): static
    {
        $this->nurseryOwnership = $value;
        return $this;
    }

    public function getSeedVariety(): ?string
    {
        return HtmlDecode($this->seedVariety);
    }

    public function setSeedVariety(?string $value): static
    {
        $this->seedVariety = RemoveXss($value);
        return $this;
    }

    public function getNumberOfMembers(): ?int
    {
        return $this->numberOfMembers;
    }

    public function setNumberOfMembers(?int $value): static
    {
        $this->numberOfMembers = $value;
        return $this;
    }

    public function getFemaleMembers(): ?int
    {
        return $this->femaleMembers;
    }

    public function setFemaleMembers(?int $value): static
    {
        $this->femaleMembers = $value;
        return $this;
    }

    public function getMaleMembers(): ?int
    {
        return $this->maleMembers;
    }

    public function setMaleMembers(?int $value): static
    {
        $this->maleMembers = $value;
        return $this;
    }

    public function getYoungFemales(): ?int
    {
        return $this->youngFemales;
    }

    public function setYoungFemales(?int $value): static
    {
        $this->youngFemales = $value;
        return $this;
    }

    public function getYoungMales(): ?int
    {
        return $this->youngMales;
    }

    public function setYoungMales(?int $value): static
    {
        $this->youngMales = $value;
        return $this;
    }

    public function getFemalesInManagement(): ?int
    {
        return $this->femalesInManagement;
    }

    public function setFemalesInManagement(?int $value): static
    {
        $this->femalesInManagement = $value;
        return $this;
    }

    public function getMalesInManagement(): ?int
    {
        return $this->malesInManagement;
    }

    public function setMalesInManagement(?int $value): static
    {
        $this->malesInManagement = $value;
        return $this;
    }

    public function getLatitude(): ?string
    {
        return $this->latitude;
    }

    public function setLatitude(?string $value): static
    {
        $this->latitude = $value;
        return $this;
    }

    public function getLongitude(): ?string
    {
        return $this->longitude;
    }

    public function setLongitude(?string $value): static
    {
        $this->longitude = $value;
        return $this;
    }
}
