<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "marital_status" table
 */
#[Entity]
#[Table(name: "marital_status")]
class MaritalStatus extends AbstractEntity
{
    public static array $propertyNames = [
        'MaritalStatusCode' => 'maritalStatusCode',
        'MaritalStatus' => 'maritalStatus',
    ];

    #[Id]
    #[Column(name: "MaritalStatusCode", type: "boolean", unique: true)]
    #[GeneratedValue]
    private bool $maritalStatusCode;

    #[Column(name: "MaritalStatus", type: "string")]
    private string $maritalStatus;

    public function getMaritalStatusCode(): bool
    {
        return $this->maritalStatusCode;
    }

    public function setMaritalStatusCode(bool $value): static
    {
        $this->maritalStatusCode = $value;
        return $this;
    }

    public function getMaritalStatus(): string
    {
        return HtmlDecode($this->maritalStatus);
    }

    public function setMaritalStatus(string $value): static
    {
        $this->maritalStatus = RemoveXss($value);
        return $this;
    }
}
